/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.melter.multiblock;

import com.google.common.collect.ImmutableList;
import java.util.List;
import knightminer.tcomplement.melter.blocks.BlockMelter;
import knightminer.tcomplement.melter.tileentity.TileMelter;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.mantle.multiblock.IServantLogic;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockDetection;

public class MultiblockMelter
extends MultiblockDetection {
    private TileMelter tile;
    private Block block;

    public MultiblockMelter(TileMelter tile) {
        this.tile = tile;
    }

    public MultiblockDetection.MultiblockStructure detectMultiblock(World world, BlockPos center, int limit) {
        BlockPos pos = this.tile.func_174877_v();
        this.block = world.func_180495_p(pos).func_177230_c();
        BlockPos below = pos.func_177977_b();
        if (!this.isValidBlock(world, below)) {
            return null;
        }
        return new MultiblockDetection.MultiblockStructure(1, 2, 1, (List)ImmutableList.of((Object)pos, (Object)below));
    }

    public boolean isValidBlock(World world, BlockPos pos) {
        if (!this.isValidSlave(world, pos)) {
            return false;
        }
        if (this.block instanceof BlockMelter) {
            IBlockState state = world.func_180495_p(pos);
            Block tank = state.func_177230_c();
            return tank == ((BlockMelter)this.block).getMelterTank() || tank == this.block && state.func_177229_b(BlockMelter.TYPE) == BlockMelter.MelterType.HEATER;
        }
        return false;
    }

    protected boolean isValidSlave(World world, BlockPos pos) {
        IServantLogic slave;
        BlockPos masterPos;
        if (!world.func_175667_e(pos)) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        return !(te instanceof IServantLogic) || (masterPos = (slave = (IServantLogic)te).getMasterPosition()) == null || this.tile.func_174877_v().equals((Object)masterPos);
    }

    public boolean checkIfMultiblockCanBeRechecked(World world, MultiblockDetection.MultiblockStructure structure) {
        return structure != null && world.func_175707_a(structure.minPos, structure.maxPos);
    }
}

