/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.melter;

import knightminer.tcomplement.common.ClientProxy;
import knightminer.tcomplement.melter.MelterModule;
import knightminer.tcomplement.melter.blocks.BlockAlloyTank;
import knightminer.tcomplement.melter.blocks.BlockMelter;
import knightminer.tcomplement.melter.client.MelterRenderer;
import knightminer.tcomplement.melter.tileentity.TileAlloyTank;
import knightminer.tcomplement.melter.tileentity.TileMelter;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.common.ModelRegisterUtil;
import slimeknights.tconstruct.smeltery.block.BlockTank;
import slimeknights.tconstruct.smeltery.client.TankItemModel;
import slimeknights.tconstruct.smeltery.client.TankRenderer;

public class MelterClientProxy
extends ClientProxy {
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        StateMap alloyTankMap = new StateMap.Builder().func_178442_a(new IProperty[]{BlockAlloyTank.POWERED}).func_178441_a();
        MelterClientProxy.setModelStateMapper(MelterModule.alloyTank, (IStateMapper)alloyTankMap);
        MelterClientProxy.setModelStateMapper(MelterModule.porcelainAlloyTank, (IStateMapper)alloyTankMap);
        this.registerMelterModel((Block)MelterModule.melter);
        ModelRegisterUtil.registerItemModel((Block)MelterModule.alloyTank);
        this.registerMelterModel((Block)MelterModule.porcelainMelter);
        ModelRegisterUtil.registerItemModel((Block)MelterModule.porcelainAlloyTank);
        Item tank = Item.func_150898_a((Block)MelterModule.porcelainTank);
        if (tank != null && tank != Items.field_190931_a) {
            for (BlockTank.TankType type : BlockTank.TankType.values()) {
                ModelLoader.setCustomModelResourceLocation((Item)tank, (int)type.meta, (ModelResourceLocation)new ModelResourceLocation(tank.getRegistryName(), type.func_176610_l()));
            }
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileMelter.class, (TileEntitySpecialRenderer)new MelterRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileAlloyTank.class, (TileEntitySpecialRenderer)new TankRenderer());
    }

    @SubscribeEvent
    public void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        MelterClientProxy.registerItemColors(colors, (stack, tintIndex) -> {
            if (!stack.func_77942_o()) {
                return 0xFFFFFF;
            }
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p());
            if (fluid != null && fluid.amount > 0 && fluid.getFluid() != null) {
                return fluid.getFluid().getColor(fluid);
            }
            return 0xFFFFFF;
        }, new Block[]{MelterModule.porcelainTank, MelterModule.alloyTank, MelterModule.porcelainAlloyTank});
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        for (BlockTank.TankType type : BlockTank.TankType.values()) {
            this.replaceTankModel(event, (Block)MelterModule.porcelainTank, type.func_176610_l());
        }
        this.replaceTankModel(event, MelterModule.alloyTank, "inventory");
        this.replaceTankModel(event, MelterModule.porcelainAlloyTank, "inventory");
    }

    private void registerMelterModel(Block block) {
        Item melter = Item.func_150898_a((Block)block);
        if (melter != null && melter != Items.field_190931_a) {
            for (BlockMelter.MelterType type : BlockMelter.MelterType.values()) {
                String variant = String.format("%s=%s,%s=%s,%s=%s", BlockMelter.ACTIVE.func_177701_a(), BlockMelter.ACTIVE.func_177702_a(Boolean.valueOf(false)), BlockMelter.FACING.func_177701_a(), BlockMelter.FACING.func_177702_a((Enum)EnumFacing.NORTH), BlockMelter.TYPE.func_177701_a(), BlockMelter.TYPE.func_177702_a((Enum)type));
                ModelLoader.setCustomModelResourceLocation((Item)melter, (int)(type.meta << 3), (ModelResourceLocation)new ModelResourceLocation(melter.getRegistryName(), variant));
            }
        }
    }

    private void replaceTankModel(ModelBakeEvent event, Block block, String variant) {
        if (block == null) {
            return;
        }
        ModelResourceLocation loc = new ModelResourceLocation(block.getRegistryName(), variant);
        IBakedModel baked = (IBakedModel)event.getModelRegistry().func_82594_a((Object)loc);
        if (baked != null) {
            event.getModelRegistry().func_82595_a((Object)loc, (Object)new TankItemModel(baked));
        }
    }
}

