/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.library.steelworks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.library.Util;
import knightminer.tcomplement.library.events.TCompRegisterEvent;
import knightminer.tcomplement.library.steelworks.HighOvenFilter;
import knightminer.tcomplement.library.steelworks.IMixRecipe;
import knightminer.tcomplement.library.steelworks.MixAdditive;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.mantle.util.RecipeMatchRegistry;

public class MixRecipe
extends HighOvenFilter
implements IMixRecipe {
    private Map<MixAdditive, MixAdditiveList> additives;
    private static final Random RANDOM = new Random();
    private int minTemp;

    public MixRecipe(@Nonnull FluidStack input, @Nonnull FluidStack output, int temp) {
        super(input, output);
        this.minTemp = temp - 300;
    }

    public MixRecipe(@Nonnull FluidStack input, @Nonnull FluidStack output) {
        this(input, output, output.getFluid().getTemperature(output));
    }

    private boolean additiveMatches(MixAdditive type, ItemStack input) {
        return !this.additives.containsKey((Object)type) || this.additives.get((Object)type).matches(new ItemStack[]{input}).isPresent();
    }

    @Override
    public boolean matches(FluidStack fluid, ItemStack oxidizer, ItemStack reducer, ItemStack purifier) {
        return this.getInput().isFluidEqual(fluid) && (this.additives == null || this.additiveMatches(MixAdditive.OXIDIZER, oxidizer) && this.additiveMatches(MixAdditive.REDUCER, reducer) && this.additiveMatches(MixAdditive.PURIFIER, purifier));
    }

    private boolean additiveValid(MixAdditive type, ItemStack input, int required) {
        return !this.additives.containsKey((Object)type) || input.func_190916_E() >= required;
    }

    @Override
    public boolean canMix(FluidStack fluid, ItemStack oxidizer, ItemStack reducer, ItemStack purifier, int temperature) {
        if (temperature < this.minTemp) {
            return false;
        }
        if (this.additives == null) {
            return true;
        }
        int required = Util.ceilDiv(fluid.amount, this.getInput().amount);
        return this.additiveValid(MixAdditive.OXIDIZER, oxidizer, required) && this.additiveValid(MixAdditive.REDUCER, reducer, required) && this.additiveValid(MixAdditive.PURIFIER, purifier, required);
    }

    private void removeMatches(MixAdditive type, ItemStack input, int matched) {
        if (this.additives == null || !this.additives.containsKey((Object)type)) {
            return;
        }
        int chance = this.additives.get((Object)type).matches(new ItemStack[]{input}).map(m -> m.amount).orElse(100);
        if (chance >= 100) {
            input.func_190918_g(matched);
        } else {
            int shrink = 0;
            for (int i = 0; i < matched; ++i) {
                if (RANDOM.nextInt(100) >= chance) continue;
                ++shrink;
            }
            input.func_190918_g(shrink);
        }
    }

    @Override
    public FluidStack getOutput(FluidStack fluid, int temp) {
        FluidStack output = this.getOutput();
        return new FluidStack(output, fluid.amount * output.amount / this.getInput().amount);
    }

    @Override
    public void updateAdditives(FluidStack fluid, ItemStack oxidizer, ItemStack reducer, ItemStack purifier, int temp) {
        int matches = Util.ceilDiv(fluid.amount, this.getInput().amount);
        if (matches > 0) {
            this.removeMatches(MixAdditive.OXIDIZER, oxidizer, matches);
            this.removeMatches(MixAdditive.REDUCER, reducer, matches);
            this.removeMatches(MixAdditive.PURIFIER, purifier, matches);
        }
    }

    @Override
    public void addAdditive(MixAdditive type, RecipeMatch additive) {
        if (additive != null) {
            if (new TCompRegisterEvent.HighOvenMixAdditiveEvent(this, additive, type).fire()) {
                if (this.additives == null) {
                    this.additives = new EnumMap<MixAdditive, MixAdditiveList>(MixAdditive.class);
                }
                this.additives.computeIfAbsent(type, t -> new MixAdditiveList()).addRecipeMatch(additive);
                TCompRegistry.registerMixAdditive(additive, type);
            } else {
                try {
                    String input = additive.getInputs().stream().findFirst().map(ItemStack::func_77977_a).orElse("?");
                    TCompRegistry.log.debug("Addition of {} {} to recipe {} has been cancelled by event", (Object)type.getName(), (Object)input, (Object)this.getOutput().getUnlocalizedName());
                }
                catch (Exception e) {
                    TCompRegistry.log.error("Error when logging HighOvenMixAdditiveEvent", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.additives != null) {
            for (MixAdditive type : MixAdditive.values()) {
                if (!this.additives.containsKey((Object)type) || !this.additives.get((Object)type).getInputs().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public int getTemperature() {
        return this.minTemp;
    }

    public List<ItemStack> getAdditives(MixAdditive type) {
        if (this.additives == null || !this.additives.containsKey((Object)type)) {
            return Collections.emptyList();
        }
        return this.additives.get((Object)type).getInputs();
    }

    public Integer getAdditiveConsumeChance(MixAdditive type, ItemStack input) {
        if (this.additives == null || !this.additives.containsKey((Object)type)) {
            return null;
        }
        return this.additives.get((Object)type).matches(new ItemStack[]{input}).map(m -> m.amount).orElse(null);
    }

    private static class MixAdditiveList
    extends RecipeMatchRegistry {
        private List<ItemStack> displayItems;

        private MixAdditiveList() {
        }

        public List<ItemStack> getInputs() {
            if (this.displayItems != null) {
                return this.displayItems;
            }
            this.displayItems = this.items.stream().map(RecipeMatch::getInputs).reduce(new ArrayList(), (list, items) -> {
                list.addAll(items);
                return list;
            });
            return this.displayItems;
        }
    }
}

