/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.library.steelworks;

import javax.annotation.Nonnull;
import knightminer.tcomplement.library.steelworks.HighOvenFilter;
import knightminer.tcomplement.library.steelworks.IHeatRecipe;
import net.minecraftforge.fluids.FluidStack;

public class HeatRecipe
extends HighOvenFilter
implements IHeatRecipe {
    private int minTemp;

    public HeatRecipe(@Nonnull FluidStack input, @Nonnull FluidStack output, int temp) {
        super(new FluidStack(input, input.amount / 2), new FluidStack(output, output.amount / 2));
        this.minTemp = temp - 300;
    }

    @Override
    public int timesMatched(FluidStack input, int temp) {
        if (temp < this.minTemp) {
            return 0;
        }
        return Math.min(10 * temp / this.minTemp, input.amount / this.getInput().amount);
    }

    public int getTemperature() {
        return this.minTemp;
    }
}

