/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.common;

import javax.annotation.Nonnull;
import knightminer.tcomplement.common.CommonProxy;
import knightminer.tcomplement.library.Util;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import slimeknights.mantle.item.ItemMetaDynamic;
import slimeknights.tconstruct.shared.client.BakedTableModel;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected void registerItemModelDynamic(ItemMetaDynamic item) {
        if (item != null) {
            item.registerItemModels();
        }
    }

    public void registerFluidModels(Fluid fluid) {
        if (fluid == null) {
            return;
        }
        Block block = fluid.getBlock();
        if (block != null) {
            Item item = Item.func_150898_a((Block)block);
            FluidStateMapper mapper = new FluidStateMapper(fluid);
            if (item != Items.field_190931_a) {
                ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
                ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
            }
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
        }
    }

    protected static void setModelStateMapper(Block block, IStateMapper mapper) {
        if (block != null) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
        }
    }

    protected static void registerItemColors(ItemColors colors, IItemColor handler, Item ... items) {
        for (Item item : items) {
            if (item == null) continue;
            colors.func_186730_a(handler, new Item[]{item});
        }
    }

    protected static void registerItemColors(ItemColors colors, IItemColor handler, Block ... blocks) {
        for (Block block : blocks) {
            if (block == null) continue;
            colors.func_186731_a(handler, new Block[]{block});
        }
    }

    protected static void wrapTableModel(ModelBakeEvent event, ModelResourceLocation loc) {
        IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)loc);
        if (model != null) {
            event.getModelRegistry().func_82595_a((Object)loc, (Object)new BakedTableModel(model, null, DefaultVertexFormats.field_176600_a));
        }
    }

    private static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final ModelResourceLocation location;

        public FluidStateMapper(Fluid fluid) {
            this.location = new ModelResourceLocation(Util.getResource("fluid_block"), fluid.getName());
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            return this.location;
        }

        @Nonnull
        public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
            return this.location;
        }
    }
}

