/*
 * Decompiled with CFR 0.152.
 */
package kport.modularmagic.common.tile;

import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBase;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.SkyCollectionHelper;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.data.Config;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.tiles.base.ColorableMachineTile;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kport.modularmagic.common.tile.machinecomponent.MachineComponentStarlightProviderInput;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileStarlightInput
extends TileReceiverBase
implements MachineComponentTile,
ColorableMachineTile {
    private int starlightAmount = 0;
    private int color = Config.machineColor;

    @Override
    public int getMachineColor() {
        return this.color;
    }

    @Override
    public void setMachineColor(int newColor) {
        if (this.color == newColor) {
            return;
        }
        this.color = newColor;
        ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> ((TileStarlightInput)this).markForUpdate());
    }

    @Nullable
    public MachineComponentStarlightProviderInput provideComponent() {
        return new MachineComponentStarlightProviderInput(this, IOType.INPUT);
    }

    public int getStarlightStored() {
        return this.starlightAmount;
    }

    public void setStarlight(int starlight) {
        this.starlightAmount = starlight;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.getPassiveStarlight()) {
            this.func_70296_d();
        }
    }

    public boolean getPassiveStarlight() {
        int yLevel;
        int prev = this.starlightAmount;
        this.starlightAmount = Math.round((float)this.starlightAmount * 0.95f);
        WorldSkyHandler handler = ConstellationSkyHandler.getInstance().getWorldHandler(this.func_145831_w());
        if (this.field_145850_b.func_175678_i(this.func_174877_v().func_177982_a(0, 1, 0)) && handler != null && (yLevel = this.func_174877_v().func_177956_o()) > 40) {
            float collect = 160.0f;
            float dstr = yLevel > 120 ? 1.0f + (float)(yLevel - 120) / 272.0f : (float)(yLevel - 20) / 100.0f;
            float posDistribution = SkyCollectionHelper.getSkyNoiseDistribution((World)this.field_145850_b, (BlockPos)this.field_174879_c);
            collect *= dstr;
            collect *= 0.6f + 0.4f * posDistribution;
            this.starlightAmount = Math.round(Math.min(10000.0f, (float)this.starlightAmount + (collect *= 0.2f + 0.8f * ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(this.func_145831_w()))));
        }
        return prev != this.starlightAmount;
    }

    public void receiveStarlight(@Nullable IWeakConstellation type, double amount) {
        if (amount <= 0.001) {
            return;
        }
        this.starlightAmount = Math.min(10000, (int)((double)this.starlightAmount + amount * 200.0));
        this.func_70296_d();
    }

    @Nullable
    public String getUnLocalizedDisplayName() {
        return "tile.blockstarlightproviderinput.name";
    }

    @Nonnull
    public ITransmissionReceiver provideEndpoint(BlockPos at) {
        return new TransmissionReceiverStarlightProvider(at);
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74768_a("starlight", this.starlightAmount);
        compound.func_74768_a("casingColor", this.color);
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.starlightAmount = compound.func_74762_e("starlight");
        this.color = compound.func_74762_e("casingColor");
    }

    public static class TransmissionReceiverStarlightProvider
    extends SimpleTransmissionReceiver {
        public TransmissionReceiverStarlightProvider(BlockPos thisPos) {
            super(thisPos);
        }

        public void onStarlightReceive(World world, boolean isChunkLoaded, IWeakConstellation type, double amount) {
            TileStarlightInput te;
            if (isChunkLoaded && (te = (TileStarlightInput)MiscUtils.getTileAt((IBlockAccess)world, (BlockPos)this.getLocationPos(), TileStarlightInput.class, (boolean)false)) != null) {
                te.receiveStarlight(type, amount);
            }
        }

        public TransmissionClassRegistry.TransmissionProvider getProvider() {
            return new StarlightProviderReceiverProvider();
        }
    }

    public static class StarlightProviderReceiverProvider
    implements TransmissionClassRegistry.TransmissionProvider {
        public TransmissionReceiverStarlightProvider provideEmptyNode() {
            return new TransmissionReceiverStarlightProvider(null);
        }

        public String getIdentifier() {
            return "modularmachinery:TransmissionReceiverStarlightProvider";
        }
    }
}

