/*
 * Decompiled with CFR 0.152.
 */
package kport.modularmagic.common.tile;

import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.TileColorableMachineComponent;
import kport.modularmagic.common.tile.machinecomponent.MachineComponentManaProvider;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.ManaNetworkEvent;
import vazkii.botania.common.core.handler.ManaNetworkHandler;

public abstract class TileManaProvider
extends TileColorableMachineComponent
implements ITickable,
IManaReceiver,
MachineComponentTile {
    private static int manaCapacity = 100000;
    private volatile int mana = 0;

    public static void loadFromConfig(Configuration cfg) {
        manaCapacity = cfg.getInt("Mana Capacity", "mods.botania", manaCapacity, 0, Integer.MAX_VALUE, "The maximum amount of mana this mana provider can hold.");
    }

    public void func_73660_a() {
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.mana = compound.func_74762_e("mana");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74768_a("mana", this.mana);
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public boolean isFull() {
        return this.mana >= this.getManaCapacity();
    }

    public synchronized void recieveMana(int amount) {
        this.mana = MathHelper.func_76125_a((int)(this.mana + amount), (int)0, (int)this.getManaCapacity());
        this.markNoUpdateSync();
    }

    public synchronized void reduceMana(int amount) {
        this.mana = MathHelper.func_76125_a((int)(this.mana - amount), (int)0, (int)this.getManaCapacity());
        this.markNoUpdateSync();
    }

    public int getManaCapacity() {
        return manaCapacity;
    }

    public boolean canRecieveManaFromBursts() {
        return false;
    }

    public static class Output
    extends TileManaProvider
    implements IManaPool {
        @Override
        public void func_73660_a() {
            if (!ManaNetworkHandler.instance.isPoolIn((TileEntity)this) && !this.func_145837_r()) {
                ManaNetworkEvent.addPool((TileEntity)this);
            }
        }

        public void func_145843_s() {
            super.func_145843_s();
            ManaNetworkEvent.removePool((TileEntity)this);
        }

        public void onChunkUnload() {
            super.onChunkUnload();
            ManaNetworkEvent.removePool((TileEntity)this);
        }

        public boolean isOutputtingPower() {
            return true;
        }

        public EnumDyeColor getColor() {
            return EnumDyeColor.WHITE;
        }

        public void setColor(EnumDyeColor arg0) {
        }

        public MachineComponentManaProvider provideComponent() {
            return new MachineComponentManaProvider(IOType.OUTPUT, this);
        }
    }

    public static class Input
    extends TileManaProvider {
        public MachineComponentManaProvider provideComponent() {
            return new MachineComponentManaProvider(IOType.INPUT, this);
        }

        @Override
        public boolean canRecieveManaFromBursts() {
            return true;
        }
    }
}

