/*
 * Decompiled with CFR 0.152.
 */
package kport.modularmagic.common.tile;

import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.power.IWorldPowerMultiplier;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.tile.TilePower;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.data.Config;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.tiles.base.ColorableMachineTile;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kport.modularmagic.common.tile.machinecomponent.MachineComponentGridProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;

public abstract class TileGridProvider
extends TilePower
implements IWorldPowerMultiplier,
MachineComponentTile,
ITickable,
ColorableMachineTile {
    private volatile float power;
    private int tick;
    private int color = Config.machineColor;

    @Override
    public int getMachineColor() {
        return this.color;
    }

    @Override
    public void setMachineColor(int newColor) {
        if (this.color == newColor) {
            return;
        }
        this.color = newColor;
        ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.func_70296_d();
        });
    }

    public float multiplier(@Nullable World world) {
        return 1.0f;
    }

    public void onPowerChanged() {
    }

    public float getPower() {
        return this.power;
    }

    public void setPower(float power) {
        this.tick = 2;
        this.power = power;
    }

    public PowerManager.PowerFreq getFreq() {
        return PowerManager.instance.getPowerFreq(this.frequency);
    }

    public void func_73660_a() {
        if (this.tick > 0) {
            --this.tick;
        } else if (this.power != 0.0f) {
            this.power = 0.0f;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.color = nbt.func_74764_b("casingColor") ? nbt.func_74762_e("casingColor") : Config.machineColor;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("casingColor", this.color);
        return nbt;
    }

    public void addToDescriptionPacket(XUPacketBuffer packet) {
        super.addToDescriptionPacket(packet);
        packet.writeInt(this.color);
    }

    public void handleDescriptionPacket(XUPacketBuffer packet) {
        super.handleDescriptionPacket(packet);
        this.color = packet.readInt();
    }

    public static class Output
    extends TileGridProvider {
        public IWorldPowerMultiplier getMultiplier() {
            return this;
        }

        @Nullable
        public MachineComponentGridProvider provideComponent() {
            return new MachineComponentGridProvider(this, IOType.OUTPUT);
        }
    }

    public static class Input
    extends TileGridProvider {
        public IWorldPowerMultiplier getMultiplier() {
            return this;
        }

        @Nullable
        public MachineComponentGridProvider provideComponent() {
            return new MachineComponentGridProvider(this, IOType.INPUT);
        }
    }
}

