/*
 * Decompiled with CFR 0.152.
 */
package kport.modularmagic.common.tile;

import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.data.Config;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.tiles.base.ColorableMachineTile;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import kport.modularmagic.common.crafting.helper.AspectProviderCopy;
import kport.modularmagic.common.tile.machinecomponent.MachineComponentAspectProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.tiles.essentia.TileJarFillable;

public abstract class TileAspectProvider
extends TileJarFillable
implements MachineComponentTile,
ColorableMachineTile {
    private int color = Config.machineColor;

    @Override
    public int getMachineColor() {
        return this.color;
    }

    @Override
    public void setMachineColor(int newColor) {
        if (this.color == newColor) {
            return;
        }
        this.color = newColor;
        ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.func_70296_d();
        });
    }

    public boolean canInputFrom(EnumFacing face) {
        return true;
    }

    public boolean canOutputTo(EnumFacing face) {
        return true;
    }

    public boolean isConnectable(EnumFacing face) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Optional.Method(modid="thaumcraft")
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.amount < 250) {
            TileAspectProvider tileAspectProvider = this;
            synchronized (tileAspectProvider) {
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    this.fillJar(face);
                }
            }
        }
    }

    @Optional.Method(modid="thaumcraft")
    public synchronized int takeEssentia(Aspect aspect, int amount, EnumFacing face) {
        return super.takeEssentia(aspect, amount, face);
    }

    @Optional.Method(modid="thaumcraft")
    public synchronized int addEssentia(Aspect aspect, int amount, EnumFacing face) {
        return super.addEssentia(aspect, amount, face);
    }

    @Optional.Method(modid="thaumcraft")
    public synchronized int addToContainer(Aspect tt, int am) {
        return super.addToContainer(tt, am);
    }

    @Optional.Method(modid="thaumcraft")
    public synchronized boolean takeFromContainer(Aspect tt, int am) {
        return super.takeFromContainer(tt, am);
    }

    @Optional.Method(modid="thaumcraft")
    public synchronized boolean takeFromContainer(AspectList ot) {
        return super.takeFromContainer(ot);
    }

    @Optional.Method(modid="thaumcraft")
    private void fillJar(EnumFacing face) {
        Aspect ta;
        TileEntity te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)face);
        if (te == null) {
            return;
        }
        IEssentiaTransport ic = (IEssentiaTransport)te;
        EnumFacing opposite = face.func_176734_d();
        if (!ic.canOutputTo(opposite)) {
            return;
        }
        if (this.aspect != null && this.amount > 0) {
            ta = this.aspect;
        } else if (ic.getEssentiaAmount(opposite) > 0 && ic.getSuctionAmount(opposite) < this.getSuctionAmount(face) && this.getSuctionAmount(face) >= ic.getMinimumSuction()) {
            ta = ic.getEssentiaType(opposite);
        } else {
            return;
        }
        if (ic.getSuctionAmount(opposite) < this.getSuctionAmount(face)) {
            this.addToContainer(ta, ic.takeEssentia(ta, 1, opposite));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("casingColor", this.color);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.color = nbt.func_74764_b("casingColor") ? nbt.func_74762_e("casingColor") : Config.machineColor;
    }

    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        super.writeSyncNBT(nbt);
        nbt.func_74768_a("casingColor", this.color);
        return nbt;
    }

    public void readSyncNBT(NBTTagCompound nbt) {
        super.readSyncNBT(nbt);
        this.color = nbt.func_74764_b("casingColor") ? nbt.func_74762_e("casingColor") : Config.machineColor;
    }

    public static class Output
    extends TileAspectProvider {
        public MachineComponentAspectProvider provideComponent() {
            return new MachineComponentAspectProvider(new AspectProviderCopy(this), IOType.OUTPUT);
        }
    }

    public static class Input
    extends TileAspectProvider {
        public MachineComponentAspectProvider provideComponent() {
            return new MachineComponentAspectProvider(new AspectProviderCopy(this), IOType.INPUT);
        }
    }
}

