/*
 * Decompiled with CFR 0.152.
 */
package kport.modularmagic.common.crafting.requirement;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.Asyncable;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import kport.modularmagic.common.crafting.component.ComponentImpetus;
import kport.modularmagic.common.crafting.helper.ImpetusProviderCopy;
import kport.modularmagic.common.crafting.requirement.types.RequirementTypeImpetus;
import kport.modularmagic.common.integration.jei.component.JEIComponentImpetus;
import kport.modularmagic.common.integration.jei.ingredient.Impetus;
import kport.modularmagic.common.tile.TileImpetusComponent;
import kport.modularmagic.common.tile.machinecomponent.MachineComponentImpetus;
import net.minecraft.util.math.MathHelper;

public class RequirementImpetus
extends ComponentRequirement.MultiCompParallelizable<Impetus, RequirementTypeImpetus>
implements Asyncable {
    private final int impetus;

    public RequirementImpetus(IOType actionType, int impetus) {
        super(RequirementTypeImpetus.INSTANCE, actionType);
        this.impetus = impetus;
    }

    @Nonnull
    private static List<ImpetusProviderCopy> convertImpetusProviders(List<ProcessingComponent<?>> components) {
        if (components.size() == 1) {
            return Collections.singletonList((ImpetusProviderCopy)components.get(0).getProvidedComponent());
        }
        return Lists.transform(components, component -> component != null ? (ImpetusProviderCopy)component.getProvidedComponent() : null);
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.getComponent();
        return cmp.getComponentType() instanceof ComponentImpetus && cmp instanceof MachineComponentImpetus && cmp.getIOType() == this.getActionType();
    }

    @Override
    @Nonnull
    public List<ProcessingComponent<?>> copyComponents(List<ProcessingComponent<?>> components) {
        ArrayList list = new ArrayList();
        for (ProcessingComponent<?> component : components) {
            list.add(new ProcessingComponent<ImpetusProviderCopy>(component.component(), new ImpetusProviderCopy(((ImpetusProviderCopy)component.providedComponent()).getOriginal()), component.tag()));
        }
        return list;
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        List<ImpetusProviderCopy> impetusCopies = RequirementImpetus.convertImpetusProviders(components);
        switch (this.getActionType()) {
            case INPUT: {
                int taken = this.consumeAll(impetusCopies, context, this.parallelism, true);
                if (taken >= this.parallelism) break;
                return CraftCheck.failure("error.modularmachinery.impetus.less");
            }
            case OUTPUT: {
                int added;
                if (this.ignoreOutputCheck || (added = this.supplyAll(impetusCopies, context, this.parallelism, true)) >= this.parallelism) break;
                return CraftCheck.failure("error.modularmachinery.impetus.space");
            }
        }
        return CraftCheck.success();
    }

    @Override
    public void startCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (this.getActionType() == IOType.INPUT) {
            this.consumeAll(RequirementImpetus.convertImpetusProviders(components), context, this.parallelism, false);
        }
    }

    @Override
    public void finishCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (this.getActionType() == IOType.OUTPUT) {
            this.supplyAll(RequirementImpetus.convertImpetusProviders(components), context, this.parallelism, false);
        }
    }

    @Override
    public int getMaxParallelism(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxParallelism) {
        int n;
        if (this.ignoreOutputCheck && this.actionType == IOType.OUTPUT) {
            return maxParallelism;
        }
        if (this.parallelizeUnaffected) {
            int max;
            switch (this.actionType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INPUT: {
                    int n2 = this.consumeAll(RequirementImpetus.convertImpetusProviders(components), context, 1.0f, true);
                    break;
                }
                case OUTPUT: {
                    int n2 = max = this.supplyAll(RequirementImpetus.convertImpetusProviders(components), context, 1.0f, true);
                }
            }
            if (max >= 1) {
                return maxParallelism;
            }
            return 0;
        }
        switch (this.actionType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case INPUT: {
                n = this.consumeAll(RequirementImpetus.convertImpetusProviders(components), context, maxParallelism, true);
                break;
            }
            case OUTPUT: {
                n = this.supplyAll(RequirementImpetus.convertImpetusProviders(components), context, maxParallelism, true);
            }
        }
        return n;
    }

    private int supplyAll(List<ImpetusProviderCopy> impetusCopies, RecipeCraftingContext context, float maxMultiplier, boolean simulate) {
        int toSupply = Math.round(RecipeModifier.applyModifiers(context, this, (float)this.impetus, false));
        int maxSupply = (int)((float)toSupply * maxMultiplier);
        int totalSupplied = 0;
        for (ImpetusProviderCopy impetusProviderCopy : impetusCopies) {
            totalSupplied = simulate ? (totalSupplied += impetusProviderCopy.supplyImpetus(maxSupply - totalSupplied)) : (totalSupplied += impetusProviderCopy.getOriginal().supplyImpetus(maxSupply - totalSupplied));
            if (totalSupplied < maxSupply) continue;
            break;
        }
        if (totalSupplied < maxSupply) {
            return totalSupplied / toSupply;
        }
        return totalSupplied;
    }

    private int consumeAll(List<ImpetusProviderCopy> impetusCopies, RecipeCraftingContext context, float maxMultiplier, boolean simulate) {
        int toConsume = Math.round(RecipeModifier.applyModifiers(context, this, (float)this.impetus, false));
        int maxConsume = (int)((float)toConsume * maxMultiplier);
        int totalConsumed = 0;
        for (ImpetusProviderCopy impetusProviderCopy : impetusCopies) {
            if (simulate) {
                int impetus = impetusProviderCopy.getImpetus();
                totalConsumed += impetusProviderCopy.consumeImpetus(Math.min(impetus, maxConsume - totalConsumed));
            } else {
                TileImpetusComponent original = impetusProviderCopy.getOriginal();
                int impetus = original.getImpetus();
                totalConsumed += original.consumeImpetus(Math.min(impetus, maxConsume - totalConsumed));
            }
            if (totalConsumed < maxConsume) continue;
            break;
        }
        if (totalConsumed < maxConsume) {
            return totalConsumed / toConsume;
        }
        return totalConsumed;
    }

    public RequirementImpetus deepCopy() {
        return new RequirementImpetus(this.getActionType(), this.impetus);
    }

    public RequirementImpetus deepCopyModified(List<RecipeModifier> modifiers) {
        float newAmount = RecipeModifier.applyModifiers(modifiers, this, (float)this.impetus, false);
        return new RequirementImpetus(this.getActionType(), MathHelper.func_76123_f((float)newAmount));
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        return "component.missing.impetus." + ioType.name().toLowerCase(Locale.ENGLISH);
    }

    public Impetus getImpetus() {
        return new Impetus(this.impetus);
    }

    @Override
    public ComponentRequirement.JEIComponent<Impetus> provideJEIComponent() {
        return new JEIComponentImpetus(this);
    }
}

