/*
 * Decompiled with CFR 0.152.
 */
package kport.modularmagic.common.crafting.requirement;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.lib.RegistriesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.Asyncable;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import kport.modularmagic.common.crafting.component.ComponentGrid;
import kport.modularmagic.common.crafting.requirement.types.ModularMagicRequirements;
import kport.modularmagic.common.crafting.requirement.types.RequirementTypeGrid;
import kport.modularmagic.common.integration.jei.component.JEIComponentGrid;
import kport.modularmagic.common.integration.jei.ingredient.Grid;
import kport.modularmagic.common.tile.TileGridProvider;
import kport.modularmagic.common.tile.machinecomponent.MachineComponentGridProvider;

public class RequirementGrid
extends ComponentRequirement.PerTick<Grid, RequirementTypeGrid>
implements Asyncable {
    public float power;

    public RequirementGrid(IOType actionType, float power) {
        super((RequirementTypeGrid)RegistriesMM.REQUIREMENT_TYPE_REGISTRY.getValue(ModularMagicRequirements.KEY_REQUIREMENT_GRID), actionType);
        this.power = power;
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.getComponent();
        return cmp.getComponentType() instanceof ComponentGrid && cmp instanceof MachineComponentGridProvider && cmp.ioType == this.getActionType();
    }

    @Override
    @Nonnull
    public CraftCheck doIOTick(ProcessingComponent<?> component, RecipeCraftingContext context) {
        TileGridProvider provider = (TileGridProvider)component.getComponent().getContainerProvider();
        switch (this.getActionType()) {
            case OUTPUT: {
                provider.setPower(-this.power);
            }
            case INPUT: {
                provider.setPower(this.power);
            }
        }
        return CraftCheck.success();
    }

    @Override
    public boolean startCrafting(ProcessingComponent<?> component, RecipeCraftingContext context, ResultChance chance) {
        return this.canStartCrafting(component, context, Lists.newArrayList()).isSuccess();
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(ProcessingComponent<?> component, RecipeCraftingContext context, List<ComponentOutputRestrictor> restrictions) {
        TileGridProvider provider = (TileGridProvider)component.getComponent().getContainerProvider();
        if (this.getActionType() == IOType.INPUT && provider.getFreq().getPowerCreated() - provider.getFreq().getPowerDrain() < this.power) {
            return CraftCheck.failure("error.modularmachinery.requirement.grid.less");
        }
        return CraftCheck.success();
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        return "error.modularmachinery.component.invalid";
    }

    public RequirementGrid deepCopy() {
        return this.deepCopyModified(Collections.emptyList());
    }

    public RequirementGrid deepCopyModified(List<RecipeModifier> list) {
        float power = RecipeModifier.applyModifiers(list, this, this.power, false);
        return new RequirementGrid(this.actionType, power);
    }

    public JEIComponentGrid provideJEIComponent() {
        return new JEIComponentGrid(this);
    }
}

