/*
 * Decompiled with CFR 0.152.
 */
package kport.modularmagic.common.crafting.requirement;

import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.lib.RegistriesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.Asyncable;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import kport.modularmagic.common.crafting.component.ComponentAura;
import kport.modularmagic.common.crafting.requirement.types.ModularMagicRequirements;
import kport.modularmagic.common.crafting.requirement.types.RequirementTypeAura;
import kport.modularmagic.common.integration.jei.component.JEIComponentAura;
import kport.modularmagic.common.integration.jei.ingredient.Aura;
import kport.modularmagic.common.tile.TileAuraProvider;
import kport.modularmagic.common.tile.machinecomponent.MachineComponentAuraProvider;
import net.minecraft.util.math.ChunkPos;

public class RequirementAura
extends ComponentRequirement.MultiCompParallelizable<Aura, RequirementTypeAura>
implements Asyncable,
ComponentRequirement.Parallelizable {
    public Aura aura;
    public int max;
    public int min;

    public RequirementAura(IOType type, Aura aura, int max, int min) {
        super((RequirementTypeAura)RegistriesMM.REQUIREMENT_TYPE_REGISTRY.getValue(ModularMagicRequirements.KEY_REQUIREMENT_AURA), type);
        this.aura = aura;
        this.max = max;
        this.min = min;
    }

    @Nonnull
    private static Map<ChunkPos, TileAuraProvider> buildChunkAuraProviderMap(List<ProcessingComponent<?>> components) {
        HashMap<ChunkPos, TileAuraProvider> chunkAuraProviders = new HashMap<ChunkPos, TileAuraProvider>();
        for (ProcessingComponent<?> component : components) {
            TileAuraProvider provider = (TileAuraProvider)component.getComponent().getContainerProvider();
            chunkAuraProviders.putIfAbsent(provider.getChunkPos(), provider);
        }
        return chunkAuraProviders;
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.getComponent();
        return cmp.getComponentType() instanceof ComponentAura && cmp instanceof MachineComponentAuraProvider && cmp.ioType == this.getActionType();
    }

    @Override
    @Nonnull
    public List<ProcessingComponent<?>> copyComponents(List<ProcessingComponent<?>> components) {
        return components;
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        Map<ChunkPos, TileAuraProvider> chunkAuraProviders = RequirementAura.buildChunkAuraProviderMap(components);
        switch (this.actionType) {
            case INPUT: {
                int removed = this.removeAll(chunkAuraProviders.values(), context, this.parallelism, true);
                if (removed >= this.parallelism) break;
                return CraftCheck.failure("error.modularmachinery.requirement.aura.less");
            }
            case OUTPUT: {
                int added = this.addAll(chunkAuraProviders.values(), context, this.parallelism, true);
                if (added >= this.parallelism) break;
                return CraftCheck.failure("error.modularmachinery.requirement.aura.more");
            }
        }
        return CraftCheck.success();
    }

    @Override
    public void startCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (this.actionType == IOType.INPUT) {
            Map<ChunkPos, TileAuraProvider> chunkAuraProviders = RequirementAura.buildChunkAuraProviderMap(components);
            this.removeAll(chunkAuraProviders.values(), context, this.parallelism, false);
        }
    }

    @Override
    public void finishCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (this.actionType == IOType.OUTPUT) {
            Map<ChunkPos, TileAuraProvider> chunkAuraProviders = RequirementAura.buildChunkAuraProviderMap(components);
            this.addAll(chunkAuraProviders.values(), context, this.parallelism, false);
        }
    }

    @Override
    public int getMaxParallelism(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxParallelism) {
        int n;
        if (this.ignoreOutputCheck && this.actionType == IOType.OUTPUT) {
            return maxParallelism;
        }
        Map<ChunkPos, TileAuraProvider> chunkAuraProviders = RequirementAura.buildChunkAuraProviderMap(components);
        if (this.parallelizeUnaffected) {
            int max;
            switch (this.actionType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INPUT: {
                    int n2 = this.removeAll(chunkAuraProviders.values(), context, 1.0f, true);
                    break;
                }
                case OUTPUT: {
                    int n2 = max = this.addAll(chunkAuraProviders.values(), context, 1.0f, true);
                }
            }
            if (max >= 1) {
                return maxParallelism;
            }
            return 0;
        }
        switch (this.actionType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case INPUT: {
                n = this.removeAll(chunkAuraProviders.values(), context, this.parallelism, true);
                break;
            }
            case OUTPUT: {
                n = this.addAll(chunkAuraProviders.values(), context, this.parallelism, true);
            }
        }
        return n;
    }

    private int addAll(Collection<TileAuraProvider> chunkAuraProviders, RecipeCraftingContext context, float maxMultiplier, boolean simulate) {
        int toAdd = (int)Math.round(RecipeModifier.applyModifiers(context, this, (double)this.aura.getAmount(), false));
        int maxAdd = (int)((float)toAdd * maxMultiplier);
        int totalAdded = 0;
        for (TileAuraProvider auraProvider : chunkAuraProviders) {
            Aura aura = auraProvider.getAura();
            if (aura.getType() != this.aura.getType() || aura.getAmount() >= this.max) continue;
            int added = this.max - aura.getAmount();
            totalAdded += added;
            if (!simulate) {
                auraProvider.addAura(new Aura(added, this.aura.getType()));
            }
            if (totalAdded < maxAdd) continue;
            break;
        }
        if (totalAdded < maxAdd) {
            return totalAdded / toAdd;
        }
        return totalAdded;
    }

    private int removeAll(Collection<TileAuraProvider> chunkAuraProviders, RecipeCraftingContext context, float maxMultiplier, boolean simulate) {
        int toRemove = (int)Math.round(RecipeModifier.applyModifiers(context, this, (double)this.aura.getAmount(), false));
        int maxRemove = (int)((float)toRemove * maxMultiplier);
        int totalRemoved = 0;
        for (TileAuraProvider auraProvider : chunkAuraProviders) {
            Aura aura = auraProvider.getAura();
            if (aura.getType() != this.aura.getType() || aura.getAmount() <= this.min) continue;
            int removed = aura.getAmount() - this.min;
            totalRemoved += removed;
            if (!simulate) {
                auraProvider.removeAura(new Aura(removed, this.aura.getType()));
            }
            if (totalRemoved < maxRemove) continue;
            break;
        }
        if (totalRemoved < maxRemove) {
            return totalRemoved / toRemove;
        }
        return totalRemoved;
    }

    @Override
    public ComponentRequirement<Aura, RequirementTypeAura> deepCopy() {
        return this.deepCopyModified(Collections.emptyList());
    }

    @Override
    public ComponentRequirement<Aura, RequirementTypeAura> deepCopyModified(List<RecipeModifier> modifiers) {
        Aura aura = new Aura(Math.round(RecipeModifier.applyModifiers(modifiers, this, (float)this.aura.getAmount(), false)), this.aura.getType());
        return new RequirementAura(this.actionType, aura, this.max, this.min);
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        return "error.modularmachinery.component.invalid";
    }

    @Override
    public ComponentRequirement.JEIComponent<Aura> provideJEIComponent() {
        return new JEIComponentAura(this);
    }
}

