/*
 * Decompiled with CFR 0.152.
 */
package ink.ikx.mmce.common.utils;

import hellfirepvp.modularmachinery.common.util.BlockArray;
import ink.ikx.mmce.common.utils.FluidUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public final class StructureIngredient {
    private final List<ItemIngredient> itemIngredient;
    private final List<FluidIngredient> fluidIngredient;

    public StructureIngredient(List<ItemIngredient> itemIngredient, List<FluidIngredient> fluidIngredient) {
        this.itemIngredient = itemIngredient;
        this.fluidIngredient = fluidIngredient;
    }

    public static StructureIngredient of(World world, BlockPos ctrlPos, BlockArray blockArray) {
        List<ItemIngredient> itemIngredients = blockArray.getBlockStateIngredientList(world, ctrlPos);
        ArrayList<FluidIngredient> fluidIngredients = new ArrayList<FluidIngredient>();
        Iterator<ItemIngredient> iterator = itemIngredients.iterator();
        while (iterator.hasNext()) {
            ItemIngredient itemIngredient = iterator.next();
            BlockPos pos = itemIngredient.pos();
            ArrayList<Tuple<FluidStack, IBlockState>> fluidIngredient = new ArrayList<Tuple<FluidStack, IBlockState>>();
            for (Tuple<ItemStack, IBlockState> tuple : itemIngredient.ingredientList()) {
                IBlockState state = (IBlockState)tuple.func_76340_b();
                FluidStack fluidStack = FluidUtils.getFluidStackFromBlockState(state);
                if (fluidStack == null) continue;
                fluidIngredient.add((Tuple<FluidStack, IBlockState>)new Tuple((Object)fluidStack, (Object)state));
            }
            if (fluidIngredient.isEmpty()) continue;
            fluidIngredients.add(new FluidIngredient(pos, fluidIngredient));
            iterator.remove();
        }
        return new StructureIngredient(itemIngredients, fluidIngredients);
    }

    public StructureIngredient copy() {
        return new StructureIngredient(new ArrayList<ItemIngredient>(this.itemIngredient), new ArrayList<FluidIngredient>(this.fluidIngredient));
    }

    public String toString() {
        return "StructureIngredient[" + "itemIngredient=" + this.itemIngredient + "," + "fluidIngredient=" + this.fluidIngredient + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.itemIngredient != null ? this.itemIngredient.hashCode() : 0);
        result = 31 * result + (this.fluidIngredient != null ? this.fluidIngredient.hashCode() : 0);
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (!Objects.equals(((StructureIngredient)arg0).itemIngredient, this.itemIngredient)) {
            return false;
        }
        return Objects.equals(((StructureIngredient)arg0).fluidIngredient, this.fluidIngredient);
        {
        }
    }

    public List<ItemIngredient> itemIngredient() {
        return this.itemIngredient;
    }

    public List<FluidIngredient> fluidIngredient() {
        return this.fluidIngredient;
    }

    public static final class ItemIngredient {
        private final BlockPos pos;
        private final List<Tuple<ItemStack, IBlockState>> ingredientList;
        private final NBTTagCompound nbt;

        public ItemIngredient(BlockPos pos, List<Tuple<ItemStack, IBlockState>> ingredientList, NBTTagCompound nbt) {
            this.pos = pos;
            this.ingredientList = ingredientList;
            this.nbt = nbt;
        }

        public String toString() {
            return "ItemIngredient[" + "pos=" + this.pos + "," + "ingredientList=" + this.ingredientList + "," + "nbt=" + this.nbt + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.pos != null ? this.pos.hashCode() : 0);
            result = 31 * result + (this.ingredientList != null ? this.ingredientList.hashCode() : 0);
            result = 31 * result + (this.nbt != null ? this.nbt.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((ItemIngredient)arg0).pos, this.pos)) {
                return false;
            }
            if (!Objects.equals(((ItemIngredient)arg0).ingredientList, this.ingredientList)) {
                return false;
            }
            return Objects.equals(((ItemIngredient)arg0).nbt, this.nbt);
            {
            }
        }

        public BlockPos pos() {
            return this.pos;
        }

        public List<Tuple<ItemStack, IBlockState>> ingredientList() {
            return this.ingredientList;
        }

        public NBTTagCompound nbt() {
            return this.nbt;
        }
    }

    public static final class FluidIngredient {
        private final BlockPos pos;
        private final List<Tuple<FluidStack, IBlockState>> ingredientList;

        public FluidIngredient(BlockPos pos, List<Tuple<FluidStack, IBlockState>> ingredientList) {
            this.pos = pos;
            this.ingredientList = ingredientList;
        }

        public String toString() {
            return "FluidIngredient[" + "pos=" + this.pos + "," + "ingredientList=" + this.ingredientList + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.pos != null ? this.pos.hashCode() : 0);
            result = 31 * result + (this.ingredientList != null ? this.ingredientList.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((FluidIngredient)arg0).pos, this.pos)) {
                return false;
            }
            return Objects.equals(((FluidIngredient)arg0).ingredientList, this.ingredientList);
            {
            }
        }

        public BlockPos pos() {
            return this.pos;
        }

        public List<Tuple<FluidStack, IBlockState>> ingredientList() {
            return this.ingredientList;
        }
    }
}

