/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class MiscUtils {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#,###.##");

    public static <K, V, N> Map<K, N> remap(Map<K, V> map, Function<V, N> remapFct) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> remapFct.apply(e.getValue())));
    }

    public static List<String> splitStringBy(String str, String spl) {
        return Lists.newArrayList((Object[])str.split(spl));
    }

    public static BlockPos rotateYCCWNorthUntil(BlockPos at, EnumFacing dir) {
        BlockPos pos = at;
        for (EnumFacing currentFacing = EnumFacing.NORTH; currentFacing != dir; currentFacing = currentFacing.func_176735_f()) {
            pos = new BlockPos(pos.func_177952_p(), pos.func_177956_o(), -pos.func_177958_n());
        }
        return pos;
    }

    public static BlockArray rotateYCCWNorthUntil(BlockArray array, EnumFacing dir) {
        EnumFacing currentFacing = EnumFacing.NORTH;
        BlockArray rot = array;
        while (currentFacing != dir) {
            currentFacing = currentFacing.func_176735_f();
            rot = rot.rotateYCCW();
        }
        return rot;
    }

    public static BlockPos rotateYCCW(BlockPos pos) {
        return new BlockPos(pos.func_177952_p(), pos.func_177956_o(), -pos.func_177958_n());
    }

    public static BlockPos rotateDown(BlockPos pos) {
        return new BlockPos(pos.func_177958_n(), pos.func_177952_p(), -pos.func_177956_o());
    }

    public static BlockPos rotateUp(BlockPos pos) {
        return new BlockPos(pos.func_177958_n(), pos.func_177952_p(), pos.func_177956_o());
    }

    public static <T> List<T> flatten(Collection<List<T>> collection) {
        ArrayList<T> list = new ArrayList<T>(collection.size());
        for (List<T> ts : collection) {
            list.addAll(ts);
        }
        return list;
    }

    @Nullable
    public static <T> T iterativeSearch(Collection<T> collection, Predicate<T> matchingFct) {
        for (T element : collection) {
            if (!matchingFct.test(element)) continue;
            return element;
        }
        return null;
    }

    public static long clamp(long num, long min, long max) {
        if (num < min) {
            return min;
        }
        return Math.min(num, max);
    }

    public static String formatNumber(long value) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        if (value < 1000000L) {
            return (double)Math.round((double)value) / 1000.0 + "K";
        }
        if (value < 1000000000L) {
            return (double)Math.round((double)(value / 1000L)) / 1000.0 + "M";
        }
        if (value < 1000000000000L) {
            return (double)Math.round((double)(value / 1000000L)) / 1000.0 + "G";
        }
        if (value < 1000000000000000L) {
            return (double)Math.round((double)(value / 1000000000L)) / 1000.0 + "T";
        }
        if (value < 1000000000000000000L) {
            return (double)Math.round((double)(value / 1000000000000L)) / 1000.0 + "P";
        }
        return (double)Math.round((double)(value / 1000000000000000L)) / 1000.0 + "E";
    }

    public static String formatNumberToInt(long value) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        if (value < 1000000L) {
            return value / 1000L + "K";
        }
        if (value < 1000000000L) {
            return value / 1000000L + "M";
        }
        if (value < 1000000000000L) {
            return value / 1000000000L + "G";
        }
        if (value < 1000000000000000L) {
            return value / 1000000000000L + "T";
        }
        if (value < 1000000000000000000L) {
            return value / 1000000000000000L + "P";
        }
        return value / 1000000000000000000L + "E";
    }

    public static String formatDecimal(double value) {
        return DECIMAL_FORMAT.format(value);
    }

    public static String formatFloat(float value, int decimalFraction) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(decimalFraction);
        return nf.format(value);
    }

    public static boolean isTextBoxKey(int i) {
        return i == 14 || i == 211 || i == 203 || i == 205 || i == 207 || i == 199 || GuiScreen.func_175278_g((int)i) || GuiScreen.func_175280_f((int)i) || GuiScreen.func_175279_e((int)i) || GuiScreen.func_175277_d((int)i);
    }

    public static String posToString(Vec3i pos) {
        return String.format("X:%s Y:%s Z:%s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }
}

