/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import github.kasuminova.mmce.common.helper.AdvancedItemChecker;
import github.kasuminova.mmce.common.util.OredictCache;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.IItemHandlerImpl;
import hellfirepvp.modularmachinery.common.util.nbt.NBTMatchingHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class ItemUtils {
    public static void decrStackInInventory(ItemStackHandler handler, int slot) {
        if (slot < 0 || slot >= handler.getSlots()) {
            return;
        }
        ItemStack st = handler.getStackInSlot(slot);
        if (st.func_190926_b()) {
            return;
        }
        st.func_190920_e(st.func_190916_E() - 1);
        if (st.func_190916_E() <= 0) {
            handler.setStackInSlot(slot, ItemStack.field_190927_a);
        }
    }

    public static int consumeFromInventoryFuel(IItemHandlerModifiable handler, int fuelAmtToConsume, boolean simulate, @Nullable NBTTagCompound matchNBTTag) {
        Int2ObjectMap<ItemStack> contents = ItemUtils.findItemsIndexedInInventoryFuel(handler, matchNBTTag);
        if (contents.isEmpty()) {
            return fuelAmtToConsume;
        }
        IntIterator intIterator = contents.keySet().iterator();
        while (intIterator.hasNext()) {
            int slot = (Integer)intIterator.next();
            ItemStack inSlot = (ItemStack)contents.get(slot);
            if (inSlot.func_77973_b().hasContainerItem(inSlot)) {
                if (inSlot.func_190916_E() > 1) continue;
                ItemStack stack = ForgeHooks.getContainerItem((ItemStack)inSlot);
                fuelAmtToConsume -= TileEntityFurnace.func_145952_a((ItemStack)inSlot);
                if (!simulate) {
                    handler.setStackInSlot(slot, stack.func_77946_l());
                }
                if (fuelAmtToConsume <= 0) break;
            }
            int fuelPer = TileEntityFurnace.func_145952_a((ItemStack)inSlot);
            int toConsumeDiv = fuelAmtToConsume / fuelPer;
            int fuelMod = fuelAmtToConsume % fuelPer;
            int toConsume = toConsumeDiv + (fuelMod > 0 ? 1 : 0);
            int toRemove = Math.min(toConsume, inSlot.func_190916_E());
            fuelAmtToConsume -= toRemove * fuelPer;
            if (!simulate) {
                handler.setStackInSlot(slot, ItemUtils.copyStackWithSize(inSlot, inSlot.func_190916_E() - toRemove));
            }
            if (fuelAmtToConsume > 0) continue;
            break;
        }
        return fuelAmtToConsume;
    }

    public static boolean consumeFromInventory(IItemHandlerModifiable handler, ItemStack toConsume, boolean simulate, @Nullable NBTTagCompound matchNBTTag) {
        Int2ObjectMap<ItemStack> contents = ItemUtils.findItemsIndexedInInventory(handler, toConsume, false, matchNBTTag);
        if (contents.isEmpty()) {
            return false;
        }
        int cAmt = toConsume.func_190916_E();
        IntIterator intIterator = contents.keySet().iterator();
        while (intIterator.hasNext()) {
            int slot = (Integer)intIterator.next();
            ItemStack inSlot = (ItemStack)contents.get(slot);
            if (inSlot.func_77973_b().hasContainerItem(inSlot)) {
                if (inSlot.func_190916_E() > 1) continue;
                ItemStack stack = ForgeHooks.getContainerItem((ItemStack)inSlot);
                --cAmt;
                if (!simulate) {
                    handler.setStackInSlot(slot, stack.func_77946_l());
                }
                if (cAmt <= 0) break;
            }
            int toRemove = Math.min(cAmt, inSlot.func_190916_E());
            cAmt -= toRemove;
            if (!simulate) {
                handler.setStackInSlot(slot, ItemUtils.copyStackWithSize(inSlot, inSlot.func_190916_E() - toRemove));
            }
            if (cAmt > 0) continue;
            break;
        }
        return cAmt <= 0;
    }

    public static boolean consumeFromInventory(IItemHandlerModifiable handler, ItemStack toConsume, boolean simulate, AdvancedItemChecker itemChecker, TileMultiblockMachineController controller) {
        Int2ObjectMap<ItemStack> contents = ItemUtils.findItemsIndexedInInventory(handler, toConsume, false, itemChecker, controller);
        if (contents.isEmpty()) {
            return false;
        }
        int cAmt = toConsume.func_190916_E();
        IntIterator intIterator = contents.keySet().iterator();
        while (intIterator.hasNext()) {
            int slot = (Integer)intIterator.next();
            ItemStack inSlot = (ItemStack)contents.get(slot);
            if (inSlot.func_77973_b().hasContainerItem(inSlot)) {
                if (inSlot.func_190916_E() > 1) continue;
                ItemStack stack = ForgeHooks.getContainerItem((ItemStack)inSlot);
                --cAmt;
                if (!simulate) {
                    handler.setStackInSlot(slot, stack.func_77946_l());
                }
                if (cAmt <= 0) break;
            }
            int toRemove = Math.min(cAmt, inSlot.func_190916_E());
            cAmt -= toRemove;
            if (!simulate) {
                handler.setStackInSlot(slot, ItemUtils.copyStackWithSize(inSlot, inSlot.func_190916_E() - toRemove));
            }
            if (cAmt > 0) continue;
            break;
        }
        return cAmt <= 0;
    }

    public static int consumeAll(IItemHandlerModifiable handler, ItemStack toConsume, AdvancedItemChecker itemChecker, TileMultiblockMachineController controller) {
        Int2ObjectMap<ItemStack> contents = ItemUtils.findItemsIndexedInInventory(handler, toConsume, false, itemChecker, controller);
        if (toConsume.func_190916_E() <= 0 || contents.isEmpty()) {
            return 0;
        }
        return ItemUtils.consumeAllInternal(handler, contents, toConsume.func_190916_E());
    }

    public static int consumeAll(IItemHandlerModifiable handler, ItemStack toConsume, @Nullable NBTTagCompound matchNBTTag) {
        Int2ObjectMap<ItemStack> contents = ItemUtils.findItemsIndexedInInventory(handler, toConsume, false, matchNBTTag);
        if (toConsume.func_190916_E() <= 0 || contents.isEmpty()) {
            return 0;
        }
        return ItemUtils.consumeAllInternal(handler, contents, toConsume.func_190916_E());
    }

    public static int consumeAll(IItemHandlerModifiable handler, String oreName, int amount, AdvancedItemChecker itemChecker, TileMultiblockMachineController controller) {
        Int2ObjectMap<ItemStack> contents = ItemUtils.findItemsIndexedInInventoryOreDict(handler, oreName, itemChecker, controller);
        if (amount <= 0 || contents.isEmpty()) {
            return 0;
        }
        return ItemUtils.consumeAllInternal(handler, contents, amount);
    }

    public static int consumeAll(IItemHandlerModifiable handler, String oreName, int amount, @Nullable NBTTagCompound matchNBTTag) {
        Int2ObjectMap<ItemStack> contents = ItemUtils.findItemsIndexedInInventoryOreDict(handler, oreName, matchNBTTag);
        if (amount <= 0 || contents.isEmpty()) {
            return 0;
        }
        return ItemUtils.consumeAllInternal(handler, contents, amount);
    }

    public static int insertAll(@Nonnull ItemStack stack, IItemHandlerModifiable handler, int maxInsert) {
        if (stack.func_190916_E() <= 0) {
            return 0;
        }
        int inserted = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            int toInsert;
            int maxStackSize = handler.getSlotLimit(i);
            ItemStack in = handler.getStackInSlot(i);
            int count = in.func_190916_E();
            if (count >= maxStackSize) continue;
            if (in.func_190926_b()) {
                toInsert = Math.min(maxInsert - inserted, maxStackSize);
                handler.setStackInSlot(i, ItemUtils.copyStackWithSize(stack, toInsert));
                inserted += toInsert;
            } else if (ItemUtils.stackEqualsNonNBT(stack, in) && ItemUtils.matchTags(stack, in)) {
                toInsert = Math.min(maxInsert - inserted, maxStackSize - count);
                handler.setStackInSlot(i, ItemUtils.copyStackWithSize(stack, toInsert + count));
                inserted += toInsert;
            }
            if (inserted >= maxInsert) break;
        }
        return inserted;
    }

    private static int consumeAllInternal(IItemHandlerModifiable handler, Int2ObjectMap<ItemStack> contents, int maxConsume) {
        int cAmt = 0;
        for (Int2ObjectMap.Entry content : contents.int2ObjectEntrySet()) {
            int slot = content.getIntKey();
            ItemStack stack = (ItemStack)content.getValue();
            int count = stack.func_190916_E();
            if (count > 1 && stack.func_77973_b().hasContainerItem(stack)) continue;
            int toConsume = Math.min(maxConsume - cAmt, count);
            handler.setStackInSlot(slot, ItemUtils.copyStackWithSize(stack, count - toConsume));
            if ((cAmt += toConsume) < maxConsume) continue;
            break;
        }
        return cAmt;
    }

    public static boolean stackEqualsNonNBT(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        if (stack.func_190926_b() && other.func_190926_b()) {
            return true;
        }
        if (stack.func_190926_b() || other.func_190926_b()) {
            return false;
        }
        Item sItem = stack.func_77973_b();
        Item oItem = other.func_77973_b();
        if (sItem.func_77614_k() || oItem.func_77614_k()) {
            return sItem.equals(other.func_77973_b()) && (stack.func_77952_i() == other.func_77952_i() || stack.func_77952_i() == Short.MAX_VALUE || other.func_77952_i() == Short.MAX_VALUE);
        }
        return sItem.equals(other.func_77973_b());
    }

    public static boolean matchTags(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        return ItemStack.func_77970_a((ItemStack)stack, (ItemStack)other);
    }

    @Nonnull
    public static ItemStack copyStackWithSize(@Nonnull ItemStack stack, int amount) {
        if (stack.func_190926_b() || amount <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack s = stack.func_77946_l();
        s.func_190920_e(amount);
        return s;
    }

    public static ItemStack insertItemStackToContainer(IItemHandler external, ItemStack willBeInserted) {
        ItemStack beInserted = willBeInserted;
        for (int externalSlotId = 0; externalSlotId < external.getSlots(); ++externalSlotId) {
            ItemStack notInserted;
            ItemStack stackInSlot = external.getStackInSlot(externalSlotId);
            if (stackInSlot.func_190926_b()) {
                notInserted = external.insertItem(externalSlotId, beInserted, false);
                if (notInserted.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                beInserted = notInserted;
                continue;
            }
            if (!ItemUtils.matchStacks(stackInSlot, willBeInserted)) continue;
            notInserted = external.insertItem(externalSlotId, beInserted, false);
            if (notInserted.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            beInserted = notInserted;
        }
        return beInserted;
    }

    public static Int2ObjectMap<ItemStack> findItemsIndexedInInventoryFuel(IItemHandlerModifiable handler, @Nullable NBTTagCompound matchNBTTag) {
        Int2ObjectOpenHashMap stacksOut = new Int2ObjectOpenHashMap(handler.getSlots() * 2);
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack s = handler.getStackInSlot(j);
            if (TileEntityFurnace.func_145952_a((ItemStack)s) <= 0 || !NBTMatchingHelper.matchNBTCompound(matchNBTTag, s.func_77978_p())) continue;
            stacksOut.put(j, (Object)s);
        }
        return stacksOut;
    }

    public static Int2ObjectMap<ItemStack> findItemsIndexedInInventoryOreDict(IItemHandlerModifiable handler, String oreDict, @Nullable NBTTagCompound matchNBTTag) {
        Int2ObjectOpenHashMap stacksOut = new Int2ObjectOpenHashMap(handler.getSlots() * 2);
        block0: for (int j = 0; j < handler.getSlots(); ++j) {
            int[] ids;
            ItemStack s = handler.getStackInSlot(j);
            if (s.func_190926_b()) continue;
            for (int id : ids = OredictCache.getOreIDsFast(s)) {
                if (!OreDictionary.getOreName((int)id).equals(oreDict) || !NBTMatchingHelper.matchNBTCompound(matchNBTTag, s.func_77978_p())) continue;
                stacksOut.put(j, (Object)s);
                continue block0;
            }
        }
        return stacksOut;
    }

    public static Int2ObjectMap<ItemStack> findItemsIndexedInInventoryOreDict(IItemHandlerModifiable handler, String oreDict, AdvancedItemChecker itemChecker, TileMultiblockMachineController controller) {
        Int2ObjectOpenHashMap stacksOut = new Int2ObjectOpenHashMap(handler.getSlots() * 2);
        block0: for (int j = 0; j < handler.getSlots(); ++j) {
            int[] ids;
            ItemStack s = handler.getStackInSlot(j);
            if (s.func_190926_b()) continue;
            for (int id : ids = OredictCache.getOreIDsFast(s)) {
                if (!OreDictionary.getOreName((int)id).equals(oreDict) || !itemChecker.isMatch(controller, s)) continue;
                stacksOut.put(j, (Object)s);
                continue block0;
            }
        }
        return stacksOut;
    }

    public static Int2ObjectMap<ItemStack> findItemsIndexedInInventory(IItemHandlerModifiable handler, ItemStack match, boolean strict, @Nullable NBTTagCompound matchNBTTag) {
        Int2ObjectOpenHashMap stacksOut = new Int2ObjectOpenHashMap(handler.getSlots() * 2);
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack s = handler.getStackInSlot(j);
            if (!(strict ? ItemUtils.matchStacks(s, match) : ItemUtils.matchStackLoosely(s, match)) || !NBTMatchingHelper.matchNBTCompound(matchNBTTag, s.func_77978_p())) continue;
            stacksOut.put(j, (Object)s);
        }
        return stacksOut;
    }

    public static Int2ObjectMap<ItemStack> findItemsIndexedInInventory(IItemHandlerModifiable handler, ItemStack match, boolean strict, AdvancedItemChecker itemChecker, TileMultiblockMachineController controller) {
        Int2ObjectOpenHashMap stacksOut = new Int2ObjectOpenHashMap(handler.getSlots() * 2);
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack s = handler.getStackInSlot(j);
            if (!(strict ? ItemUtils.matchStacks(s, match) : ItemUtils.matchStackLoosely(s, match)) || !itemChecker.isMatch(controller, s)) continue;
            stacksOut.put(j, (Object)s);
        }
        return stacksOut;
    }

    public static boolean matchStacks(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)other)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack, (ItemStack)other);
    }

    public static boolean matchStackLoosely(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        if (stack.func_190926_b()) {
            return other.func_190926_b();
        }
        return OreDictionary.itemMatches((ItemStack)other, (ItemStack)stack, (boolean)false);
    }

    public static boolean stackNotInList(List<ItemStack> list, ItemStack stackFromBlockState) {
        for (ItemStack stack : list) {
            if (!ItemUtils.matchStacks(stackFromBlockState, stack)) continue;
            return false;
        }
        return true;
    }

    public static ItemStack getOredictItem(RecipeCraftingContext context, String oreDictName, NBTTagCompound tag) {
        ItemStack oreInstance;
        ItemStack stack = ItemStack.field_190927_a;
        Iterator iterator = OreDictionary.getOres((String)oreDictName).iterator();
        while (iterator.hasNext() && ((oreInstance = (ItemStack)iterator.next()).func_190926_b() || (stack = ItemUtils.copyStackWithSize(oreInstance, 1)).func_190926_b())) {
        }
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Unknown ItemStack: Cannot find an item in oredict '" + oreDictName + "'!");
        }
        if (tag != null) {
            stack.func_77982_d(tag.func_74737_b());
        }
        return stack;
    }

    @Nonnull
    public static List<ProcessingComponent<?>> copyItemHandlerComponents(List<ProcessingComponent<?>> components) {
        ArrayList list = new ArrayList();
        for (ProcessingComponent<?> component : components) {
            Object provided = component.getProvidedComponent();
            IItemHandlerImpl handler = null;
            if (provided instanceof IItemHandlerImpl) {
                IItemHandlerImpl handlerMM = (IItemHandlerImpl)provided;
                handler = handlerMM.copy();
            } else if (provided instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable handlerDefault = (IItemHandlerModifiable)provided;
                handler = new IItemHandlerImpl(handlerDefault);
            }
            if (handler == null) continue;
            list.add(new ProcessingComponent<IItemHandlerImpl>(component.component(), handler, component.getTag()));
        }
        return list;
    }

    @Nonnull
    public static List<ProcessingComponent<?>> fastCopyItemHandlerComponents(List<ProcessingComponent<?>> components) {
        ArrayList list = new ArrayList();
        for (ProcessingComponent<?> component : components) {
            ProcessingComponent<IItemHandlerImpl> objectProcessingComponent = new ProcessingComponent<IItemHandlerImpl>(component.component(), ((IItemHandlerImpl)component.getProvidedComponent()).fastCopy(), component.getTag());
            list.add(objectProcessingComponent);
        }
        return list;
    }
}

