/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandlerModifiable;

public class IItemHandlerImpl
implements IItemHandlerModifiable {
    public static final int DEFAULT_SLOT_LIMIT = 64;
    public boolean allowAnySlots = false;
    public EnumFacing[] accessibleSides = new EnumFacing[0];
    protected int[] slotLimits = new int[]{64};
    protected SlotStackHolder[] inventory = new SlotStackHolder[]{new SlotStackHolder(0)};
    protected int[] inSlots = new int[0];
    protected int[] outSlots = new int[0];
    protected int[] miscSlots = new int[0];

    protected IItemHandlerImpl() {
    }

    public IItemHandlerImpl(int[] inSlots, int[] outSlots) {
        this(inSlots, outSlots, EnumFacing.field_82609_l);
    }

    public IItemHandlerImpl(int[] inSlots, int[] outSlots, EnumFacing[] accessibleFrom) {
        this.inSlots = inSlots;
        this.outSlots = outSlots;
        int max = Math.max(IItemHandlerImpl.getArrayMax(inSlots), IItemHandlerImpl.getArrayMax(outSlots));
        this.inventory = new SlotStackHolder[max + 1];
        this.slotLimits = new int[max + 1];
        Arrays.fill(this.slotLimits, 64);
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = new SlotStackHolder(i);
        }
        this.accessibleSides = accessibleFrom;
        System.arraycopy(accessibleFrom, 0, this.accessibleSides, 0, accessibleFrom.length);
    }

    public IItemHandlerImpl(IItemHandlerModifiable handler) {
        int i;
        int slots = handler.getSlots();
        int[] inSlots = new int[slots];
        for (int i2 = 0; i2 < slots; ++i2) {
            inSlots[i2] = i2;
        }
        int[] outSlots = new int[slots];
        for (i = 0; i < slots; ++i) {
            outSlots[i] = i;
        }
        this.inSlots = inSlots;
        this.outSlots = outSlots;
        this.accessibleSides = EnumFacing.field_82609_l;
        this.inventory = new SlotStackHolder[slots];
        for (i = 0; i < slots; ++i) {
            SlotStackHolder holder = new SlotStackHolder(i);
            ItemStack stackInSlot = handler.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) {
                holder.itemStack.set(ItemStack.field_190927_a);
            } else {
                holder.itemStack.set(stackInSlot.func_77946_l());
            }
            this.inventory[i] = holder;
        }
    }

    protected static boolean arrayContains(int[] array, int i) {
        return Arrays.binarySearch(array, i) >= 0;
    }

    protected static boolean canMergeItemStacks(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        if (stack.func_190926_b() || other.func_190926_b() || !stack.func_77985_e() || !other.func_77985_e()) {
            return false;
        }
        return stack.func_77969_a(other) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)other);
    }

    protected static int getArrayMax(int[] slots) {
        int max = 0;
        for (int slot : slots) {
            if (slot <= max) continue;
            max = slot;
        }
        return max;
    }

    public IItemHandlerImpl copy() {
        IItemHandlerImpl copy = new IItemHandlerImpl(this.inSlots, this.outSlots, this.accessibleSides);
        for (int i = 0; i < this.inventory.length; ++i) {
            copy.inventory[i] = this.inventory[i].copy();
        }
        System.arraycopy(this.slotLimits, 0, copy.slotLimits, 0, this.slotLimits.length);
        return copy;
    }

    public IItemHandlerImpl fastCopy() {
        IItemHandlerImpl copy = new IItemHandlerImpl();
        copy.inSlots = this.inSlots;
        copy.outSlots = this.outSlots;
        copy.miscSlots = this.miscSlots;
        copy.inventory = new SlotStackHolder[this.inventory.length];
        for (int i = 0; i < this.inventory.length; ++i) {
            copy.inventory[i] = this.inventory[i].fastCopy();
        }
        copy.slotLimits = this.slotLimits;
        return copy;
    }

    public IItemHandlerImpl setMiscSlots(int ... miscSlots) {
        this.miscSlots = miscSlots;
        int max = IItemHandlerImpl.getArrayMax(miscSlots);
        this.checkSlotLimitsLength(max);
        this.checkInventoryLength(max);
        for (int slot : miscSlots) {
            this.inventory[slot] = new SlotStackHolder(slot);
        }
        return this;
    }

    public IItemHandlerImpl setStackLimit(int limit, int ... slots) {
        int max = IItemHandlerImpl.getArrayMax(slots);
        this.checkSlotLimitsLength(max);
        this.checkInventoryLength(max);
        for (int slot : slots) {
            this.slotLimits[slot] = limit;
        }
        return this;
    }

    public IItemHandlerModifiable asGUIAccess() {
        return new GuiAccess(this);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (slot <= -1 || slot >= this.inventory.length) {
            return;
        }
        this.inventory[slot].itemStack.set(stack);
    }

    public int getSlots() {
        return this.inventory.length;
    }

    public int getSlotLimit(int slot) {
        if (slot < 0 || slot >= this.slotLimits.length) {
            return 64;
        }
        return this.slotLimits[slot];
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.inventory.length) {
            return ItemStack.field_190927_a;
        }
        SlotStackHolder holder = this.inventory[slot];
        if (holder != null) {
            return holder.itemStack.get();
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return stack;
        }
        return this.insertItemInternal(slot, stack, simulate);
    }

    protected ItemStack insertItemInternal(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.allowAnySlots && !IItemHandlerImpl.arrayContains(this.inSlots, slot)) {
            return stack;
        }
        SlotStackHolder holder = this.inventory[slot];
        if (holder == null) {
            return stack;
        }
        ItemStack toInsert = ItemUtils.copyStackWithSize(stack, stack.func_190916_E());
        if (!holder.itemStack.get().func_190926_b()) {
            ItemStack existing = ItemUtils.copyStackWithSize(holder.itemStack.get(), holder.itemStack.get().func_190916_E());
            int max = Math.min(existing.func_77976_d(), this.getSlotLimit(slot));
            if (existing.func_190916_E() >= max || !IItemHandlerImpl.canMergeItemStacks(existing, toInsert)) {
                return stack;
            }
            int movable = Math.min(max - existing.func_190916_E(), stack.func_190916_E());
            if (!simulate) {
                holder.itemStack.get().func_190917_f(movable);
            }
            if (movable >= stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack copy = stack.func_77946_l();
            copy.func_190918_g(movable);
            return copy;
        }
        int max = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
        if (max >= stack.func_190916_E()) {
            if (!simulate) {
                holder.itemStack.set(stack.func_77946_l());
            }
            return ItemStack.field_190927_a;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(max);
        if (!simulate) {
            holder.itemStack.set(copy);
        }
        copy = stack.func_77946_l();
        copy.func_190918_g(max);
        return copy;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractItemInternal(slot, amount, simulate);
    }

    protected ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        if (!this.allowAnySlots && !IItemHandlerImpl.arrayContains(this.outSlots, slot)) {
            return ItemStack.field_190927_a;
        }
        SlotStackHolder holder = this.inventory[slot];
        if (holder == null) {
            return ItemStack.field_190927_a;
        }
        if (holder.itemStack.get().func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack extract = ItemUtils.copyStackWithSize(holder.itemStack.get(), Math.min(amount, holder.itemStack.get().func_190916_E()));
        if (extract.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            holder.itemStack.set(ItemUtils.copyStackWithSize(holder.itemStack.get(), holder.itemStack.get().func_190916_E() - extract.func_190916_E()));
        }
        return extract;
    }

    public void clear() {
        for (SlotStackHolder holder : this.inventory) {
            holder.itemStack.set(ItemStack.field_190927_a);
        }
    }

    public boolean hasCapability(EnumFacing facing) {
        return facing == null || Arrays.binarySearch(this.accessibleSides, facing) >= 0;
    }

    public IItemHandlerModifiable getCapability(EnumFacing facing) {
        if (this.hasCapability(facing)) {
            return this;
        }
        return null;
    }

    protected void checkSlotLimitsLength(int max) {
        int required = max + 1;
        int invLength = this.slotLimits.length;
        if (required > invLength) {
            int[] tmp = new int[required];
            Arrays.fill(tmp, invLength, max, 64);
            System.arraycopy(this.slotLimits, 0, tmp, 0, invLength);
            this.slotLimits = tmp;
        }
    }

    protected void checkInventoryLength(int max) {
        int required = max + 1;
        int invLength = this.inventory.length;
        if (required > invLength) {
            SlotStackHolder[] tmp = new SlotStackHolder[required];
            for (int i = invLength; i < max; ++i) {
                tmp[i] = new SlotStackHolder(i);
            }
            System.arraycopy(this.inventory, 0, tmp, 0, invLength);
            this.inventory = tmp;
        }
    }

    public static class SlotStackHolder {
        public final int slotId;
        public final AtomicReference<ItemStack> itemStack = new AtomicReference<ItemStack>(ItemStack.field_190927_a);

        public SlotStackHolder(int slotId) {
            this.slotId = slotId;
        }

        public SlotStackHolder copy() {
            SlotStackHolder copied = new SlotStackHolder(this.slotId);
            ItemStack holderStack = this.itemStack.get();
            if (!holderStack.func_190926_b()) {
                copied.itemStack.set(holderStack.func_77946_l());
            }
            return copied;
        }

        public SlotStackHolder fastCopy() {
            SlotStackHolder copied = new SlotStackHolder(this.slotId);
            ItemStack holderStack = this.itemStack.get();
            if (!holderStack.func_190926_b()) {
                copied.itemStack.set(holderStack);
            }
            return copied;
        }
    }

    public static class GuiAccess
    implements IItemHandlerModifiable {
        private final IItemHandlerImpl inventory;

        public GuiAccess(IItemHandlerImpl inventory) {
            this.inventory = inventory;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.inventory.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.inventory.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.inventory.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            boolean allowPrev = this.inventory.allowAnySlots;
            this.inventory.allowAnySlots = true;
            ItemStack insert = this.inventory.insertItem(slot, stack, simulate);
            this.inventory.allowAnySlots = allowPrev;
            return insert;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            boolean allowPrev = this.inventory.allowAnySlots;
            this.inventory.allowAnySlots = true;
            ItemStack extract = this.inventory.extractItem(slot, Math.min(amount, 64), simulate);
            this.inventory.allowAnySlots = allowPrev;
            return extract;
        }

        public int getSlotLimit(int slot) {
            return this.inventory.getSlotLimit(slot);
        }
    }
}

