/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import hellfirepvp.modularmachinery.common.block.BlockStatedMachineComponent;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Rotation;
import net.minecraftforge.fluids.BlockFluidBase;

public class IBlockStateDescriptor {
    private static final ObjectOpenHashSet<IBlockStateDescriptor> POOL = new ObjectOpenHashSet();
    private final List<IBlockState> applicable;

    public IBlockStateDescriptor(IBlockState state) {
        this.applicable = Collections.singletonList(state);
    }

    public IBlockStateDescriptor(Block block) {
        if (block instanceof BlockLiquid || block instanceof BlockFluidBase) {
            this.applicable = Collections.singletonList(block.func_176223_P());
            return;
        }
        ReferenceArrayList applicable = new ReferenceArrayList();
        IntOpenHashSet usedMetas = new IntOpenHashSet();
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            int meta = block.func_176201_c(state);
            if (usedMetas.contains(meta)) continue;
            usedMetas.add(meta);
            applicable.add(state);
        }
        this.applicable = applicable.isEmpty() ? Collections.singletonList(block.func_176223_P()) : applicable;
    }

    protected IBlockStateDescriptor(List<IBlockState> applicable) {
        this.applicable = applicable;
    }

    public static IBlockStateDescriptor of(IBlockState state) {
        return new IBlockStateDescriptor(state).canonicalize();
    }

    public static IBlockStateDescriptor of(Block block) {
        return new IBlockStateDescriptor(block).canonicalize();
    }

    public static void clearPool() {
        POOL.clear();
    }

    public IBlockStateDescriptor copy() {
        return this.applicable.size() == 1 ? new IBlockStateDescriptor(this.applicable.get(0)) : new IBlockStateDescriptor((List<IBlockState>)new ReferenceArrayList(this.applicable));
    }

    public IBlockStateDescriptor copyRotateYCCW(AtomicBoolean rotated) {
        ReferenceArrayList applicable = new ReferenceArrayList();
        for (IBlockState state : this.applicable) {
            IBlockState rotatedState;
            if (state != (rotatedState = state.func_185907_a(Rotation.COUNTERCLOCKWISE_90))) {
                rotated.set(true);
            }
            applicable.add(rotatedState);
        }
        return applicable.size() == 1 ? new IBlockStateDescriptor((IBlockState)applicable.get(0)).canonicalize() : new IBlockStateDescriptor((List<IBlockState>)applicable).canonicalize();
    }

    public boolean hasTileEntity() {
        for (IBlockState state : this.applicable) {
            if (!state.func_177230_c().hasTileEntity(state)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStatedMachineComponent() {
        for (IBlockState state : this.applicable) {
            if (!(state.func_177230_c() instanceof BlockStatedMachineComponent)) continue;
            return true;
        }
        return false;
    }

    public List<IBlockState> getApplicable() {
        return this.applicable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBlockStateDescriptor canonicalize() {
        ObjectOpenHashSet<IBlockStateDescriptor> objectOpenHashSet = POOL;
        synchronized (objectOpenHashSet) {
            return (IBlockStateDescriptor)POOL.addOrGet((Object)this);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof IBlockStateDescriptor && this.applicable.equals(((IBlockStateDescriptor)obj).applicable);
    }

    public int hashCode() {
        return this.applicable.hashCode();
    }
}

