/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import github.kasuminova.mmce.common.util.concurrent.ReadWriteLockProvider;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="mekanism.api.gas.IGasHandler", modid="mekanism")
public class HybridTank
extends FluidTank
implements ReadWriteLockProvider {
    protected final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    public HybridTank(int capacity) {
        super(capacity);
    }

    @Nullable
    public FluidStack getFluid() {
        try {
            this.rwLock.readLock().lock();
            FluidStack fluidStack = super.getFluid();
            return fluidStack;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void setFluid(@Nullable FluidStack fluid) {
        try {
            this.rwLock.writeLock().lock();
            super.setFluid(fluid);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public int getFluidAmount() {
        try {
            this.rwLock.readLock().lock();
            int n = super.getFluidAmount();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fill(FluidStack resource, boolean doFill) {
        try {
            (doFill ? this.rwLock.writeLock() : this.rwLock.readLock()).lock();
            int n = super.fill(resource, doFill);
            (doFill ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            return n;
        }
        catch (Throwable throwable) {
            (doFill ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fillInternal(FluidStack resource, boolean doFill) {
        try {
            (doFill ? this.rwLock.writeLock() : this.rwLock.readLock()).lock();
            int n = super.fillInternal(resource, doFill);
            (doFill ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            return n;
        }
        catch (Throwable throwable) {
            (doFill ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        try {
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).lock();
            FluidStack fluidStack = super.drain(resource, doDrain);
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            return fluidStack;
        }
        catch (Throwable throwable) {
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FluidStack drain(int maxDrain, boolean doDrain) {
        try {
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).lock();
            FluidStack fluidStack = super.drain(maxDrain, doDrain);
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            return fluidStack;
        }
        catch (Throwable throwable) {
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FluidStack drainInternal(FluidStack resource, boolean doDrain) {
        try {
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).lock();
            FluidStack fluidStack = super.drainInternal(resource, doDrain);
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            return fluidStack;
        }
        catch (Throwable throwable) {
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FluidStack drainInternal(int maxDrain, boolean doDrain) {
        try {
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).lock();
            FluidStack fluidStack = super.drainInternal(maxDrain, doDrain);
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            return fluidStack;
        }
        catch (Throwable throwable) {
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            throw throwable;
        }
    }

    @Override
    @Nonnull
    public ReadWriteLock getRWLock() {
        return this.rwLock;
    }
}

