/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import github.kasuminova.mmce.common.util.IExtendedGasHandler;
import hellfirepvp.modularmachinery.common.util.HybridTank;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;

public class HybridGasTank
extends HybridTank
implements IExtendedGasHandler {
    protected final GasTank gasTank;

    public HybridGasTank(int capacity) {
        super(capacity);
        this.gasTank = new GasTank(capacity);
    }

    @Override
    public void setFluid(@Nullable FluidStack fluid) {
        try {
            this.rwLock.writeLock().lock();
            super.setFluid(fluid);
            if (this.getFluid() != null) {
                this.setGas(null);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public int fillInternal(FluidStack resource, boolean doFill) {
        if (this.getGas() != null && this.getGas().amount > 0) {
            return 0;
        }
        return super.fillInternal(resource, doFill);
    }

    @Override
    @Nullable
    public FluidStack drainInternal(int maxDrain, boolean doDrain) {
        if (this.getGas() != null && this.getGas().amount > 0) {
            return null;
        }
        return super.drainInternal(maxDrain, doDrain);
    }

    @Override
    @Nullable
    public FluidStack drainInternal(FluidStack resource, boolean doDrain) {
        if (this.getGas() != null && this.getGas().amount > 0) {
            return null;
        }
        return super.drainInternal(resource, doDrain);
    }

    @Nullable
    public GasStack getGas() {
        try {
            this.rwLock.readLock().lock();
            GasStack gasStack = this.gasTank.getGas();
            return gasStack;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void setGas(@Nullable GasStack stack) {
        try {
            this.rwLock.writeLock().lock();
            if (stack != null) {
                this.gasTank.setGas(stack.copy());
                this.setFluid(null);
            } else {
                this.gasTank.setGas(null);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        block5: {
            if (stack == null || stack.amount <= 0) {
                return 0;
            }
            try {
                (doTransfer ? this.rwLock.writeLock() : this.rwLock.readLock()).lock();
                if (this.fluid == null || this.fluid.amount <= 0) break block5;
                int n = 0;
                (doTransfer ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
                return n;
            }
            catch (Throwable throwable) {
                (doTransfer ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
                throw throwable;
            }
        }
        int receive = this.gasTank.receive(stack, doTransfer);
        if (receive != 0 && doTransfer) {
            this.onContentsChanged();
        }
        int n = receive;
        (doTransfer ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        block8: {
            block7: {
                block6: {
                    try {
                        (doTransfer ? this.rwLock.writeLock() : this.rwLock.readLock()).lock();
                        if (this.getGas() != null && amount > 0) break block6;
                        GasStack gasStack = null;
                        (doTransfer ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
                        return gasStack;
                    }
                    catch (Throwable throwable) {
                        (doTransfer ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
                        throw throwable;
                    }
                }
                if (this.getFluid() == null || this.getFluid().amount <= 0) break block7;
                GasStack gasStack = null;
                (doTransfer ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
                return gasStack;
            }
            if (this.canDrawGas(side, null)) break block8;
            GasStack gasStack = null;
            (doTransfer ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            return gasStack;
        }
        GasStack drawn = this.gasTank.draw(amount, doTransfer);
        if (drawn != null && !doTransfer) {
            this.onContentsChanged();
        }
        GasStack gasStack = drawn;
        (doTransfer ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
        return gasStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GasStack drawGas(GasStack toDraw, boolean doTransfer) {
        try {
            (doTransfer ? this.rwLock.writeLock() : this.rwLock.readLock()).lock();
            GasStack gasStack = this.canDrawGas(null, toDraw.getGas()) ? this.drawGas(null, toDraw.amount, doTransfer) : null;
            (doTransfer ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            return gasStack;
        }
        catch (Throwable throwable) {
            (doTransfer ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            throw throwable;
        }
    }

    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.canFill() && this.gasTank.canReceive(type);
    }

    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.canDrain() && this.gasTank.canDraw(type);
    }

    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTank[]{this.gasTank};
    }

    public void readGasFromNBT(NBTTagCompound nbt) {
        NBTTagCompound subGas = nbt.func_74775_l("gasTag");
        if (subGas.func_82582_d()) {
            this.setGas(null);
            return;
        }
        if (!subGas.func_74764_b("Empty")) {
            this.setGas(GasStack.readFromNBT((NBTTagCompound)subGas));
        } else {
            this.setGas(null);
        }
    }

    public void writeGasToNBT(NBTTagCompound nbt) {
        NBTTagCompound subGas = new NBTTagCompound();
        if (this.getGas() != null) {
            this.getGas().write(subGas);
        }
        nbt.func_74782_a("gasTag", (NBTBase)subGas);
    }
}

