/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import com.google.common.collect.ImmutableList;
import hellfirepvp.modularmachinery.ModularMachinery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class FuelItemHelper {
    private static List<ItemStack> knownFuelStacks = null;
    private static Future<Void> future = null;

    public static void initialize() {
        future = CompletableFuture.runAsync(() -> {
            NonNullList stacks = NonNullList.func_191196_a();
            for (Item item : ForgeRegistries.ITEMS) {
                CreativeTabs tab = item.func_77640_w();
                if (tab == null) continue;
                try {
                    item.func_150895_a(tab, stacks);
                }
                catch (Throwable e) {
                    ModularMachinery.log.warn("[ModularMachinery] Exception when loading FuelItems!", e);
                }
            }
            LinkedList<ItemStack> out = new LinkedList<ItemStack>();
            for (ItemStack stack : stacks) {
                try {
                    int burn = TileEntityFurnace.func_145952_a((ItemStack)stack);
                    if (burn <= 0) continue;
                    out.add(stack);
                }
                catch (Throwable throwable) {}
            }
            knownFuelStacks = ImmutableList.copyOf(out);
            future = null;
        });
    }

    public static List<ItemStack> getFuelItems() {
        if (future == null && knownFuelStacks == null) {
            return Collections.emptyList();
        }
        if (future != null && !future.isDone()) {
            try {
                future.get();
            }
            catch (Throwable e) {
                return new ArrayList<ItemStack>(0);
            }
        }
        return knownFuelStacks == null ? Collections.emptyList() : knownFuelStacks;
    }
}

