/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import com.google.gson.JsonParseException;
import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.helper.AdvancedBlockChecker;
import github.kasuminova.mmce.common.machine.pattern.SpecialItemBlockProxy;
import github.kasuminova.mmce.common.machine.pattern.SpecialItemBlockProxyRegistry;
import github.kasuminova.mmce.common.util.BlockPos2ValueMap;
import hellfirepvp.modularmachinery.client.ClientScheduler;
import hellfirepvp.modularmachinery.common.util.BlockArrayCache;
import hellfirepvp.modularmachinery.common.util.IBlockStateDescriptor;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import hellfirepvp.modularmachinery.common.util.nbt.NBTJsonSerializer;
import hellfirepvp.modularmachinery.common.util.nbt.NBTMatchingHelper;
import ink.ikx.mmce.common.utils.StackUtils;
import ink.ikx.mmce.common.utils.StructureIngredient;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stanhebben.zenscript.annotations.ZenClass;

@ZenRegister
@ZenClass(value="mods.modularmachinery.BlockArray")
public class BlockArray {
    private static final ResourceLocation IC_2_TILE_BLOCK = new ResourceLocation("ic2", "te");
    public final long uid;
    protected Map<BlockPos, BlockInformation> pattern = new BlockPos2ValueMap<BlockInformation>();
    protected Map<BlockPos, BlockInformation> tileBlocksArray = new BlockPos2ValueMap<BlockInformation>();
    private BlockPos min = new BlockPos(0, 0, 0);
    private BlockPos max = new BlockPos(0, 0, 0);
    private BlockPos size = new BlockPos(0, 0, 0);

    public BlockArray() {
        this.uid = BlockArrayCache.nextUID();
    }

    public BlockArray(long uid) {
        this.uid = uid;
    }

    public BlockArray(BlockArray other) {
        this.pattern = new BlockPos2ValueMap<BlockInformation>(other.pattern);
        this.min = new BlockPos(other.min.func_177958_n(), other.min.func_177956_o(), other.min.func_177952_p());
        this.max = new BlockPos(other.max.func_177958_n(), other.max.func_177956_o(), other.max.func_177952_p());
        this.size = new BlockPos(other.size.func_177958_n(), other.size.func_177956_o(), other.size.func_177952_p());
        this.uid = other.uid;
    }

    public BlockArray(BlockArray other, BlockPos offset) {
        for (Map.Entry<BlockPos, BlockInformation> otherEntry : other.pattern.entrySet()) {
            this.pattern.put(otherEntry.getKey().func_177971_a((Vec3i)offset), otherEntry.getValue());
        }
        this.min = new BlockPos(offset.func_177958_n() + other.min.func_177958_n(), offset.func_177956_o() + other.min.func_177956_o(), offset.func_177952_p() + other.min.func_177952_p());
        this.max = new BlockPos(offset.func_177958_n() + other.max.func_177958_n(), offset.func_177956_o() + other.max.func_177956_o(), offset.func_177952_p() + other.max.func_177952_p());
        this.size = new BlockPos(other.size.func_177958_n(), other.size.func_177956_o(), other.size.func_177952_p());
        this.uid = other.uid;
    }

    public StructureBoundingBox getPatternBoundingBox(BlockPos ctrlPos) {
        BlockPos min = ctrlPos.func_177971_a((Vec3i)this.min);
        BlockPos max = ctrlPos.func_177971_a((Vec3i)this.max);
        return new StructureBoundingBox((Vec3i)min, (Vec3i)max);
    }

    public void flushTileBlocksCache() {
        this.tileBlocksArray.clear();
        this.pattern.forEach((pos, info) -> {
            if (info.hasTileEntity()) {
                this.tileBlocksArray.put((BlockPos)pos, (BlockInformation)info);
            }
        });
    }

    public void overwrite(BlockArray other) {
        this.pattern = new BlockPos2ValueMap<BlockInformation>(other.pattern);
        this.min = new BlockPos(other.min.func_177958_n(), other.min.func_177956_o(), other.min.func_177952_p());
        this.max = new BlockPos(other.max.func_177958_n(), other.max.func_177956_o(), other.max.func_177952_p());
        this.size = new BlockPos(other.size.func_177958_n(), other.size.func_177956_o(), other.size.func_177952_p());
    }

    public void addBlock(int x, int y, int z, @Nonnull BlockInformation info) {
        this.addBlock(new BlockPos(x, y, z), info);
    }

    public void addBlock(BlockPos offset, @Nonnull BlockInformation info) {
        this.pattern.put(offset, info.canonicalize());
        this.updateSize(offset);
    }

    public boolean hasBlockAt(BlockPos pos) {
        return this.pattern.containsKey(pos);
    }

    public boolean isEmpty() {
        return this.pattern.isEmpty();
    }

    public BlockPos getMax() {
        return this.max;
    }

    public BlockPos getMin() {
        return this.min;
    }

    public BlockPos getSize() {
        return this.size;
    }

    private void updateSize(BlockPos addedPos) {
        if (addedPos.func_177958_n() < this.min.func_177958_n()) {
            this.min = new BlockPos(addedPos.func_177958_n(), this.min.func_177956_o(), this.min.func_177952_p());
        }
        if (addedPos.func_177958_n() > this.max.func_177958_n()) {
            this.max = new BlockPos(addedPos.func_177958_n(), this.max.func_177956_o(), this.max.func_177952_p());
        }
        if (addedPos.func_177956_o() < this.min.func_177956_o()) {
            this.min = new BlockPos(this.min.func_177958_n(), addedPos.func_177956_o(), this.min.func_177952_p());
        }
        if (addedPos.func_177956_o() > this.max.func_177956_o()) {
            this.max = new BlockPos(this.max.func_177958_n(), addedPos.func_177956_o(), this.max.func_177952_p());
        }
        if (addedPos.func_177952_p() < this.min.func_177952_p()) {
            this.min = new BlockPos(this.min.func_177958_n(), this.min.func_177956_o(), addedPos.func_177952_p());
        }
        if (addedPos.func_177952_p() > this.max.func_177952_p()) {
            this.max = new BlockPos(this.max.func_177958_n(), this.max.func_177956_o(), addedPos.func_177952_p());
        }
        this.size = new BlockPos(this.max.func_177958_n() - this.min.func_177958_n() + 1, this.max.func_177956_o() - this.min.func_177956_o() + 1, this.max.func_177952_p() - this.min.func_177952_p() + 1);
    }

    public Map<BlockPos, BlockInformation> getPattern() {
        return this.pattern;
    }

    public Map<BlockPos, BlockInformation> getTileBlocksArray() {
        return this.tileBlocksArray;
    }

    public Map<BlockPos, BlockInformation> getPatternSlice(int slice) {
        BlockPos2ValueMap<BlockInformation> copy = new BlockPos2ValueMap<BlockInformation>();
        for (BlockPos pos : this.pattern.keySet()) {
            if (pos.func_177956_o() != slice) continue;
            copy.put(pos, this.pattern.get(pos));
        }
        return copy;
    }

    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getAsDescriptiveStacks() {
        return this.getAsDescriptiveStacks(-1L);
    }

    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getAsDescriptiveStacks(long snapSample) {
        LinkedList<ItemStack> out = new LinkedList<ItemStack>();
        this.pattern.forEach((key, bi) -> {
            ItemStack s = bi.getDescriptiveStack(snapSample);
            if (s.func_190926_b()) {
                return;
            }
            boolean found = false;
            for (ItemStack stack : out) {
                if (!stack.func_77973_b().getRegistryName().equals((Object)s.func_77973_b().getRegistryName()) || stack.func_77952_i() != s.func_77952_i()) continue;
                stack.func_190920_e(stack.func_190916_E() + 1);
                found = true;
                break;
            }
            if (!found) {
                out.add(s);
            }
        });
        return out;
    }

    public List<List<ItemStack>> getIngredientList() {
        LinkedList<List<ItemStack>> ingredient = new LinkedList<List<ItemStack>>();
        this.pattern.forEach((pos, info) -> {
            List<ItemStack> infoIngList = info.getIngredientList();
            if (infoIngList.isEmpty()) {
                return;
            }
            if (infoIngList.size() == 1) {
                ItemStack input = infoIngList.get(0);
                for (List itemStackList : ingredient) {
                    ItemStack anotherInput = (ItemStack)itemStackList.get(0);
                    if (!ItemUtils.matchStacks(input, anotherInput)) continue;
                    anotherInput.func_190917_f(1);
                    return;
                }
            }
            ingredient.add(infoIngList);
        });
        return ingredient;
    }

    public List<StructureIngredient.ItemIngredient> getBlockStateIngredientList(World world, BlockPos ctrlPos) {
        ArrayList<StructureIngredient.ItemIngredient> ingredientList = new ArrayList<StructureIngredient.ItemIngredient>();
        this.pattern.forEach((pos, info) -> {
            BlockPos realPos = ctrlPos.func_177971_a((Vec3i)pos);
            if (!info.matches(world, realPos, false)) {
                ingredientList.add(new StructureIngredient.ItemIngredient((BlockPos)pos, info.getBlockStateIngredientList(), info.getMatchingTag()));
            }
        });
        return ingredientList;
    }

    public List<ItemStack> getDescriptiveStackList(long snapTick) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.pattern.values().forEach(info -> {
            ItemStack descriptiveStack = info.getDescriptiveStack(snapTick);
            if (descriptiveStack.func_190926_b()) {
                return;
            }
            for (ItemStack stack : stackList) {
                if (!ItemUtils.matchStacks(descriptiveStack, stack)) continue;
                stack.func_190917_f(1);
                return;
            }
            stackList.add(descriptiveStack);
        });
        return stackList;
    }

    public List<ItemStack> getDescriptiveStackList(long snapTick, World world, BlockPos offset) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.pattern.forEach((pos, info) -> {
            BlockPos realPos = pos.func_177971_a((Vec3i)offset);
            ItemStack descriptiveStack = info.getDescriptiveStack(snapTick, realPos, world);
            SpecialItemBlockProxy specialItemBlockProxy = SpecialItemBlockProxyRegistry.INSTANCE.getValidProxy(descriptiveStack);
            if (specialItemBlockProxy != null) {
                descriptiveStack = specialItemBlockProxy.getTrueStack(world.func_180495_p(realPos), world.func_175625_s(realPos));
            }
            if (descriptiveStack.func_190926_b()) {
                return;
            }
            for (ItemStack stack : stackList) {
                if (!ItemUtils.matchStacks(descriptiveStack, stack)) continue;
                stack.func_190917_f(1);
                return;
            }
            stackList.add(descriptiveStack);
        });
        return stackList;
    }

    public boolean matches(World world, BlockPos center, boolean oldState, @Nullable Map<BlockPos, List<BlockInformation>> modifierReplacementPattern) {
        block0: for (Map.Entry<BlockPos, BlockInformation> entry : this.pattern.entrySet()) {
            BlockPos at = center.func_177971_a((Vec3i)entry.getKey());
            if (entry.getValue().matches(world, at, oldState)) continue;
            if (modifierReplacementPattern == null || !modifierReplacementPattern.containsKey(entry.getKey())) {
                return false;
            }
            for (BlockInformation info : modifierReplacementPattern.get(entry.getKey())) {
                if (!info.matches(world, at, oldState)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public boolean matchesParallel(World world, BlockPos center, boolean oldState, @Nullable Map<BlockPos, List<BlockInformation>> modifierReplacementPattern) {
        return this.pattern.entrySet().parallelStream().allMatch(entry -> {
            BlockPos at = center.func_177971_a((Vec3i)entry.getKey());
            if (((BlockInformation)entry.getValue()).matches(world, at, oldState)) {
                return true;
            }
            if (modifierReplacementPattern == null || !modifierReplacementPattern.containsKey(entry.getKey())) {
                return false;
            }
            for (BlockInformation info : (List)modifierReplacementPattern.get(entry.getKey())) {
                if (!info.matches(world, at, oldState)) continue;
                return true;
            }
            return false;
        });
    }

    public BlockPos getRelativeMismatchPosition(World world, BlockPos center, @Nullable Map<BlockPos, List<BlockInformation>> modifierReplacementPattern) {
        block0: for (Map.Entry<BlockPos, BlockInformation> entry : this.pattern.entrySet()) {
            BlockPos at = center.func_177971_a((Vec3i)entry.getKey());
            if (entry.getValue().matches(world, at, false)) continue;
            if (modifierReplacementPattern == null || !modifierReplacementPattern.containsKey(entry.getKey())) {
                return entry.getKey();
            }
            for (BlockInformation info : modifierReplacementPattern.get(entry.getKey())) {
                if (!info.matches(world, at, false)) continue;
                continue block0;
            }
            return entry.getKey();
        }
        return null;
    }

    public BlockArray rotateYCCW() {
        BlockArray out = new BlockArray(this.uid);
        for (BlockPos pos : this.pattern.keySet()) {
            BlockInformation info = this.pattern.get(pos);
            out.addBlock(MiscUtils.rotateYCCW(pos), info.copyRotateYCCW());
        }
        return out;
    }

    public String serializeAsMachineJson() {
        String newline = System.getProperty("line.separator");
        String move = "    ";
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(newline);
        sb.append(move).append("\"parts\": [").append(newline);
        Iterator<BlockPos> iterator = this.pattern.keySet().iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            sb.append(move).append(move).append("{").append(newline);
            sb.append(move).append(move).append(move).append("\"x\": ").append(pos.func_177958_n()).append(",").append(newline);
            sb.append(move).append(move).append(move).append("\"y\": ").append(pos.func_177956_o()).append(",").append(newline);
            sb.append(move).append(move).append(move).append("\"z\": ").append(pos.func_177952_p()).append(",").append(newline);
            BlockInformation bi = this.pattern.get(pos);
            if (bi.getMatchingTag() != null) {
                String strTag = NBTJsonSerializer.serializeNBT((NBTBase)bi.getMatchingTag());
                sb.append(move).append(move).append(move).append("\"nbt\": ").append(strTag).append(",").append(newline);
            }
            sb.append(move).append(move).append(move).append("\"elements\": [").append(newline);
            Iterator iterator1 = bi.samples.iterator();
            while (iterator1.hasNext()) {
                IBlockState descriptor = (IBlockState)iterator1.next();
                int meta = descriptor.func_177230_c().func_176201_c(descriptor);
                String str = descriptor.func_177230_c().getRegistryName().toString() + "@" + meta;
                sb.append(move).append(move).append(move).append(move).append("\"").append(str).append("\"");
                if (iterator1.hasNext()) {
                    sb.append(",");
                }
                sb.append(newline);
            }
            sb.append(move).append(move).append(move).append("]").append(newline);
            sb.append(move).append(move).append("}");
            if (iterator.hasNext()) {
                sb.append(",");
            }
            sb.append(newline);
        }
        sb.append(move).append("]");
        sb.append("}");
        return sb.toString();
    }

    public static class BlockInformation {
        public static final int CYCLE_TICK_SPEED = 30;
        private static final ObjectOpenHashSet<BlockInformation> POOL = new ObjectOpenHashSet();
        private List<IBlockStateDescriptor> matchingStates = new ObjectArrayList();
        private List<IBlockState> samples = new ObjectArrayList();
        private boolean hasTileEntity;
        private boolean hasStateMachineComponent;
        private NBTTagCompound matchingTag = null;
        private NBTTagCompound previewTag = null;
        private AdvancedBlockChecker nbtChecker = null;

        public BlockInformation(List<IBlockStateDescriptor> matching) {
            this.matchingStates.addAll(matching);
            for (IBlockStateDescriptor desc : this.matchingStates) {
                this.samples.addAll(desc.getApplicable());
                if (!this.hasTileEntity) {
                    this.hasTileEntity = desc.hasTileEntity();
                }
                if (this.hasStateMachineComponent) continue;
                this.hasStateMachineComponent = desc.hasStatedMachineComponent();
            }
        }

        public static void clearPool() {
            POOL.clear();
        }

        public static IBlockStateDescriptor getDescriptor(String strElement) throws JsonParseException {
            ResourceLocation res;
            Block block;
            int meta = -1;
            int indexMeta = strElement.indexOf(64);
            if (indexMeta != -1 && indexMeta != strElement.length() - 1) {
                try {
                    meta = Integer.parseInt(strElement.substring(indexMeta + 1));
                }
                catch (NumberFormatException exc) {
                    throw new JsonParseException("Expected a metadata number, got " + strElement.substring(indexMeta + 1), (Throwable)exc);
                }
                strElement = strElement.substring(0, indexMeta);
            }
            if ((block = (Block)ForgeRegistries.BLOCKS.getValue(res = new ResourceLocation(strElement))) == null) {
                throw new JsonParseException("Couldn't find block with registryName '" + res + "' !");
            }
            if (meta == -1) {
                return IBlockStateDescriptor.of(block);
            }
            return IBlockStateDescriptor.of(block.func_176203_a(meta));
        }

        public static Tuple<ItemStack, IBlockState> getTupleIngredientFromBlockState(IBlockState state) {
            return new Tuple((Object)StackUtils.getStackFromBlockState(state), (Object)state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BlockInformation canonicalize() {
            ObjectOpenHashSet<BlockInformation> objectOpenHashSet = POOL;
            synchronized (objectOpenHashSet) {
                return (BlockInformation)POOL.addOrGet((Object)this);
            }
        }

        public void addMatchingStates(List<IBlockStateDescriptor> matching) {
            for (IBlockStateDescriptor desc : matching) {
                if (!this.matchingStates.contains(desc)) {
                    this.matchingStates.add(desc);
                }
                for (IBlockState state : desc.getApplicable()) {
                    if (this.samples.contains(state)) continue;
                    this.samples.add(state);
                }
                if (!this.hasTileEntity) {
                    this.hasTileEntity = desc.hasTileEntity();
                }
                if (this.hasStateMachineComponent) continue;
                this.hasStateMachineComponent = desc.hasStatedMachineComponent();
            }
        }

        public boolean hasTileEntity() {
            return this.hasTileEntity;
        }

        public boolean hasStatedMachineComponent() {
            return this.hasStateMachineComponent;
        }

        public NBTTagCompound getMatchingTag() {
            return this.matchingTag;
        }

        public void setMatchingTag(@Nullable NBTTagCompound matchingTag) {
            this.matchingTag = matchingTag;
        }

        public NBTTagCompound getPreviewTag() {
            return this.previewTag;
        }

        public void setPreviewTag(NBTTagCompound previewTag) {
            this.previewTag = previewTag;
        }

        public IBlockState getSampleState() {
            return this.getSampleState(-1L);
        }

        public IBlockState getSampleState(long snapTick) {
            int p = (int)((snapTick == -1L ? ClientScheduler.getClientTick() : snapTick) / 30L);
            int part = p % this.samples.size();
            return this.samples.get(part);
        }

        public ItemStack getDescriptiveStack(long snapTick) {
            return StackUtils.getStackFromBlockState(this.getSampleState(snapTick));
        }

        public ItemStack getDescriptiveStack(long snapTick, BlockPos pos, World world) {
            return StackUtils.getStackFromBlockState(this.getSampleState(snapTick), pos, world);
        }

        public List<ItemStack> getIngredientList() {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            this.samples.stream().map(StackUtils::getStackFromBlockState).filter(stackFromBlockState -> ItemUtils.stackNotInList(list, stackFromBlockState)).forEach(list::add);
            return list;
        }

        public List<ItemStack> getIngredientList(BlockPos pos, World world) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            this.samples.stream().map(state -> StackUtils.getStackFromBlockState(state, pos, world)).filter(stackFromBlockState -> ItemUtils.stackNotInList(list, stackFromBlockState)).forEach(list::add);
            return list;
        }

        public List<Tuple<ItemStack, IBlockState>> getBlockStateIngredientList() {
            return this.samples.stream().map(BlockInformation::getTupleIngredientFromBlockState).collect(Collectors.toList());
        }

        public BlockInformation copyRotateYCCW() {
            BlockInformation bi;
            ObjectArrayList newDescList = new ObjectArrayList();
            AtomicBoolean hasBlockRotated = new AtomicBoolean(false);
            for (IBlockStateDescriptor desc : this.matchingStates) {
                newDescList.add(desc.copyRotateYCCW(hasBlockRotated));
            }
            if (!hasBlockRotated.get()) {
                bi = new BlockInformation(Collections.emptyList());
                bi.matchingStates = this.matchingStates;
                bi.samples = this.samples;
                bi.hasTileEntity = this.hasTileEntity;
                bi.hasStateMachineComponent = this.hasStateMachineComponent;
            } else {
                bi = new BlockInformation((List<IBlockStateDescriptor>)newDescList);
            }
            bi.matchingTag = this.matchingTag;
            bi.previewTag = this.previewTag;
            bi.nbtChecker = this.nbtChecker;
            return bi;
        }

        public BlockInformation copy() {
            ObjectArrayList newDescList = new ObjectArrayList(this.matchingStates.size());
            for (IBlockStateDescriptor desc : this.matchingStates) {
                newDescList.add(desc.copy());
            }
            BlockInformation bi = new BlockInformation((List<IBlockStateDescriptor>)newDescList);
            bi.matchingTag = this.matchingTag;
            bi.previewTag = this.previewTag;
            bi.nbtChecker = this.nbtChecker;
            return bi;
        }

        public boolean matchesState(World world, BlockPos at, IBlockState state) {
            Block atBlock = state.func_177230_c();
            int atMeta = atBlock.func_176201_c(state);
            for (IBlockStateDescriptor descriptor : this.matchingStates) {
                for (IBlockState applicable : descriptor.getApplicable()) {
                    TileEntity te;
                    Block type = applicable.func_177230_c();
                    int meta = type.func_176201_c(applicable);
                    if (!type.equals(atBlock) || meta != atMeta) continue;
                    if (!this.isNBTCheckerMatch(world, at, applicable)) {
                        return false;
                    }
                    if (this.matchingTag != null && (te = world.func_175625_s(at)) != null && this.matchingTag.func_186856_d() > 0) {
                        NBTTagCompound cmp = new NBTTagCompound();
                        te.func_189515_b(cmp);
                        return NBTMatchingHelper.matchNBTCompound(this.matchingTag, cmp);
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean matches(World world, BlockPos at, boolean default_) {
            if (!world.func_175667_e(at)) {
                return default_;
            }
            IBlockState state = world.func_180495_p(at);
            return this.matchesState(world, at, state);
        }

        private boolean isNBTCheckerMatch(World world, BlockPos at, IBlockState applicable) {
            if (this.nbtChecker == null) {
                return true;
            }
            TileEntity te = world.func_175625_s(at);
            if (te == null) {
                return false;
            }
            NBTTagCompound cmp = new NBTTagCompound();
            te.func_189515_b(cmp);
            return this.nbtChecker.isMatch(world, at, applicable, cmp);
        }

        public int hashCode() {
            return Objects.hash(this.matchingStates, this.matchingTag, this.previewTag, this.nbtChecker);
        }

        public boolean equals(Object o) {
            if (o instanceof BlockInformation) {
                BlockInformation another = (BlockInformation)o;
                return this.matchingStates.equals(another.matchingStates) && Objects.equals(this.matchingTag, another.matchingTag) && Objects.equals(this.previewTag, another.previewTag) && Objects.equals(this.nbtChecker, another.nbtChecker);
            }
            return false;
        }

        public AdvancedBlockChecker getNBTChecker() {
            return this.nbtChecker;
        }

        public void setNBTChecker(AdvancedBlockChecker nbtChecker) {
            this.nbtChecker = nbtChecker;
        }

        public List<IBlockStateDescriptor> getMatchingStates() {
            return this.matchingStates;
        }
    }

    public static final class TileInstantiateContext {
        private final World world;
        private final BlockPos pos;

        public TileInstantiateContext(World world, BlockPos pos) {
            this.world = world;
            this.pos = pos;
        }

        public void apply(TileEntity te) {
            if (te != null) {
                te.func_145834_a(this.world);
                te.func_174878_a(this.pos);
            }
        }

        public String toString() {
            return "TileInstantiateContext[" + "world=" + this.world + "," + "pos=" + this.pos + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.world != null ? this.world.hashCode() : 0);
            result = 31 * result + (this.pos != null ? this.pos.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((TileInstantiateContext)arg0).world, this.world)) {
                return false;
            }
            return Objects.equals(((TileInstantiateContext)arg0).pos, this.pos);
            {
            }
        }

        public World world() {
            return this.world;
        }

        public BlockPos pos() {
            return this.pos;
        }
    }
}

