/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles.base;

import com.mojang.authlib.GameProfile;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.block.IBlockStateMatcher;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IFacing;
import crafttweaker.api.world.IWorld;
import github.kasuminova.mmce.client.model.DynamicMachineModelRegistry;
import github.kasuminova.mmce.client.model.MachineControllerModel;
import github.kasuminova.mmce.client.world.BlockModelHider;
import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.mmce.common.event.client.ControllerModelAnimationEvent;
import github.kasuminova.mmce.common.event.client.ControllerModelGetEvent;
import github.kasuminova.mmce.common.event.machine.MachineStructureFormedEvent;
import github.kasuminova.mmce.common.event.machine.MachineStructureUpdateEvent;
import github.kasuminova.mmce.common.event.machine.MachineTickEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.mmce.common.helper.IBlockStatePredicate;
import github.kasuminova.mmce.common.helper.IDynamicPatternInfo;
import github.kasuminova.mmce.common.helper.IMachineController;
import github.kasuminova.mmce.common.machine.component.MachineComponentProxyRegistry;
import github.kasuminova.mmce.common.tile.MEPatternProvider;
import github.kasuminova.mmce.common.upgrade.MachineUpgrade;
import github.kasuminova.mmce.common.upgrade.UpgradeType;
import github.kasuminova.mmce.common.util.DynamicPattern;
import github.kasuminova.mmce.common.util.InfItemFluidHandler;
import github.kasuminova.mmce.common.util.TimeRecorder;
import github.kasuminova.mmce.common.util.concurrent.ActionExecutor;
import github.kasuminova.mmce.common.world.MMWorldEventListener;
import github.kasuminova.mmce.common.world.MachineComponentManager;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.client.ClientProxy;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.block.BlockStatedMachineComponent;
import hellfirepvp.modularmachinery.common.block.prop.WorkingState;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentSelectorTag;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.item.ItemBlueprint;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.machine.TaggedPositionBlockArray;
import hellfirepvp.modularmachinery.common.modifier.MultiBlockModifierReplacement;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.modifier.SingleBlockModifierReplacement;
import hellfirepvp.modularmachinery.common.tiles.TileParallelController;
import hellfirepvp.modularmachinery.common.tiles.TileSmartInterface;
import hellfirepvp.modularmachinery.common.tiles.TileUpgradeBus;
import hellfirepvp.modularmachinery.common.tiles.base.ColorableMachineTile;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.SelectiveUpdateTileEntity;
import hellfirepvp.modularmachinery.common.tiles.base.TileEntityRestrictedTick;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.BlockArrayCache;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import hellfirepvp.modularmachinery.common.util.SmartInterfaceData;
import hellfirepvp.modularmachinery.common.util.SmartInterfaceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import stanhebben.zenscript.annotations.ZenMethod;

@Optional.Interface(iface="software.bernie.geckolib3.core.IAnimatable", modid="geckolib3")
public abstract class TileMultiblockMachineController
extends TileEntityRestrictedTick
implements SelectiveUpdateTileEntity,
IMachineController,
IAnimatable {
    public static final int BLUEPRINT_SLOT = 0;
    public static final int ACCELERATOR_SLOT = 1;
    public static int structureCheckDelay = 30;
    public static int maxStructureCheckDelay = 200;
    public static boolean delayedStructureCheck = true;
    public static boolean cleanCustomDataOnStructureCheckFailed = false;
    public static boolean enableSecuritySystem = false;
    public static boolean enableFullDataSync = false;
    public static int usedTimeCache = 0;
    public static int searchUsedTimeCache = 0;
    public static WorkMode workModeCache = WorkMode.ASYNC;
    protected final Map<String, List<RecipeModifier>> foundModifiers = new ConcurrentHashMap<String, List<RecipeModifier>>();
    protected final Map<String, RecipeModifier> customModifiers = new ConcurrentHashMap<String, RecipeModifier>();
    protected final Map<TileSmartInterface.SmartInterfaceProvider, String> foundSmartInterfaces = new ConcurrentHashMap<TileSmartInterface.SmartInterfaceProvider, String>();
    protected final Map<String, List<MachineUpgrade>> foundUpgrades = new ConcurrentHashMap<String, List<MachineUpgrade>>();
    protected final List<TileUpgradeBus.UpgradeBusProvider> foundUpgradeBuses = new ArrayList<TileUpgradeBus.UpgradeBusProvider>();
    protected final List<TileParallelController.ParallelControllerProvider> foundParallelControllers = new ArrayList<TileParallelController.ParallelControllerProvider>();
    protected final Map<TileEntity, ProcessingComponent<?>> foundComponents = new ConcurrentHashMap();
    protected final TimeRecorder timeRecorder = new TimeRecorder();
    protected final Set<InfItemFluidHandler> componentSet = new HashSet<InfItemFluidHandler>();
    protected boolean searchRecipeImmediately = false;
    protected EnumFacing controllerRotation = null;
    protected DynamicMachine.ModifierReplacementMap foundReplacements = null;
    protected IOInventory inventory;
    protected NBTTagCompound customData = new NBTTagCompound();
    protected DynamicMachine prevMachine = null;
    protected DynamicMachine foundMachine = null;
    protected DynamicMachine parentMachine = null;
    protected TaggedPositionBlockArray foundPattern = null;
    protected Map<String, DynamicPattern.Status> foundDynamicPatterns = new HashMap<String, DynamicPattern.Status>();
    protected ActionExecutor tickExecutor = null;
    protected WorkMode workMode = WorkMode.ASYNC;
    protected UUID owner = null;
    protected int structureCheckCounter = 0;
    protected int recipeResearchRetryCounter = 0;
    protected int lastStrongPower = -1;
    protected int lastStructureCheckTick = -1;
    protected long executeGroupId = -1L;
    protected Object animationFactory = null;
    protected boolean loaded = false;

    public TileMultiblockMachineController() {
        this.inventory = this.buildInventory();
        this.inventory.setStackLimit(1, 0);
    }

    public static void loadFromConfig(Configuration config) {
        structureCheckDelay = config.getInt("structure-check-delay", "general", 30, 1, 1200, "The multiblock structure checks the structural integrity at how often? (TimeUnit: Tick)");
        delayedStructureCheck = config.getBoolean("delayed-structure-check", "general", true, "When enabled, the structure check interval in the idle state is incrementally increased to ease the performance footprint.");
        maxStructureCheckDelay = config.getInt("max-structure-check-delay", "general", 100, 2, 1200, "When delayed-structure-check is enabled, what is the maximum check interval? (TimeUnit: Tick)");
        if (structureCheckDelay >= maxStructureCheckDelay) {
            ModularMachinery.log.warn("structure-check-delay is bigger than or equal max-structure-check-delay!, use default value...");
            structureCheckDelay = 30;
            maxStructureCheckDelay = 100;
        }
        cleanCustomDataOnStructureCheckFailed = config.getBoolean("clean-custom-data-on-structure-check-failed", "general", false, "When enabled, the customData will be cleared when multiblock structure check failed.");
        enableSecuritySystem = config.getBoolean("enable-security-system", "general", false, "When enabled, players using the controller will have their owner checked and non-owners will be denied access.");
        enableFullDataSync = config.getBoolean("enable-full-data-sync", "general", false, "When enabled, the controller sends the full NBT to the client at the start and completion of the recipe, which can be helpful for machinery where the client needs to perform special operations.");
    }

    public <T> void addComponent(MachineComponent<T> component, @Nullable ComponentSelectorTag tag, TileEntity te, Map<TileEntity, ProcessingComponent<?>> components) {
        T handler = component.getContainerProvider();
        if (handler instanceof InfItemFluidHandler) {
            InfItemFluidHandler ifh = (InfItemFluidHandler)handler;
            if (this.componentSet.contains(ifh)) {
                return;
            }
            this.componentSet.add(ifh);
        }
        MachineComponentManager.INSTANCE.checkComponentShared(te, this);
        components.put(te, new ProcessingComponent<T>(component, handler, tag));
    }

    @Override
    public final void doRestrictedTick() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        this.timeRecorder.updateUsedTime(this.tickExecutor);
        long tickStart = System.nanoTime();
        this.doControllerTick();
        this.timeRecorder.incrementUsedTime((int)TimeUnit.MICROSECONDS.convert(System.nanoTime() - tickStart, TimeUnit.NANOSECONDS));
    }

    public abstract void doControllerTick();

    protected IOInventory buildInventory() {
        return (IOInventory)new IOInventory(this, new int[0], new int[0]).setMiscSlots(0);
    }

    protected int getStrongPower() {
        if (this.lastStrongPower == -1) {
            this.lastStrongPower = this.func_145831_w().func_175676_y(this.func_174877_v());
        }
        return this.lastStrongPower;
    }

    public void onNeighborChange() {
        this.lastStrongPower = this.func_145831_w().func_175676_y(this.func_174877_v());
    }

    public long getExecuteGroupId() {
        return this.executeGroupId;
    }

    public void setExecuteGroupId(long executeGroupId) {
        this.executeGroupId = executeGroupId;
    }

    protected void addRecipeResearchUsedTime(int time) {
        this.timeRecorder.addRecipeResearchUsedTime(time);
    }

    public int usedTimeAvg() {
        return this.timeRecorder.usedTimeAvg();
    }

    public int recipeSearchUsedTimeAvg() {
        return this.timeRecorder.recipeSearchUsedTimeAvg();
    }

    public TimeRecorder getTimeRecorder() {
        return this.timeRecorder;
    }

    public boolean isSearchRecipeImmediately() {
        return this.searchRecipeImmediately;
    }

    public void setSearchRecipeImmediately(boolean searchRecipeImmediately) {
        this.searchRecipeImmediately = searchRecipeImmediately;
    }

    public int getMaxParallelism() {
        int parallelism = this.foundMachine.getInternalParallelism();
        int maxParallelism = this.foundMachine.getMaxParallelism();
        for (TileParallelController.ParallelControllerProvider provider : this.foundParallelControllers) {
            if ((parallelism += provider.getParallelism()) < maxParallelism) continue;
            return maxParallelism;
        }
        return Math.max(1, parallelism);
    }

    @Nullable
    public DynamicMachine getFoundMachine() {
        return this.foundMachine;
    }

    public void setFoundMachine(DynamicMachine foundMachine) {
        this.foundMachine = foundMachine;
    }

    public TaggedPositionBlockArray getFoundPattern() {
        return this.foundPattern;
    }

    public boolean isParallelized() {
        if (this.foundMachine != null) {
            return this.foundMachine.isParallelizable() && this.getMaxParallelism() > 1;
        }
        return false;
    }

    @Nullable
    public DynamicMachine getBlueprintMachine() {
        ItemStack blueprintSlotted = this.inventory.getStackInSlot(0);
        if (!blueprintSlotted.func_190926_b()) {
            return ItemBlueprint.getAssociatedMachine(blueprintSlotted);
        }
        return null;
    }

    public abstract CraftingStatus getControllerStatus();

    public abstract void setControllerStatus(CraftingStatus var1);

    public IOInventory getInventory() {
        return this.inventory;
    }

    public EnumFacing getControllerRotation() {
        return this.controllerRotation;
    }

    protected boolean canCheckStructure() {
        if (this.lastStructureCheckTick == -1 || this.isStructureFormed() && this.foundComponents.isEmpty()) {
            return true;
        }
        if (!delayedStructureCheck) {
            return this.ticksExisted % structureCheckDelay == 0;
        }
        if (this.isStructureFormed()) {
            if (this.ticksExisted % Math.min(structureCheckDelay + this.currentRecipeSearchDelay(), maxStructureCheckDelay) == 0) {
                return true;
            }
            BlockPos pos = this.func_174877_v();
            BlockPos min = this.foundPattern.getMin();
            BlockPos max = this.foundPattern.getMax();
            return MMWorldEventListener.INSTANCE.isAreaChanged(this.func_145831_w(), pos.func_177971_a((Vec3i)min), pos.func_177971_a((Vec3i)max));
        }
        return this.ticksExisted % Math.min(structureCheckDelay + this.structureCheckCounter * 5, maxStructureCheckDelay) == 0;
    }

    public int currentRecipeSearchDelay() {
        return Math.min(20 + this.recipeResearchRetryCounter * 5, 100);
    }

    public boolean isStructureFormed() {
        return this.foundMachine != null && this.foundPattern != null;
    }

    protected void resetMachine(boolean clearData) {
        if (clearData) {
            this.setControllerStatus(CraftingStatus.MISSING_STRUCTURE);
            this.incrementStructureCheckCounter();
            this.resetRecipeSearchRetryCount();
            if (cleanCustomDataOnStructureCheckFailed) {
                this.customData = new NBTTagCompound();
                this.customModifiers.clear();
            }
            if (this.workMode == WorkMode.SYNC) {
                this.notifyStructureFormedState(false);
            } else {
                ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> this.notifyStructureFormedState(false));
            }
        }
        this.updateStatedMachineComponentSync(false);
        this.prevMachine = this.foundMachine;
        this.foundMachine = null;
        this.foundPattern = null;
        this.foundReplacements = null;
        this.foundDynamicPatterns.clear();
    }

    protected void resetRecipe() {
    }

    public void resetRecipeSearchRetryCount() {
        this.recipeResearchRetryCounter = 0;
    }

    public int incrementStructureCheckCounter() {
        ++this.structureCheckCounter;
        return this.structureCheckCounter;
    }

    protected boolean matchesRotation(TaggedPositionBlockArray pattern, DynamicMachine machine, EnumFacing ctrlRotation) {
        if (pattern == null) {
            return false;
        }
        if (!this.func_145831_w().func_175711_a(pattern.getPatternBoundingBox(this.func_174877_v()))) {
            return false;
        }
        DynamicMachine.ModifierReplacementMap replacements = machine.getModifiersAsMatchingReplacements();
        EnumFacing rotation = EnumFacing.NORTH;
        while (rotation != ctrlRotation) {
            rotation = rotation.func_176735_f();
            replacements = replacements.rotateYCCW();
        }
        if (pattern.matches(this.func_145831_w(), this.func_174877_v(), false, replacements) && this.matchesDynamicPatternRotation(machine, rotation)) {
            this.foundPattern = pattern;
            this.foundMachine = machine;
            this.foundReplacements = replacements;
            return true;
        }
        this.resetMachine(false);
        return false;
    }

    protected boolean matchesDynamicPattern(DynamicMachine machine) {
        for (DynamicPattern.Status status : this.foundDynamicPatterns.values()) {
            DynamicPattern pattern = status.pattern();
            DynamicPattern.MatchResult result = pattern.matches(this, true, this.controllerRotation);
            if (result.isMatched()) continue;
            return false;
        }
        return true;
    }

    protected boolean matchesDynamicPatternRotation(DynamicMachine machine, EnumFacing rotation) {
        this.foundDynamicPatterns.clear();
        Map<String, DynamicPattern> dynamicPatterns = machine.getDynamicPatterns();
        if (dynamicPatterns.isEmpty()) {
            return true;
        }
        ArrayList<DynamicPattern.Status> foundDynamicPatterns = new ArrayList<DynamicPattern.Status>();
        for (DynamicPattern dynamicPattern : dynamicPatterns.values()) {
            DynamicPattern.MatchResult matchResult = dynamicPattern.matches(this, false, rotation);
            if (matchResult.isMatched()) {
                foundDynamicPatterns.add(new DynamicPattern.Status(dynamicPattern, matchResult.matchFacing(), matchResult.size()));
                continue;
            }
            return false;
        }
        for (DynamicPattern.Status pattern : foundDynamicPatterns) {
            this.foundDynamicPatterns.put(pattern.pattern().getName(), pattern);
        }
        return true;
    }

    protected void distributeCasingColor() {
        if (this.foundMachine == null || this.foundPattern == null) {
            return;
        }
        int color = this.foundMachine.getMachineColor();
        this.setMachineColor(color);
        this.foundPattern.getTileBlocksArray().keySet().forEach(pos -> this.tryColorize(this.func_174877_v().func_177971_a((Vec3i)pos), color));
    }

    private void tryColorize(BlockPos pos, int color) {
        ColorableMachineTile colorable;
        TileEntity te = this.func_145831_w().func_175625_s(pos);
        if (te instanceof ColorableMachineTile && (colorable = (ColorableMachineTile)te).getMachineColor() != color) {
            colorable.setMachineColor(color);
        }
        if (Mods.AE2.isPresent()) {
            this.writeName(te);
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private void writeName(TileEntity te) {
        if (te instanceof MEPatternProvider) {
            MEPatternProvider mep = (MEPatternProvider)te;
            DynamicMachine machine = this.foundMachine;
            ResourceLocation registry = machine.getRegistryName();
            String localizationKey = registry.func_110624_b() + "." + registry.func_110623_a();
            if (I18n.func_94522_b((String)localizationKey)) {
                mep.setMachineName(localizationKey);
            } else {
                mep.setMachineName(machine.getOriginalLocalizedName().replaceAll("\u00a7.", "").replaceAll("#([A-Fa-f0-9]{3,6}(?:-[A-Fa-f0-9]{3,6})*)", ""));
            }
        }
    }

    public void resetStructureCheckCounter() {
        this.structureCheckCounter = 0;
    }

    protected void checkRotation() {
    }

    protected boolean doStructureCheck() {
        if (!this.canCheckStructure()) {
            return true;
        }
        this.checkRotation();
        if (!this.checkStructure()) {
            if (this.getControllerStatus() != CraftingStatus.CHUNK_UNLOADED) {
                this.setControllerStatus(CraftingStatus.CHUNK_UNLOADED);
                this.markNoUpdateSync();
            }
            return false;
        }
        if (!this.isStructureFormed()) {
            if (this.getControllerStatus() != CraftingStatus.MISSING_STRUCTURE) {
                this.setControllerStatus(CraftingStatus.MISSING_STRUCTURE);
                this.markNoUpdateSync();
            }
            return false;
        }
        this.updateComponents();
        new MachineStructureUpdateEvent(this).postEvent();
        return true;
    }

    protected void updateStatedMachineComponentSync(boolean working) {
        if (this.foundPattern == null) {
            return;
        }
        if (this.workMode == WorkMode.SYNC) {
            this.updateStatedMachineComponent(working);
        } else {
            ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> this.updateStatedMachineComponent(working));
        }
        this.requireUpdateComparatorLevel = true;
        this.markForUpdateSync();
    }

    protected void updateStatedMachineComponent(boolean working) {
        if (this.foundPattern == null) {
            return;
        }
        long start = System.nanoTime() / 1000L;
        this.foundPattern.getPattern().forEach((pos, blockInfo) -> {
            if (!blockInfo.hasStatedMachineComponent()) {
                return;
            }
            BlockPos realPos = this.func_174877_v().func_177971_a((Vec3i)pos);
            IBlockState blockState = this.func_145831_w().func_180495_p(realPos);
            Block block = blockState.func_177230_c();
            if (!(block instanceof BlockStatedMachineComponent)) {
                return;
            }
            this.func_145831_w().func_180501_a(realPos, blockState.func_177226_a(BlockStatedMachineComponent.WORKING_STATE, (Comparable)((Object)(working ? WorkingState.WORKING : WorkingState.IDLE))), 2);
        });
        this.timeRecorder.addUsedTime((int)(System.nanoTime() / 1000L - start));
    }

    public RecipeCraftingContext createContext(ActiveMachineRecipe activeRecipe) {
        RecipeCraftingContext context = this.foundMachine.createContext(activeRecipe, this);
        context.addModifier(MiscUtils.flatten(this.foundModifiers.values()));
        context.addModifier(this.customModifiers.values());
        return context;
    }

    protected void onStructureFormed() {
        new MachineStructureFormedEvent(this).postEvent();
        new MachineStructureUpdateEvent(this).postEvent();
        if (!this.foundDynamicPatterns.isEmpty()) {
            this.addDynamicPatternToBlockArray();
        }
        if (this.workMode == WorkMode.SYNC) {
            this.notifyStructureFormedState(true);
        } else {
            ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> this.notifyStructureFormedState(true));
        }
        this.requireUpdateComparatorLevel = true;
        this.resetStructureCheckCounter();
        if (this.prevMachine != null && !this.prevMachine.equals(this.foundMachine)) {
            this.resetRecipe();
        } else {
            this.prevMachine = null;
        }
        this.markNoUpdateSync();
    }

    public void notifyStructureFormedState(boolean formed) {
        if (this.field_145850_b == null || this.func_174877_v() == null) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (this.controllerRotation == null || !(state.func_177230_c() instanceof BlockController)) {
            return;
        }
        if ((Boolean)state.func_177229_b((IProperty)BlockController.FORMED) == formed) {
            return;
        }
        IBlockState newState = state.func_177230_c().func_176223_P().func_177226_a(BlockController.FACING, (Comparable)this.controllerRotation).func_177226_a((IProperty)BlockController.FORMED, (Comparable)Boolean.valueOf(formed));
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), newState, 8);
        } else {
            this.field_145850_b.func_180501_a(this.func_174877_v(), newState, 3);
        }
    }

    private void addDynamicPatternToBlockArray() {
        this.foundPattern = new TaggedPositionBlockArray(this.foundPattern);
        for (DynamicPattern.Status status : this.foundDynamicPatterns.values()) {
            DynamicPattern pattern = status.pattern();
            pattern.addPatternToBlockArray(this.foundPattern, status.size(), status.matchFacing(), this.controllerRotation);
        }
        this.foundPattern.flushTileBlocksCache();
    }

    protected boolean checkStructure() {
        if (!this.canCheckStructure()) {
            return true;
        }
        this.lastStructureCheckTick = this.ticksExisted;
        if (this.isStructureFormed()) {
            BlockPos ctrlPos = this.func_174877_v();
            if (!this.func_145831_w().func_175711_a(this.foundPattern.getPatternBoundingBox(ctrlPos))) {
                return false;
            }
            if (this.foundMachine.isRequiresBlueprint() && !this.foundMachine.equals(this.getBlueprintMachine())) {
                this.resetMachine(true);
            } else if (!this.foundPattern.matches(this.func_145831_w(), ctrlPos, true, this.foundReplacements) || !this.matchesDynamicPattern(this.foundMachine)) {
                this.resetMachine(true);
            }
        }
        if (this.foundMachine != null && this.foundPattern != null && this.controllerRotation != null && this.foundReplacements != null) {
            return true;
        }
        this.resetMachine(false);
        DynamicMachine blueprint = this.getBlueprintMachine();
        if (blueprint != null && this.matchesRotation(BlockArrayCache.getBlockArrayCache(blueprint.getPattern(), this.controllerRotation), blueprint, this.controllerRotation)) {
            this.onStructureFormed();
            return true;
        }
        if (this.parentMachine != null) {
            if (this.parentMachine.isRequiresBlueprint() && !this.parentMachine.equals(blueprint)) {
                return true;
            }
            if (this.matchesRotation(BlockArrayCache.getBlockArrayCache(this.parentMachine.getPattern(), this.controllerRotation), this.parentMachine, this.controllerRotation)) {
                this.onStructureFormed();
                return true;
            }
            return true;
        }
        this.checkAllPatterns();
        if (!this.isStructureFormed()) {
            this.resetMachine(true);
        }
        return true;
    }

    protected void checkAllPatterns() {
        BlockPos ctrlPos = this.func_174877_v();
        for (DynamicMachine machine : MachineRegistry.getRegistry()) {
            if (machine.isRequiresBlueprint()) continue;
            TaggedPositionBlockArray pattern = BlockArrayCache.getBlockArrayCache(machine.getPattern(), this.controllerRotation);
            if (!this.func_145831_w().func_175711_a(pattern.getPatternBoundingBox(ctrlPos)) || !this.matchesRotation(pattern, machine, this.controllerRotation)) continue;
            this.onStructureFormed();
            break;
        }
    }

    protected void updateComponents() {
        if (this.foundMachine == null || this.foundPattern == null || this.controllerRotation == null || this.foundReplacements == null) {
            this.foundComponents.forEach((te, component) -> MachineComponentManager.INSTANCE.removeOwner((TileEntity)te, this));
            this.foundComponents.clear();
            this.foundModifiers.clear();
            this.foundSmartInterfaces.clear();
            this.resetMachine(false);
            return;
        }
        if (!this.canCheckStructure()) {
            return;
        }
        this.foundUpgrades.clear();
        this.foundUpgradeBuses.clear();
        this.foundComponents.forEach((te, component) -> MachineComponentManager.INSTANCE.removeOwner((TileEntity)te, this));
        this.foundComponents.clear();
        this.foundSmartInterfaces.clear();
        this.foundParallelControllers.clear();
        HashMap found = new HashMap();
        this.componentSet.clear();
        this.foundPattern.getTileBlocksArray().forEach((pos, info) -> this.checkAndAddComponents((BlockPos)pos, this.func_174877_v(), found));
        this.foundComponents.putAll(found);
        this.foundModifiers.clear();
        this.updateModifiers();
        this.updateMultiBlockModifiers();
        if (this.workMode == WorkMode.SYNC) {
            this.distributeCasingColor();
        } else {
            ModularMachinery.EXECUTE_MANAGER.addSyncTask(this::distributeCasingColor);
        }
    }

    private void checkAndAddComponents(BlockPos pos, BlockPos ctrlPos, Map<TileEntity, ProcessingComponent<?>> found) {
        MachineComponent<?> component;
        BlockPos realPos = ctrlPos.func_177971_a((Vec3i)pos);
        if (!this.func_145831_w().func_175667_e(realPos)) {
            return;
        }
        TileEntity te = this.func_145831_w().func_175625_s(realPos);
        if (!(te instanceof MachineComponentTile)) {
            if (te == null) {
                return;
            }
            MachineComponent<?> proxiedComponent = MachineComponentProxyRegistry.INSTANCE.proxy(te);
            if (proxiedComponent == null) {
                return;
            }
            component = proxiedComponent;
        } else {
            component = ((MachineComponentTile)te).provideComponent();
        }
        ComponentSelectorTag tag = this.foundPattern.getTag(pos);
        if (component == null) {
            return;
        }
        if (!component.isAsyncSupported()) {
            this.workMode = WorkMode.SEMI_SYNC;
        }
        this.addComponent(component, tag, te, found);
        if (component instanceof TileParallelController.ParallelControllerProvider) {
            this.foundParallelControllers.add((TileParallelController.ParallelControllerProvider)component);
            return;
        }
        this.checkAndAddUpgradeBus(component);
        this.checkAndAddSmartInterface(component, realPos);
    }

    public void checkAndAddUpgradeBus(MachineComponent<?> component) {
        if (!(component instanceof TileUpgradeBus.UpgradeBusProvider)) {
            return;
        }
        TileUpgradeBus.UpgradeBusProvider upgradeBus = (TileUpgradeBus.UpgradeBusProvider)component;
        upgradeBus.boundMachine(this);
        this.foundUpgradeBuses.add(upgradeBus);
        Map<UpgradeType, List<MachineUpgrade>> found = upgradeBus.getUpgrades(this);
        found.forEach((type, newUpgrades) -> {
            List upgrades = this.foundUpgrades.computeIfAbsent(type.getName(), v -> new ArrayList());
            block0: for (MachineUpgrade newUpgrade : newUpgrades) {
                for (MachineUpgrade u : upgrades) {
                    if (!newUpgrade.equals(u)) continue;
                    if (u.getStackSize() >= u.getType().getMaxStackSize()) continue block0;
                    newUpgrade.incrementStackSize(u.getStackSize());
                    continue block0;
                }
                upgrades.add(newUpgrade);
            }
        });
    }

    protected void updateMultiBlockModifiers() {
        for (MultiBlockModifierReplacement mod : this.foundMachine.getMultiBlockModifiers()) {
            if (!mod.matches(this)) continue;
            this.foundModifiers.put(mod.getModifierName(), mod.getModifiers());
        }
    }

    protected void updateModifiers() {
        int rotations = 0;
        EnumFacing rot = EnumFacing.NORTH;
        while (rot != this.controllerRotation) {
            rot = rot.func_176735_f();
            ++rotations;
        }
        for (Map.Entry<BlockPos, List<SingleBlockModifierReplacement>> offsetModifiers : this.foundMachine.getModifiers().entrySet()) {
            BlockPos at = offsetModifiers.getKey();
            for (int i = 0; i < rotations; ++i) {
                at = new BlockPos(at.func_177952_p(), at.func_177956_o(), -at.func_177958_n());
            }
            BlockPos realAt = this.func_174877_v().func_177971_a((Vec3i)at);
            for (SingleBlockModifierReplacement mod : offsetModifiers.getValue()) {
                BlockArray.BlockInformation info = mod.getBlockInformation();
                for (int i = 0; i < rotations; ++i) {
                    info = info.copyRotateYCCW();
                }
                if (!info.matches(this.func_145831_w(), realAt, true)) continue;
                this.foundModifiers.put(mod.getModifierName(), mod.getModifiers());
            }
        }
    }

    public void checkAndAddSmartInterface(MachineComponent<?> component, BlockPos realPos) {
        TileSmartInterface.SmartInterfaceProvider smartInterface;
        block12: {
            block11: {
                if (!(component instanceof TileSmartInterface.SmartInterfaceProvider)) break block11;
                smartInterface = (TileSmartInterface.SmartInterfaceProvider)component;
                if (!this.foundMachine.smartInterfaceTypesIsEmpty()) break block12;
            }
            return;
        }
        SmartInterfaceData data = smartInterface.getMachineData(this.func_174877_v());
        Map<String, SmartInterfaceType> notFoundInterface = this.foundMachine.getFilteredType(this.foundSmartInterfaces.values());
        if (data != null) {
            String type = data.getType();
            if (notFoundInterface.containsKey(type)) {
                this.foundSmartInterfaces.put(smartInterface, type);
            } else {
                smartInterface.removeMachineData(realPos);
            }
        } else if (notFoundInterface.isEmpty()) {
            Optional<SmartInterfaceType> typeOpt = this.foundMachine.getFirstSmartInterfaceType();
            if (typeOpt.isPresent()) {
                SmartInterfaceType type = typeOpt.get();
                smartInterface.addMachineData(this.func_174877_v(), this.foundMachine.getRegistryName(), type.getType(), type.getDefaultValue(), true);
                this.foundSmartInterfaces.put(smartInterface, type.getType());
            }
        } else {
            SmartInterfaceType type = notFoundInterface.values().stream().sorted().findFirst().get();
            smartInterface.addMachineData(this.func_174877_v(), this.foundMachine.getRegistryName(), type.getType(), type.getDefaultValue(), true);
            this.foundSmartInterfaces.put(smartInterface, type.getType());
        }
    }

    @Override
    public IWorld getIWorld() {
        return CraftTweakerMC.getIWorld((World)this.func_145831_w());
    }

    @Override
    public crafttweaker.api.block.IBlockState getIBlockState() {
        return CraftTweakerMC.getBlockState((IBlockState)this.func_145831_w().func_180495_p(this.func_174877_v()));
    }

    @Override
    public IFacing getFacing() {
        return CraftTweakerMC.getIFacing((EnumFacing)this.controllerRotation);
    }

    @Override
    public IBlockPos getIPos() {
        return CraftTweakerMC.getIBlockPos((BlockPos)this.func_174877_v());
    }

    @Override
    public IBlockPos rotateWithControllerFacing(IBlockPos posCT) {
        BlockPos pos = CraftTweakerMC.getBlockPos((IBlockPos)posCT);
        return CraftTweakerMC.getIBlockPos((BlockPos)MiscUtils.rotateYCCWNorthUntil(pos, this.controllerRotation == null ? EnumFacing.NORTH : this.controllerRotation));
    }

    @Override
    public String getFormedMachineName() {
        return this.isStructureFormed() ? this.foundMachine.getRegistryName().toString() : null;
    }

    @Override
    public IData getCustomData() {
        return CraftTweakerMC.getIDataModifyable((NBTBase)this.customData);
    }

    @Override
    public void setCustomData(IData data) {
        this.customData = CraftTweakerMC.getNBTCompound((IData)data);
        this.markNoUpdateSync();
    }

    public NBTTagCompound getCustomDataTag() {
        return this.customData;
    }

    public void setCustomDataTag(NBTTagCompound customData) {
        this.customData = customData;
    }

    @Override
    public boolean hasModifier(String key) {
        return this.customModifiers.containsKey(key);
    }

    public RecipeCraftingContext.CraftingCheckResult onCheck(RecipeCraftingContext context) {
        RecipeCraftingContext.CraftingCheckResult failure = this.checkPreStartResult(context);
        if (failure != null) {
            return failure;
        }
        RecipeCraftingContext.CraftingCheckResult result = context.getActiveRecipe().canStartCrafting(context);
        return this.checkStartResult(context, result);
    }

    public RecipeCraftingContext.CraftingCheckResult onRestartCheck(RecipeCraftingContext context) {
        RecipeCraftingContext.CraftingCheckResult failure = this.checkPreStartResult(context);
        if (failure != null) {
            return failure;
        }
        RecipeCraftingContext.CraftingCheckResult result = context.getActiveRecipe().canRestartCrafting(context);
        return this.checkStartResult(context, result);
    }

    @Nullable
    public RecipeCraftingContext.CraftingCheckResult checkPreStartResult(RecipeCraftingContext context) {
        RecipeCheckEvent event = new RecipeCheckEvent(this, context, Phase.START);
        event.postEvent();
        if (event.isFailure()) {
            RecipeCraftingContext.CraftingCheckResult failure = new RecipeCraftingContext.CraftingCheckResult();
            failure.addError(event.getFailureReason());
            return failure;
        }
        return null;
    }

    @Nonnull
    public RecipeCraftingContext.CraftingCheckResult checkStartResult(RecipeCraftingContext context, RecipeCraftingContext.CraftingCheckResult result) {
        if (result.isFailure()) {
            return result;
        }
        RecipeCheckEvent event = new RecipeCheckEvent(this, context, Phase.END);
        event.postEvent();
        if (event.isFailure()) {
            RecipeCraftingContext.CraftingCheckResult failure = new RecipeCraftingContext.CraftingCheckResult();
            failure.addError(event.getFailureReason());
            return failure;
        }
        return result;
    }

    public void onMachineTick(Phase phase) {
        new MachineTickEvent(this, phase).postEvent();
    }

    @Override
    public void addPermanentModifier(String key, RecipeModifier newModifier) {
        if (newModifier != null) {
            this.customModifiers.put(key, newModifier);
            this.flushContextModifier();
        }
    }

    @Override
    public void removePermanentModifier(String key) {
        if (this.hasModifier(key)) {
            this.customModifiers.remove(key);
            this.flushContextModifier();
        }
    }

    public abstract void flushContextModifier();

    public Map<TileSmartInterface.SmartInterfaceProvider, String> getFoundSmartInterfaces() {
        return this.foundSmartInterfaces;
    }

    public Map<String, List<MachineUpgrade>> getFoundUpgrades() {
        return this.foundUpgrades;
    }

    public List<TileUpgradeBus.UpgradeBusProvider> getFoundUpgradeBuses() {
        return this.foundUpgradeBuses;
    }

    public List<TileParallelController.ParallelControllerProvider> getFoundParallelControllers() {
        return this.foundParallelControllers;
    }

    public Map<TileEntity, ProcessingComponent<?>> getFoundComponents() {
        return this.foundComponents;
    }

    public DynamicMachine.ModifierReplacementMap getFoundReplacements() {
        return this.foundReplacements;
    }

    public Map<String, RecipeModifier> getCustomModifiers() {
        return this.customModifiers;
    }

    public Map<String, List<RecipeModifier>> getFoundModifiers() {
        return this.foundModifiers;
    }

    @Override
    @Nullable
    public SmartInterfaceData getSmartInterfaceData(String requiredType) {
        AtomicReference<Object> reference = new AtomicReference<Object>(null);
        this.foundSmartInterfaces.forEach((provider, type) -> {
            if (type.equals(requiredType)) {
                reference.set(provider);
            }
        });
        TileSmartInterface.SmartInterfaceProvider smartInterface = reference.get();
        if (smartInterface != null) {
            return smartInterface.getMachineData(this.func_174877_v());
        }
        return null;
    }

    @Override
    public SmartInterfaceData[] getSmartInterfaceDataList() {
        ArrayList dataList = new ArrayList();
        BlockPos ctrlPos = this.func_174877_v();
        this.foundSmartInterfaces.forEach((provider, type) -> {
            SmartInterfaceData data = provider.getMachineData(ctrlPos);
            if (data != null) {
                dataList.add(data);
            }
        });
        return dataList.toArray(new SmartInterfaceData[0]);
    }

    @Override
    public String[] getFoundModifierReplacements() {
        return this.foundModifiers.keySet().toArray(new String[0]);
    }

    @Override
    public boolean hasModifierReplacement(String modifierName) {
        return this.foundModifiers.containsKey(modifierName);
    }

    @Override
    public boolean hasMachineUpgrade(String upgradeName) {
        List<MachineUpgrade> upgrades = this.foundUpgrades.get(upgradeName);
        return upgrades != null && !upgrades.isEmpty();
    }

    @Override
    @Nullable
    public MachineUpgrade[] getMachineUpgrade(String upgradeName) {
        List<MachineUpgrade> upgrades = this.foundUpgrades.get(upgradeName);
        if (upgrades == null) {
            return new MachineUpgrade[0];
        }
        ArrayList<MachineUpgrade> filtered = new ArrayList<MachineUpgrade>();
        for (MachineUpgrade upgrade : upgrades) {
            TileUpgradeBus parentBus = upgrade.getParentBus();
            if (parentBus == null) continue;
            upgrade.readNBT(parentBus.provideComponent().getUpgradeCustomData(upgrade));
            filtered.add(upgrade);
        }
        return filtered.toArray(new MachineUpgrade[0]);
    }

    @Override
    @Nullable
    public IDynamicPatternInfo getDynamicPattern(String patternName) {
        return this.foundDynamicPatterns.get(patternName);
    }

    @Override
    public int getBlocksInPattern(IItemStack blockStack) {
        if (this.foundPattern == null || blockStack == null) {
            return 0;
        }
        IBlockDefinition blockDef = blockStack.asBlock().getDefinition();
        if (blockStack.getMetadata() == Short.MAX_VALUE) {
            return this.getBlocksInPattern(blockDef.getDefaultState().matchBlock());
        }
        return this.getBlocksInPattern((IBlockStateMatcher)blockDef.getStateFromMeta(blockStack.getMetadata()));
    }

    @Override
    public int getBlocksInPattern(IBlockStateMatcher blockStateMatcher) {
        if (this.foundPattern == null) {
            return 0;
        }
        return this.getBlocksInPatternInternal(state -> blockStateMatcher.matches(CraftTweakerMC.getBlockState((IBlockState)state)));
    }

    @Override
    public int getBlocksInPattern(String blockName) {
        if (this.foundPattern == null) {
            return 0;
        }
        List<IBlockState> applicable = BlockArray.BlockInformation.getDescriptor(blockName).getApplicable();
        return this.getBlocksInPatternInternal(applicable::contains);
    }

    @Override
    public int getBlocksInPattern(IBlockStatePredicate predicate) {
        if (this.foundPattern == null) {
            return 0;
        }
        return this.getBlocksInPatternInternal(state -> predicate.test(CraftTweakerMC.getBlockState((IBlockState)state)));
    }

    public int getBlocksInPatternInternal(Predicate<IBlockState> predicate) {
        if (this.foundPattern == null) {
            return 0;
        }
        int count = 0;
        for (BlockPos pos : this.foundPattern.getPattern().keySet()) {
            BlockPos realPos = this.func_174877_v().func_177982_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            IBlockState state = this.func_145831_w().func_180495_p(realPos);
            if (state.func_177230_c() == Blocks.field_150350_a || !predicate.test(state)) continue;
            ++count;
        }
        return count;
    }

    @Override
    @Nullable
    public IPlayer getOwnerIPlayer() {
        if (this.owner == null) {
            return null;
        }
        MinecraftServer server = this.func_145831_w().func_73046_m();
        if (server == null) {
            return null;
        }
        EntityPlayerMP player = server.func_184103_al().func_177451_a(this.owner);
        return player != null ? CraftTweakerMC.getIPlayer((EntityPlayer)player) : null;
    }

    @Override
    @Nullable
    public String getOwnerName() {
        if (this.owner == null) {
            return null;
        }
        MinecraftServer server = this.func_145831_w().func_73046_m();
        if (server == null) {
            return null;
        }
        GameProfile profile = server.func_152358_ax().func_152652_a(this.owner);
        return profile != null ? profile.getName() : null;
    }

    @Override
    @Nullable
    public String getOwnerUUIDString() {
        return this.owner == null ? null : this.owner.toString();
    }

    public Map<String, DynamicPattern.Status> getDynamicPatterns() {
        return this.foundDynamicPatterns;
    }

    @Override
    public TileMultiblockMachineController getController() {
        return this;
    }

    public void incrementRecipeSearchRetryCount() {
        ++this.recipeResearchRetryCounter;
    }

    @Override
    public void markNoUpdate() {
        super.markNoUpdate();
        this.requireUpdateComparatorLevel = false;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        ClientProxy.clientScheduler.addRunnable(() -> {
            BlockModelHider.hideOrShowBlocks(this);
            this.notifyStructureFormedState(this.isStructureFormed());
        }, 0);
        this.loaded = true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.loaded = false;
        this.foundComponents.forEach((te, component) -> MachineComponentManager.INSTANCE.removeOwner((TileEntity)te, this));
        if (this.func_145831_w().field_72995_K) {
            BlockModelHider.hideOrShowBlocks(this);
        }
    }

    public void onLoad() {
        super.onLoad();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.inventory = IOInventory.deserialize(this, compound.func_74775_l("items"));
        this.inventory.setStackLimit(1, 0);
        if (compound.func_74764_b("owner")) {
            String ownerUUIDStr = compound.func_74779_i("owner");
            try {
                this.owner = UUID.fromString(ownerUUIDStr);
            }
            catch (Exception e) {
                ModularMachinery.log.warn("Invalid owner uuid {}", (Object)ownerUUIDStr, (Object)e);
            }
        }
        this.readMachineNBT(compound);
        if (this.loaded && this.field_145850_b.field_72995_K) {
            ClientProxy.clientScheduler.addRunnable(() -> {
                BlockModelHider.hideOrShowBlocks(this);
                this.notifyStructureFormedState(this.isStructureFormed());
                if (!this.isStructureFormed()) {
                    this.animationFactory = null;
                }
            }, 0);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a("items", (NBTBase)this.inventory.writeNBT());
        if (this.owner != null) {
            compound.func_74778_a("owner", this.owner.toString());
        }
        if (this.parentMachine != null) {
            compound.func_74778_a("parentMachine", this.parentMachine.getRegistryName().toString());
        }
        if (this.prevMachine != null) {
            compound.func_74778_a("prevMachine", this.prevMachine.getRegistryName().toString());
        }
        if (this.controllerRotation != null) {
            compound.func_74774_a("rotation", (byte)this.controllerRotation.func_176736_b());
        }
        if (this.foundMachine != null) {
            NBTTagList tagList;
            compound.func_74778_a("machine", this.foundMachine.getRegistryName().toString());
            if (!this.foundDynamicPatterns.isEmpty()) {
                tagList = new NBTTagList();
                this.foundDynamicPatterns.values().forEach(pattern -> {
                    NBTTagCompound patternTag = new NBTTagCompound();
                    pattern.writeToNBT(patternTag);
                    tagList.func_74742_a((NBTBase)patternTag);
                });
                compound.func_74782_a("dynamicPatterns", (NBTBase)tagList);
            }
            if (!this.customData.func_82582_d()) {
                compound.func_74782_a("customData", (NBTBase)this.customData);
            }
            if (!this.customModifiers.isEmpty()) {
                tagList = new NBTTagList();
                this.customModifiers.forEach((key, modifier) -> {
                    if (key != null && modifier != null) {
                        NBTTagCompound modifierTag = new NBTTagCompound();
                        modifierTag.func_74778_a("key", key);
                        modifierTag.func_74782_a("modifier", (NBTBase)modifier.serialize());
                        tagList.func_74742_a((NBTBase)modifierTag);
                    }
                });
                compound.func_74782_a("customModifier", (NBTBase)tagList);
            }
        }
    }

    protected void readMachineNBT(NBTTagCompound compound) {
        TaggedPositionBlockArray pattern;
        if (!compound.func_74764_b("machine") || !compound.func_74764_b("rotation")) {
            this.resetMachine(true);
            return;
        }
        ResourceLocation rl = new ResourceLocation(compound.func_74779_i("machine"));
        DynamicMachine machine = MachineRegistry.getRegistry().getMachine(rl);
        if (machine == null) {
            ModularMachinery.log.info("Couldn't find machine named {} for controller at {}", (Object)rl, (Object)this.func_174877_v());
            this.resetMachine(true);
            return;
        }
        this.foundMachine = machine;
        this.controllerRotation = EnumFacing.func_176731_b((int)compound.func_74771_c("rotation"));
        if (compound.func_74764_b("prevMachine")) {
            this.prevMachine = MachineRegistry.getRegistry().getMachine(new ResourceLocation(compound.func_74779_i("prevMachine")));
        }
        if ((pattern = BlockArrayCache.getBlockArrayCache(machine.getPattern(), this.controllerRotation)) == null) {
            ModularMachinery.log.info("{} has a empty pattern cache! Please report this to the mod author.", (Object)rl);
            this.resetMachine(true);
            return;
        }
        this.foundPattern = pattern;
        if (compound.func_150297_b("dynamicPatterns", 9)) {
            NBTTagList dynPatterns = compound.func_150295_c("dynamicPatterns", 10);
            IntStream.range(0, dynPatterns.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)dynPatterns).func_150305_b(arg_0)).map(tag -> DynamicPattern.Status.readFromNBT(tag, this.foundMachine)).filter(Objects::nonNull).forEach(patternStatus -> this.foundDynamicPatterns.put(patternStatus.getPatternName(), (DynamicPattern.Status)patternStatus));
            if (!this.foundDynamicPatterns.isEmpty()) {
                this.addDynamicPatternToBlockArray();
            }
        }
        DynamicMachine.ModifierReplacementMap replacements = machine.getModifiersAsMatchingReplacements();
        for (EnumFacing offset = EnumFacing.NORTH; offset != this.controllerRotation; offset = offset.func_176746_e()) {
            replacements = replacements.rotateYCCW();
        }
        this.foundReplacements = replacements;
        if (compound.func_74764_b("customData")) {
            this.customData = compound.func_74775_l("customData");
        }
        this.customModifiers.clear();
        if (compound.func_74764_b("customModifier")) {
            NBTTagList tagList = compound.func_150295_c("customModifier", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound modifierTag = tagList.func_150305_b(i);
                this.customModifiers.put(modifierTag.func_74779_i("key"), RecipeModifier.deserialize(modifierTag.func_74775_l("modifier")));
            }
        }
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(@Nonnull World world, @Nonnull BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @ZenMethod
    public int getTicksExisted() {
        return this.ticksExisted;
    }

    public WorkMode getWorkMode() {
        return this.workMode;
    }

    public void setWorkMode(WorkMode workMode) {
        this.workMode = workMode;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double func_145833_n() {
        return 65536.0;
    }

    @Optional.Method(modid="geckolib3")
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    @Optional.Method(modid="geckolib3")
    public AnimationFactory getFactory() {
        return (AnimationFactory)(this.animationFactory == null ? (this.animationFactory = new AnimationFactory((IAnimatable)this)) : this.animationFactory);
    }

    @Optional.Method(modid="geckolib3")
    public PlayState animationPredicate(AnimationEvent<TileMultiblockMachineController> event) {
        PlayState playState;
        if (!this.isStructureFormed()) {
            return PlayState.STOP;
        }
        ControllerModelAnimationEvent eventMM = new ControllerModelAnimationEvent(this, event);
        eventMM.postEvent();
        AnimationBuilder animationBuilder = new AnimationBuilder();
        for (ControllerModelAnimationEvent.AnimationCT animation : eventMM.getAnimations()) {
            animationBuilder.addAnimation(animation.animationName(), (ILoopType)(animation.loop() ? ILoopType.EDefaultLoopTypes.LOOP : ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        }
        event.getController().setAnimation(animationBuilder);
        switch (eventMM.getPlayState()) {
            case 0: {
                playState = PlayState.CONTINUE;
                break;
            }
            default: {
                playState = PlayState.STOP;
            }
        }
        return playState;
    }

    @Optional.Method(modid="geckolib3")
    public MachineControllerModel getCurrentModel() {
        MachineControllerModel model;
        String modelName = this.getCurrentModelName();
        if (modelName != null && !modelName.isEmpty() && (model = DynamicMachineModelRegistry.INSTANCE.getMachineModel(modelName)) != null) {
            return model;
        }
        return DynamicMachineModelRegistry.INSTANCE.getMachineDefaultModel(this.foundMachine);
    }

    @Optional.Method(modid="geckolib3")
    public String getCurrentModelName() {
        ControllerModelGetEvent event = new ControllerModelGetEvent(this);
        event.postEvent();
        return event.getModelName();
    }

    public static enum WorkMode {
        ASYNC(TextFormatting.GREEN + "ASYNC" + TextFormatting.WHITE),
        SEMI_SYNC(TextFormatting.YELLOW + "SEMI-SYNC" + TextFormatting.WHITE),
        SYNC(TextFormatting.RED + "SYNC" + TextFormatting.WHITE);

        private final String displayName;

        private WorkMode(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static enum Type {
        MISSING_STRUCTURE,
        CHUNK_UNLOADED,
        NO_RECIPE,
        IDLE,
        CRAFTING;


        public String getUnlocalizedDescription() {
            return "gui.controller.status." + this.name().toLowerCase();
        }
    }

    public static enum StructureCheckMode {
        FULL,
        OPTIONAL;

    }
}

