/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles.base;

import hellfirepvp.modularmachinery.common.block.prop.ItemBusSize;
import hellfirepvp.modularmachinery.common.tiles.base.SelectiveUpdateTileEntity;
import hellfirepvp.modularmachinery.common.tiles.base.TileInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public abstract class TileItemBus
extends TileInventory
implements SelectiveUpdateTileEntity {
    protected int successCounter = 0;
    protected boolean inventoryChanged = false;
    private ItemBusSize size;

    public TileItemBus() {
    }

    public TileItemBus(ItemBusSize size) {
        super(size.getSlotCount());
        this.size = size;
    }

    @Override
    public void doRestrictedTick() {
    }

    protected boolean canWork(int minWorkDelay, int maxWorkDelay) {
        if (this.inventoryChanged) {
            this.inventoryChanged = false;
            return true;
        }
        if (this.successCounter <= 0) {
            return this.ticksExisted % maxWorkDelay == 0;
        }
        int workDelay = Math.max(minWorkDelay, maxWorkDelay - this.successCounter * 5);
        return this.ticksExisted % workDelay == 0;
    }

    protected void incrementSuccessCounter(int maxWorkDelay, int minWorkDelay) {
        int max = (maxWorkDelay - minWorkDelay) / 5;
        if (this.successCounter < max) {
            ++this.successCounter;
        }
    }

    protected void decrementSuccessCounter() {
        if (this.successCounter > 0) {
            --this.successCounter;
        }
    }

    public ItemBusSize getSize() {
        return this.size;
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.size = ItemBusSize.values()[MathHelper.func_76125_a((int)compound.func_74762_e("busSize"), (int)0, (int)(ItemBusSize.values().length - 1))];
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74768_a("busSize", this.size.ordinal());
    }
}

