/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles.base;

import hellfirepvp.modularmachinery.ModularMachinery;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class TileEntitySynchronized
extends TileEntity {
    protected boolean requireUpdateComparatorLevel = false;
    private boolean inUpdateTask = false;
    private boolean inMarkTask = false;
    private long lastUpdateTick = 0L;

    public final void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readCustomNBT(compound);
    }

    public void readCustomNBT(NBTTagCompound compound) {
    }

    public void readNetNBT(NBTTagCompound compound) {
    }

    @Nonnull
    public final NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        NBTTagCompound writeToNBT = super.func_189515_b(compound);
        this.writeCustomNBT(writeToNBT);
        return writeToNBT;
    }

    public void writeCustomNBT(NBTTagCompound compound) {
    }

    public void writeNetNBT(NBTTagCompound compound) {
    }

    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        super.func_189515_b(compound);
        this.writeCustomNBT(compound);
        this.writeNetNBT(compound);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 255, compound);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        super.func_189515_b(compound);
        this.writeCustomNBT(compound);
        return compound;
    }

    public final void onDataPacket(@Nonnull NetworkManager manager, @Nonnull SPacketUpdateTileEntity packet) {
        super.onDataPacket(manager, packet);
        this.readCustomNBT(packet.func_148857_g());
        this.readNetNBT(packet.func_148857_g());
    }

    public void markNoUpdate() {
        World world = this.func_145831_w();
        if (world == null) {
            return;
        }
        if (this.requireUpdateComparatorLevel) {
            world.func_175666_e(this.field_174879_c, this.func_145838_q());
        }
        this.markChunkDirty();
        this.inMarkTask = false;
        this.lastUpdateTick = world.func_82737_E();
    }

    public void markForUpdate() {
        this.markNoUpdate();
        this.notifyUpdate();
    }

    public void notifyUpdate() {
        World world = this.func_145831_w();
        if (world == null) {
            return;
        }
        IBlockState state = world.func_180495_p(this.field_174879_c);
        world.func_184138_a(this.field_174879_c, state, state, 3);
        this.inUpdateTask = false;
    }

    public void markNoUpdateSync() {
        if (this.inMarkTask) {
            return;
        }
        ModularMachinery.EXECUTE_MANAGER.addTEMarkNoUpdateTask(this);
        this.inMarkTask = true;
    }

    public void markChunkDirty() {
        if (this.field_145850_b == null) {
            return;
        }
        Chunk loadedChunk = this.field_145850_b.func_72863_F().func_186026_b(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4);
        if (loadedChunk != null) {
            loadedChunk.func_76630_e();
        }
    }

    public void markForUpdateSync() {
        if (this.inUpdateTask) {
            return;
        }
        ModularMachinery.EXECUTE_MANAGER.addTEUpdateTask(this);
        this.inUpdateTask = true;
        this.inMarkTask = true;
    }

    public boolean isInUpdateTask() {
        return this.inUpdateTask;
    }

    public long getLastUpdateTick() {
        return this.lastUpdateTick;
    }
}

