/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles.base;

import cofh.redstoneflux.api.IEnergyStorage;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import gregtech.api.capability.GregtechCapabilities;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.block.prop.EnergyHatchData;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.tiles.base.GTEnergyContainer;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.SelectiveUpdateTileEntity;
import hellfirepvp.modularmachinery.common.tiles.base.TileColorableMachineComponent;
import hellfirepvp.modularmachinery.common.util.IEnergyHandlerAsync;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import hellfirepvp.modularmachinery.common.util.RedstoneHelper;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.power.IBigPower;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyStorage", modid="redstoneflux"), @Optional.Interface(iface="mcjty.lib.api.power.IBigPower", modid="theoneprobe")})
public abstract class TileEnergyHatch
extends TileColorableMachineComponent
implements ITickable,
net.minecraftforge.energy.IEnergyStorage,
IEnergyHandlerAsync,
MachineComponentTile,
IEnergyStorage,
SelectiveUpdateTileEntity,
IBigPower {
    protected final AtomicLong energy = new AtomicLong();
    protected EnergyHatchData size;
    protected BlockPos foundCore = null;
    protected int energyCoreSearchFailedCount = 0;
    protected boolean tickedOnce = false;
    private GTEnergyContainer energyContainer;
    private int prevRedstoneLevel = 0;

    public TileEnergyHatch() {
    }

    public TileEnergyHatch(EnergyHatchData size, IOType ioType) {
        this.size = size;
        this.energyContainer = new GTEnergyContainer(this, ioType);
    }

    @Optional.Method(modid="gregtech")
    private static Capability<?> getGTEnergyCapability() {
        return GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER;
    }

    protected static int convertDownEnergy(long energy) {
        return energy >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)energy;
    }

    public long getStoredPower() {
        return this.energy.get();
    }

    public long getCapacity() {
        return this.size.maxEnergy;
    }

    @Optional.Method(modid="draconicevolution")
    protected long attemptDECoreTransfer(long maxCanReceive) {
        return 0L;
    }

    @Optional.Method(modid="draconicevolution")
    protected void findCore() {
        if (this.field_145850_b.func_82737_E() % (long)this.currentFoundCoreDelay() != 0L) {
            return;
        }
        TileEnergyStorageCore core = null;
        Iterable positions = BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-EnergyHatchData.searchRange, -EnergyHatchData.searchRange, -EnergyHatchData.searchRange), (BlockPos)this.field_174879_c.func_177982_a(EnergyHatchData.searchRange, EnergyHatchData.searchRange, EnergyHatchData.searchRange));
        for (BlockPos blockPos : positions) {
            TileEntity tile;
            if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() != DEFeatures.energyStorageCore || !((tile = this.field_145850_b.func_175625_s(blockPos)) instanceof TileEnergyStorageCore) || !((TileEnergyStorageCore)tile).active.value) continue;
            core = (TileEnergyStorageCore)tile;
            break;
        }
        if (core == null) {
            ++this.energyCoreSearchFailedCount;
        } else {
            this.foundCore = core.func_174877_v();
            this.energyCoreSearchFailedCount = 0;
        }
    }

    protected int currentFoundCoreDelay() {
        return EnergyHatchData.energyCoreSearchDelay + (EnergyHatchData.delayedEnergyCoreSearch ? Math.min(this.energyCoreSearchFailedCount * 20, EnergyHatchData.maxEnergyCoreSearchDelay - EnergyHatchData.energyCoreSearchDelay) : 0);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int insertable = this.energy.get() + (long)maxReceive > this.size.maxEnergy ? TileEnergyHatch.convertDownEnergy(this.size.maxEnergy - this.energy.get()) : maxReceive;
        insertable = Math.min(insertable, TileEnergyHatch.convertDownEnergy(this.size.transferLimit));
        if (!simulate) {
            this.energy.set(MiscUtils.clamp(this.energy.get() + (long)insertable, 0L, this.size.maxEnergy));
            this.markNoUpdate();
        }
        return insertable;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int extractable = this.energy.get() - (long)maxExtract < 0L ? TileEnergyHatch.convertDownEnergy(this.energy.get()) : maxExtract;
        extractable = Math.min(extractable, TileEnergyHatch.convertDownEnergy(this.size.transferLimit));
        if (!simulate) {
            this.energy.set(MiscUtils.clamp(this.energy.get() - (long)extractable, 0L, this.size.maxEnergy));
            this.markNoUpdate();
        }
        return extractable;
    }

    public int getEnergyStored() {
        return TileEnergyHatch.convertDownEnergy(this.energy.get());
    }

    public int getMaxEnergyStored() {
        return TileEnergyHatch.convertDownEnergy(this.size.maxEnergy);
    }

    public abstract boolean canExtract();

    public abstract boolean canReceive();

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this;
        }
        if (Mods.GREGTECH.isPresent() && capability == TileEnergyHatch.getGTEnergyCapability()) {
            return (T)this.energyContainer;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        NBTBase energyTag = compound.func_74781_a("energy");
        if (energyTag instanceof NBTPrimitive) {
            this.energy.set(((NBTPrimitive)energyTag).func_150291_c());
        }
        this.size = EnergyHatchData.values()[compound.func_74762_e("hatchSize")];
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74772_a("energy", this.energy.get());
        compound.func_74768_a("hatchSize", this.size.ordinal());
    }

    @Override
    public void markNoUpdate() {
        int redstoneLevel = RedstoneHelper.getRedstoneLevel(this);
        if (this.prevRedstoneLevel != redstoneLevel) {
            this.prevRedstoneLevel = redstoneLevel;
            this.requireUpdateComparatorLevel = true;
        }
        super.markNoUpdate();
        this.requireUpdateComparatorLevel = false;
    }

    public EnergyHatchData getTier() {
        return this.size;
    }

    @Override
    public long getCurrentEnergy() {
        return this.energy.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentEnergy(long energy) {
        TileEnergyHatch tileEnergyHatch = this;
        synchronized (tileEnergyHatch) {
            this.energy.set(MiscUtils.clamp(energy, 0L, this.getMaxEnergy()));
        }
        this.markNoUpdateSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean extractEnergy(long extract) {
        boolean success = false;
        TileEnergyHatch tileEnergyHatch = this;
        synchronized (tileEnergyHatch) {
            if (this.energy.get() >= extract) {
                this.energy.addAndGet(-extract);
                success = true;
            }
        }
        if (success) {
            this.markNoUpdateSync();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean receiveEnergy(long receive) {
        boolean success = false;
        TileEnergyHatch tileEnergyHatch = this;
        synchronized (tileEnergyHatch) {
            if (this.getRemainingCapacity() >= receive) {
                this.energy.addAndGet(receive);
                success = true;
            }
        }
        if (success) {
            this.markNoUpdateSync();
        }
        return success;
    }

    @Override
    public long getMaxEnergy() {
        return this.size.maxEnergy;
    }
}

