/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles;

import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.mmce.common.event.recipe.RecipeFailureEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeFinishEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeStartEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeTickEvent;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineRecipeThread;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.machine.RecipeThread;
import hellfirepvp.modularmachinery.common.machine.TaggedPositionBlockArray;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.BlockArrayCache;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class TileMachineController
extends TileMultiblockMachineController {
    private MachineRecipeThread recipeThread = new MachineRecipeThread(this);
    private BlockController parentController = null;
    private boolean redstoneEffected = false;

    public TileMachineController() {
    }

    public TileMachineController(IBlockState state) {
        this();
        if (state.func_177230_c() instanceof BlockController) {
            this.parentController = (BlockController)state.func_177230_c();
            this.parentMachine = this.parentController.getParentMachine();
            this.controllerRotation = (EnumFacing)state.func_177229_b(BlockController.FACING);
        } else {
            ModularMachinery.log.warn("Invalid controller block at " + this.func_174877_v() + " !");
            this.controllerRotation = EnumFacing.NORTH;
        }
    }

    @Override
    public void doControllerTick() {
        if (this.getStrongPower() > 0) {
            this.redstoneEffected = true;
            return;
        }
        switch (this.workMode) {
            case ASYNC: {
                if (this.executeGroupId == -1L) {
                    this.tickExecutor = ModularMachinery.EXECUTE_MANAGER.addTask(() -> {
                        if (this.doAsyncStep()) {
                            return;
                        }
                        this.doSyncStep(false);
                    }, this.timeRecorder.usedTimeAvg());
                    break;
                }
                this.tickExecutor = ModularMachinery.EXECUTE_MANAGER.addExecuteGroupTask(() -> {
                    if (this.doAsyncStep()) {
                        return;
                    }
                    this.doSyncStep(false);
                }, this.executeGroupId);
                break;
            }
            case SEMI_SYNC: {
                if (this.executeGroupId == -1L) {
                    this.tickExecutor = ModularMachinery.EXECUTE_MANAGER.addTask(() -> {
                        if (this.doAsyncStep()) {
                            return;
                        }
                        ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> this.doSyncStep(true));
                    }, this.timeRecorder.usedTimeAvg());
                    break;
                }
                this.tickExecutor = ModularMachinery.EXECUTE_MANAGER.addExecuteGroupTask(() -> {
                    if (this.doAsyncStep()) {
                        return;
                    }
                    ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> this.doSyncStep(true));
                }, this.executeGroupId);
                break;
            }
            case SYNC: {
                this.tickExecutor = null;
                if (this.doAsyncStep()) {
                    return;
                }
                this.doSyncStep(false);
            }
        }
    }

    protected boolean doAsyncStep() {
        return !this.doStructureCheck() || !this.isStructureFormed();
    }

    protected void doSyncStep(boolean recordTime) {
        boolean workingStatus;
        long tickStart = recordTime ? System.nanoTime() : 0L;
        this.onMachineTick(Phase.START);
        boolean prevWorkingStatus = this.isWorking();
        if (this.doRecipeTick()) {
            this.markNoUpdateSync();
        }
        if (prevWorkingStatus != (workingStatus = this.isWorking())) {
            this.updateStatedMachineComponentSync(workingStatus);
        }
        this.onMachineTick(Phase.END);
        if (recordTime) {
            this.timeRecorder.incrementUsedTime((int)TimeUnit.MICROSECONDS.convert(System.nanoTime() - tickStart, TimeUnit.NANOSECONDS));
        }
    }

    protected boolean doRecipeTick() {
        ActiveMachineRecipe activeRecipe;
        MachineRecipeThread thread = this.recipeThread;
        CraftingStatus status = thread.getStatus();
        if (thread.getActiveRecipe() == null) {
            thread.searchAndStartRecipe();
        }
        if ((activeRecipe = thread.getActiveRecipe()) == null) {
            if (!status.equals(thread.getStatus())) {
                this.markNoUpdateSync();
            }
            return false;
        }
        if (thread.isWaitForFinish()) {
            if (this.ticksExisted % 10 == 0) {
                thread.onFinished();
            }
            return true;
        }
        if (thread.getContext() == null) {
            thread.setContext(thread.createContext(activeRecipe));
        }
        RecipeTickEvent event = new RecipeTickEvent((TileMultiblockMachineController)this, (RecipeThread)thread, Phase.START);
        event.postEvent();
        if (event.isFailure()) {
            return true;
        }
        if (status != thread.getStatus()) {
            status = thread.getStatus();
            thread.onTick();
            thread.setStatus(status);
        } else {
            status = thread.onTick();
        }
        if (this.isNotWorking(thread, status)) {
            if (enableFullDataSync) {
                this.markForUpdateSync();
            } else {
                this.markNoUpdateSync();
            }
            return true;
        }
        new RecipeTickEvent((TileMultiblockMachineController)this, (RecipeThread)thread, Phase.END).postEvent();
        if (thread.isCompleted()) {
            thread.onFinished();
        }
        return true;
    }

    protected boolean isNotWorking(MachineRecipeThread thread, CraftingStatus status) {
        if (status.isCrafting()) {
            return false;
        }
        boolean destruct = this.onFailure();
        if (destruct) {
            thread.setActiveRecipe(null).setContext(null).getSemiPermanentModifiers().clear();
        }
        return true;
    }

    @Override
    protected void updateComponents() {
        super.updateComponents();
        RecipeCraftingContext ctx = this.recipeThread.getContext();
        if (ctx == null) {
            return;
        }
        ctx.updateComponents(this.foundComponents.values());
    }

    @Override
    protected boolean canCheckStructure() {
        if (this.redstoneEffected) {
            this.redstoneEffected = false;
            return true;
        }
        return super.canCheckStructure();
    }

    @Override
    protected void checkRotation() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockController) {
            this.parentController = (BlockController)state.func_177230_c();
            this.parentMachine = this.parentController.getParentMachine();
            this.controllerRotation = (EnumFacing)state.func_177229_b(BlockController.FACING);
        } else {
            ModularMachinery.log.warn("Invalid controller block at " + this.func_174877_v() + " !");
            this.controllerRotation = EnumFacing.NORTH;
        }
    }

    public BlockController getParentController() {
        return this.parentController;
    }

    public DynamicMachine getParentMachine() {
        return this.parentMachine;
    }

    public void onStart() {
        new RecipeStartEvent(this, this.recipeThread).postEvent();
        ActiveMachineRecipe activeRecipe = this.recipeThread.getActiveRecipe();
        activeRecipe.start(this.recipeThread.getContext());
        this.resetRecipeSearchRetryCount();
        if (enableFullDataSync) {
            this.markForUpdateSync();
        } else {
            this.markNoUpdateSync();
        }
    }

    public boolean onFailure() {
        ActiveMachineRecipe activeRecipe = this.recipeThread.getActiveRecipe();
        if (activeRecipe == null) {
            return false;
        }
        MachineRecipe recipe = activeRecipe.getRecipe();
        RecipeFailureEvent event = new RecipeFailureEvent(this, this.recipeThread, this.recipeThread.getStatus().getUnlocMessage(), recipe.doesCancelRecipeOnPerTickFailure());
        event.postEvent();
        return event.isDestructRecipe();
    }

    public void onFinished() {
        new RecipeFinishEvent(this, this.recipeThread).postEvent();
        if (enableFullDataSync) {
            this.markForUpdateSync();
        } else {
            this.markNoUpdateSync();
        }
    }

    @Override
    protected void checkAllPatterns() {
        for (DynamicMachine machine : MachineRegistry.getRegistry()) {
            TaggedPositionBlockArray pattern;
            if (machine.isRequiresBlueprint() || machine.isFactoryOnly() || !this.matchesRotation(pattern = BlockArrayCache.getBlockArrayCache(machine.getPattern(), this.controllerRotation), machine, this.controllerRotation)) continue;
            this.onStructureFormed();
            break;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.recipeThread.invalidate();
    }

    @Override
    public ActiveMachineRecipe getActiveRecipe() {
        return this.recipeThread.getActiveRecipe();
    }

    @Override
    @Nullable
    public ActiveMachineRecipe[] getActiveRecipeList() {
        return new ActiveMachineRecipe[]{this.recipeThread.getActiveRecipe()};
    }

    @Override
    public RecipeThread[] getRecipeThreadList() {
        return new RecipeThread[]{this.recipeThread};
    }

    @Override
    public int getExtraThreadCount() {
        return 0;
    }

    @Override
    public void setExtraThreadCount(int extraThreadCount) {
    }

    @Override
    public boolean isWorking() {
        return this.lastStrongPower <= 0 && this.getControllerStatus().isCrafting();
    }

    @Override
    public void addModifier(String key, RecipeModifier modifier) {
        this.recipeThread.addModifier(key, modifier);
    }

    @Override
    public void removeModifier(String key) {
        this.recipeThread.removeModifier(key);
    }

    @Override
    public void overrideStatusInfo(String newInfo) {
        this.getControllerStatus().overrideStatusMessage(newInfo);
    }

    @Override
    public void flushContextModifier() {
        this.recipeThread.flushContextModifier();
    }

    @Override
    protected void resetRecipe() {
        this.recipeThread.setActiveRecipe(null).setContext(null).getSemiPermanentModifiers().clear();
    }

    @Override
    public CraftingStatus getControllerStatus() {
        return this.recipeThread.getStatus();
    }

    @Override
    public void setControllerStatus(CraftingStatus status) {
        this.recipeThread.setStatus(status);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        MachineRecipeThread thread = MachineRecipeThread.deserialize(compound, this);
        if (thread != null) {
            this.recipeThread = thread;
        }
    }

    @Override
    protected void readMachineNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("parentMachine")) {
            ResourceLocation rl = new ResourceLocation(compound.func_74779_i("parentMachine"));
            this.parentMachine = MachineRegistry.getRegistry().getMachine(rl);
            if (this.parentMachine != null) {
                this.parentController = BlockController.MACHINE_CONTROLLERS.get(this.parentMachine);
            } else {
                ModularMachinery.log.info("Couldn't find machine named " + rl + " for controller at " + this.func_174877_v());
            }
        }
        super.readMachineNBT(compound);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        this.recipeThread.serialize(compound);
    }
}

