/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles;

import github.kasuminova.mmce.common.tile.MEPatternProvider;
import github.kasuminova.mmce.common.tile.base.MEItemBus;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.block.prop.ItemBusSize;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.TileInventory;
import hellfirepvp.modularmachinery.common.tiles.base.TileItemBus;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileItemOutputBus
extends TileItemBus
implements MachineComponentTile {
    public static int minWorkDelay = 5;
    public static int maxWorkDelay = 60;

    public TileItemOutputBus() {
    }

    public TileItemOutputBus(ItemBusSize type) {
        super(type);
    }

    @Override
    public void doRestrictedTick() {
        if (this.func_145831_w().field_72995_K || !this.canWork(minWorkDelay, maxWorkDelay)) {
            return;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            EnumFacing accessingSide;
            IItemHandler itemHandler;
            BlockPos offset = this.func_174877_v().func_177972_a(facing);
            TileEntity te = this.func_145831_w().func_175625_s(offset);
            if (te == null || te instanceof TileItemBus || Mods.AE2.isPresent() && (te instanceof MEItemBus || te instanceof MEPatternProvider) || (itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, accessingSide = facing.func_176734_d())) == null) continue;
            try {
                this.outputToExternal(itemHandler);
            }
            catch (Exception e) {
                ModularMachinery.log.error("Exception when insert item: ", (Throwable)e);
            }
        }
    }

    private synchronized void outputToExternal(IItemHandler external) {
        boolean successAtLeastOnce = false;
        block0: for (int externalSlotId = 0; externalSlotId < external.getSlots(); ++externalSlotId) {
            ItemStack externalStack = external.getStackInSlot(externalSlotId);
            int slotLimit = external.getSlotLimit(externalSlotId);
            if (!externalStack.func_190926_b() && externalStack.func_190916_E() >= slotLimit) continue;
            for (int internalSlotId = 0; internalSlotId < this.inventory.getSlots(); ++internalSlotId) {
                ItemStack notInserted;
                ItemStack internalStack = this.inventory.getStackInSlot(internalSlotId);
                if (internalStack.func_190926_b()) continue;
                if (externalStack.func_190926_b()) {
                    notInserted = external.insertItem(externalSlotId, internalStack, false);
                    if (notInserted.func_190916_E() == internalStack.func_190916_E()) continue block0;
                    this.inventory.setStackInSlot(internalSlotId, notInserted);
                    successAtLeastOnce = true;
                    if (!notInserted.func_190926_b()) continue;
                    continue block0;
                }
                if (!ItemUtils.matchStacks(internalStack, externalStack)) continue;
                notInserted = external.insertItem(externalSlotId, internalStack, false);
                this.inventory.setStackInSlot(internalSlotId, notInserted);
                successAtLeastOnce = true;
                if (notInserted.func_190926_b()) continue block0;
            }
        }
        if (successAtLeastOnce) {
            this.incrementSuccessCounter(maxWorkDelay, minWorkDelay);
            super.markNoUpdate();
        } else {
            this.decrementSuccessCounter();
        }
    }

    @Override
    public void markNoUpdate() {
        super.markNoUpdate();
        this.inventoryChanged = true;
    }

    @Override
    public IOInventory buildInventory(TileInventory tile, int size) {
        int[] slots = new int[size];
        for (int i = 0; i < size; ++i) {
            slots[i] = i;
        }
        return new IOInventory(tile, new int[0], slots);
    }

    @Nullable
    public MachineComponent.ItemBus provideComponent() {
        return new MachineComponent.ItemBus(IOType.OUTPUT){

            @Override
            public IOInventory getContainerProvider() {
                return TileItemOutputBus.this.inventory;
            }
        };
    }
}

