/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.registry;

import hellfirepvp.modularmachinery.common.CommonProxy;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.crafting.adapter.AdapterMinecraftFurnace;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.adapter.ic2.AdapterIC2Compressor;
import hellfirepvp.modularmachinery.common.crafting.adapter.ic2.AdapterIC2Macerator;
import hellfirepvp.modularmachinery.common.crafting.adapter.nco.AdapterNCOAlloyFurnace;
import hellfirepvp.modularmachinery.common.crafting.adapter.nco.AdapterNCOChemicalReactor;
import hellfirepvp.modularmachinery.common.crafting.adapter.nco.AdapterNCOInfuser;
import hellfirepvp.modularmachinery.common.crafting.adapter.nco.AdapterNCOMelter;
import hellfirepvp.modularmachinery.common.crafting.adapter.tc6.AdapterTC6InfusionMatrix;
import hellfirepvp.modularmachinery.common.crafting.adapter.tconstruct.AdapterSmelteryAlloyRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.tconstruct.AdapterSmelteryMeltingRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.te5.InsolatorRecipeAdapter;
import hellfirepvp.modularmachinery.common.lib.RecipeAdaptersMM;

public class RegistryRecipeAdapters {
    private RegistryRecipeAdapters() {
    }

    public static void initialize() {
        RecipeAdaptersMM.MINECRAFT_FURNACE = RegistryRecipeAdapters.registerAdapter(new AdapterMinecraftFurnace());
        if (Mods.IC2.isPresent()) {
            RegistryRecipeAdapters.registerAdapter(new AdapterIC2Compressor());
            RegistryRecipeAdapters.registerAdapter(new AdapterIC2Macerator());
        }
        if (Mods.NUCLEARCRAFT_OVERHAULED.isPresent()) {
            RegistryRecipeAdapters.registerAdapter(new AdapterNCOAlloyFurnace());
            RegistryRecipeAdapters.registerAdapter(new AdapterNCOInfuser());
            RegistryRecipeAdapters.registerAdapter(new AdapterNCOChemicalReactor());
            RegistryRecipeAdapters.registerAdapter(new AdapterNCOMelter());
        }
        if (Mods.TCONSTRUCT.isPresent()) {
            RegistryRecipeAdapters.registerAdapter(new AdapterSmelteryMeltingRecipe());
            RegistryRecipeAdapters.registerAdapter(new AdapterSmelteryAlloyRecipe());
        }
        if (Mods.TC6.isPresent()) {
            RegistryRecipeAdapters.registerAdapter(new AdapterTC6InfusionMatrix());
        }
        if (Mods.THERMAL_EXPANSION.isPresent()) {
            RegistryRecipeAdapters.registerAdapter(new InsolatorRecipeAdapter(false));
            RegistryRecipeAdapters.registerAdapter(new InsolatorRecipeAdapter(true));
        }
    }

    public static <T extends RecipeAdapter> T registerAdapter(T adapter) {
        CommonProxy.registryPrimer.register(adapter);
        return adapter;
    }
}

