/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.registry;

import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.CommonProxy;
import hellfirepvp.modularmachinery.common.item.ItemBlockCustomName;
import hellfirepvp.modularmachinery.common.item.ItemBlueprint;
import hellfirepvp.modularmachinery.common.item.ItemConstructTool;
import hellfirepvp.modularmachinery.common.item.ItemDynamicColor;
import hellfirepvp.modularmachinery.common.item.ItemModularium;
import hellfirepvp.modularmachinery.common.lib.ItemsMM;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.Item;
import youyihj.mmce.common.item.MachineProjector;

public class RegistryItems {
    public static final List<ItemDynamicColor> pendingDynamicColorItems = new LinkedList<ItemDynamicColor>();
    protected static final List<Item> ITEM_BLOCKS = new ArrayList<Item>();
    protected static final List<Item> ITEM_BLOCKS_WITH_CUSTOM_NAME = new ArrayList<Item>();
    protected static final List<Item> ITEM_MODEL_REGISTER = new ArrayList<Item>();

    public static void initialize() {
        ItemsMM.blueprint = RegistryItems.prepareRegister(new ItemBlueprint());
        ItemsMM.modularium = RegistryItems.prepareRegister(new ItemModularium());
        ItemsMM.constructTool = RegistryItems.prepareRegister(new ItemConstructTool());
        RegistryItems.prepareRegisterWithCustomName(MachineProjector.INSTANCE);
        RegistryItems.registerItemBlocks();
        RegistryItems.registerItemModels();
        RegistryItems.registerCustomNameItemBlocks();
    }

    private static <T extends Item> T prepareRegister(T item) {
        String name = item.getClass().getSimpleName().toLowerCase();
        ((Item)item.setRegistryName("modularmachinery", name)).func_77655_b("modularmachinery." + name);
        return RegistryItems.register(item);
    }

    private static <T extends Item> T prepareRegisterWithCustomName(T item) {
        return RegistryItems.register(item);
    }

    private static <T extends Item> T register(T item) {
        ITEM_MODEL_REGISTER.add(item);
        CommonProxy.registryPrimer.register(item);
        if (item instanceof ItemDynamicColor) {
            pendingDynamicColorItems.add((ItemDynamicColor)item);
        }
        return item;
    }

    private static void registerItemBlocks() {
        ITEM_BLOCKS.forEach(RegistryItems::register);
    }

    private static void registerItemModels() {
        ITEM_MODEL_REGISTER.stream().filter(item -> !(item instanceof ItemBlockCustomName)).forEach(ModularMachinery.proxy::registerItemModel);
    }

    private static void registerCustomNameItemBlocks() {
        ITEM_BLOCKS_WITH_CUSTOM_NAME.forEach(item -> {
            CommonProxy.registryPrimer.register(item);
            if (item instanceof ItemDynamicColor) {
                pendingDynamicColorItems.add((ItemDynamicColor)item);
            }
            ModularMachinery.proxy.registerItemModelWithCustomName((Item)item);
        });
    }
}

