/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.modifier;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import crafttweaker.annotations.ZenRegister;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.crafting.IntegrationTypeHelper;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.RecipeModifierBuilder;
import hellfirepvp.modularmachinery.common.lib.RegistriesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;

@ZenRegister
@ZenClass(value="mods.modularmachinery.RecipeModifier")
public class RecipeModifier {
    public static final String IO_INPUT = "input";
    public static final String IO_OUTPUT = "output";
    public static final int OPERATION_ADD = 0;
    public static final int OPERATION_MULTIPLY = 1;
    @Nullable
    protected final RequirementType<?, ?> target;
    protected final IOType ioTarget;
    protected final float modifier;
    protected final int operation;
    protected final boolean chance;

    public RecipeModifier(@Nullable RequirementType<?, ?> target, IOType ioTarget, float modifier, int operation, boolean affectsChance) {
        this.target = target;
        this.ioTarget = ioTarget;
        this.modifier = modifier;
        this.operation = operation;
        this.chance = affectsChance;
    }

    public static void applyValueToApplier(ModifierApplier applier, RecipeModifier mod) {
        if (mod.operation == 0) {
            IOType ioTarget = mod.ioTarget;
            if (ioTarget == null || ioTarget == IOType.INPUT) {
                applier.inputAdd += mod.modifier;
            } else {
                applier.outputAdd += mod.modifier;
            }
        } else if (mod.operation == 1) {
            IOType ioTarget = mod.ioTarget;
            if (ioTarget == null || ioTarget == IOType.INPUT) {
                applier.inputMul *= mod.modifier;
            } else {
                applier.outputMul *= mod.modifier;
            }
        } else {
            throw new IllegalArgumentException("Unknown modifier operation: " + mod.operation);
        }
    }

    public static RecipeModifier deserialize(NBTTagCompound compound) {
        if (compound.func_74764_b("target") && compound.func_74764_b("ioTarget") && compound.func_74764_b("operation") && compound.func_74764_b("value") && compound.func_74764_b("chance")) {
            return RecipeModifierBuilder.newBuilder().setRequirementType(compound.func_74779_i("target")).setIOType(compound.func_74771_c("ioTarget") == 0 ? IO_INPUT : IO_OUTPUT).setOperation(compound.func_74771_c("operation")).setValue(compound.func_74760_g("value")).isAffectChance(compound.func_74767_n("chance")).build();
        }
        return null;
    }

    public static double applyModifiers(RecipeCraftingContext context, ComponentRequirement<?, ?> in, double value, boolean isChance) {
        return RecipeModifier.applyModifiers(context, in.requirementType, in.getActionType(), value, isChance);
    }

    public static double applyModifiers(RecipeCraftingContext context, RequirementType<?, ?> target, IOType ioType, double value, boolean isChance) {
        return context.getModifierApplier(target, isChance).apply(value, ioType);
    }

    public static float applyModifiers(RecipeCraftingContext context, ComponentRequirement<?, ?> in, float value, boolean isChance) {
        return RecipeModifier.applyModifiers(context, in.requirementType, in.getActionType(), value, isChance);
    }

    public static float applyModifiers(RecipeCraftingContext context, RequirementType<?, ?> target, IOType ioType, float value, boolean isChance) {
        return (float)context.getModifierApplier(target, isChance).apply(value, ioType);
    }

    public static double applyModifiers(Collection<RecipeModifier> modifiers, ComponentRequirement<?, ?> in, double value, boolean isChance) {
        return RecipeModifier.applyModifiers(modifiers, in.requirementType, in.getActionType(), value, isChance);
    }

    public static float applyModifiers(Collection<RecipeModifier> modifiers, ComponentRequirement<?, ?> in, float value, boolean isChance) {
        return RecipeModifier.applyModifiers(modifiers, in.requirementType, in.getActionType(), value, isChance);
    }

    public static float applyModifiers(Collection<RecipeModifier> modifiers, RequirementType<?, ?> target, IOType ioType, float value, boolean isChance) {
        return (float)RecipeModifier.applyModifiers(modifiers, target, ioType, (double)value, isChance);
    }

    public static double applyModifiers(Collection<RecipeModifier> modifiers, RequirementType<?, ?> target, IOType ioType, double value, boolean isChance) {
        if (modifiers.isEmpty()) {
            return value;
        }
        float add = 0.0f;
        float mul = 1.0f;
        block4: for (RecipeModifier mod : modifiers) {
            if (mod.target == null || !((Object)mod.target).equals(target) || ioType != null && mod.ioTarget != ioType || mod.affectsChance() != isChance) continue;
            switch (mod.operation) {
                case 0: {
                    add += mod.modifier;
                    continue block4;
                }
                case 1: {
                    mul *= mod.modifier;
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unknown modifier operation: " + mod.operation);
        }
        return (value + (double)add) * (double)mul;
    }

    public NBTTagCompound serialize() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("target", this.target == null || this.target.getRegistryName() == null ? "" : this.target.getRegistryName().toString());
        compound.func_74774_a("ioTarget", (byte)(this.ioTarget != IOType.INPUT ? 1 : 0));
        compound.func_74774_a("operation", (byte)this.operation);
        compound.func_74776_a("value", this.modifier);
        compound.func_74757_a("chance", this.chance);
        return compound;
    }

    @Nullable
    public RequirementType<?, ?> getTarget() {
        return this.target;
    }

    public IOType getIOTarget() {
        return this.ioTarget;
    }

    public float getModifier() {
        return this.modifier;
    }

    public boolean affectsChance() {
        return this.chance;
    }

    public int getOperation() {
        return this.operation;
    }

    public RecipeModifier multiply(float value) {
        return new RecipeModifier(this.target, this.ioTarget, this.modifier * value, this.operation, this.chance);
    }

    public RecipeModifier add(float value) {
        return new RecipeModifier(this.target, this.ioTarget, this.modifier + value, this.operation, this.chance);
    }

    public static class ModifierApplier {
        public static final ModifierApplier DEFAULT_APPLIER = new ModifierApplier();
        public float inputAdd = 0.0f;
        public float inputMul = 1.0f;
        public float outputAdd = 0.0f;
        public float outputMul = 1.0f;

        public double apply(double value, IOType ioType) {
            return ioType == null || ioType == IOType.INPUT ? (value + (double)this.inputAdd) * (double)this.inputMul : (value + (double)this.outputAdd) * (double)this.outputMul;
        }

        public boolean isDefault() {
            return this.inputAdd == 0.0f && this.inputMul == 1.0f && this.outputAdd == 0.0f && this.outputMul == 1.0f;
        }
    }

    public static class Deserializer
    implements JsonDeserializer<RecipeModifier> {
        public RecipeModifier deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject part = json.getAsJsonObject();
            if (!(part.has("io") && part.get("io").isJsonPrimitive() && part.getAsJsonPrimitive("io").isString())) {
                throw new JsonParseException("'io' string-tag not found when deserializing recipemodifier!");
            }
            String ioTarget = part.getAsJsonPrimitive("io").getAsString();
            IOType ioType = IOType.getByString(ioTarget);
            if (ioType == null) {
                throw new JsonParseException("Unknown machine iotype: " + ioTarget);
            }
            if (!(part.has("target") && part.get("target").isJsonPrimitive() && part.getAsJsonPrimitive("target").isString())) {
                throw new JsonParseException("'target' string-tag not found when deserializing recipemodifier!");
            }
            String targetStr = part.getAsJsonPrimitive("target").getAsString();
            RequirementType<?, ?> target = (RequirementType<?, ?>)RegistriesMM.REQUIREMENT_TYPE_REGISTRY.getValue(new ResourceLocation(targetStr));
            if (target == null && (target = IntegrationTypeHelper.searchRequirementType(targetStr)) != null) {
                ModularMachinery.log.info("[Modular Machinery]: Deprecated requirement name '" + targetStr + "'! Consider using " + target.getRegistryName().toString());
            }
            if (!(part.has("multiplier") && part.get("multiplier").isJsonPrimitive() && part.getAsJsonPrimitive("multiplier").isNumber())) {
                throw new JsonParseException("'multiplier' float-tag not found when deserializing recipemodifier!");
            }
            float multiplier = part.getAsJsonPrimitive("multiplier").getAsFloat();
            if (!(part.has("operation") && part.get("operation").isJsonPrimitive() && part.getAsJsonPrimitive("operation").isNumber())) {
                throw new JsonParseException("'operation' int-tag not found when deserializing recipemodifier!");
            }
            int operation = part.getAsJsonPrimitive("operation").getAsInt();
            if (operation < 0 || operation > 1) {
                throw new JsonParseException("There are currently only operation 0 and 1 available (add and multiply)! Found: " + operation);
            }
            boolean affectsChance = false;
            if (part.has("affectChance")) {
                if (!part.get("affectChance").isJsonPrimitive() || !part.getAsJsonPrimitive("affectChance").isBoolean()) {
                    throw new JsonParseException("'affectChance', if defined, needs to be either true or false!");
                }
                affectsChance = part.getAsJsonPrimitive("affectChance").getAsBoolean();
            }
            return new RecipeModifier(target, ioType, multiplier, operation, affectsChance);
        }
    }
}

