/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.machine.factory;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.concurrent.FactoryRecipeSearchTask;
import github.kasuminova.mmce.common.util.concurrent.Action;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.RecipeThread;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.TileFactoryController;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.FactoryRecipeThread")
public class FactoryRecipeThread
extends RecipeThread {
    public static final int IDLE_TIME_OUT = 200;
    public static final List<Action> WAIT_FOR_ADD = new ArrayList<Action>();
    private final TreeSet<MachineRecipe> recipeSet = new TreeSet();
    public int idleTime = 0;
    private TileFactoryController factory;
    private boolean isCoreThread;
    private String threadName;

    public FactoryRecipeThread(TileFactoryController factory) {
        this(factory, false, "", Collections.emptySet(), Collections.emptyMap());
    }

    public FactoryRecipeThread(TileFactoryController factory, boolean isCoreThread, String threadName, Set<MachineRecipe> recipeSet, Map<String, RecipeModifier> permanentModifiers) {
        super(factory);
        this.factory = factory;
        this.isCoreThread = isCoreThread;
        this.threadName = threadName;
        this.recipeSet.addAll(recipeSet);
        this.permanentModifiers.putAll(permanentModifiers);
    }

    @ZenMethod
    public static FactoryRecipeThread createCoreThread(String threadName) {
        return new FactoryRecipeThread(null, true, threadName, Collections.emptySet(), Collections.emptyMap());
    }

    public static FactoryRecipeThread deserialize(NBTTagCompound tag, TileFactoryController factory) {
        if (!tag.func_74764_b("status")) {
            return null;
        }
        HashMap<String, RecipeModifier> permanentModifiers = new HashMap<String, RecipeModifier>();
        if (tag.func_150297_b("permanentModifiers", 9)) {
            NBTTagList tagList = tag.func_150295_c("permanentModifiers", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound modifierTag = tagList.func_150305_b(i);
                permanentModifiers.put(modifierTag.func_74779_i("key"), RecipeModifier.deserialize(modifierTag.func_74775_l("modifier")));
            }
        }
        HashMap<String, RecipeModifier> semiPermanentModifiers = new HashMap<String, RecipeModifier>();
        if (tag.func_150297_b("semiPermanentModifiers", 9)) {
            NBTTagList tagList = tag.func_150295_c("semiPermanentModifiers", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound modifierTag = tagList.func_150305_b(i);
                semiPermanentModifiers.put(modifierTag.func_74779_i("key"), RecipeModifier.deserialize(modifierTag.func_74775_l("modifier")));
            }
        }
        ActiveMachineRecipe activeRecipe = FactoryRecipeThread.deserializeActiveRecipe(tag, factory);
        if (factory.getFoundMachine() != null && activeRecipe != null && !activeRecipe.getRecipe().getOwningMachineIdentifier().equals((Object)factory.getFoundMachine().getRegistryName())) {
            activeRecipe = null;
        }
        FactoryRecipeThread thread = (FactoryRecipeThread)new FactoryRecipeThread(factory).setActiveRecipe(activeRecipe).setStatus(CraftingStatus.deserialize(tag.func_74775_l("status")));
        thread.permanentModifiers.putAll(permanentModifiers);
        thread.semiPermanentModifiers.putAll(semiPermanentModifiers);
        if (tag.func_74764_b("coreThreadName")) {
            Map<String, FactoryRecipeThread> threads = factory.getFoundMachine().getCoreThreadPreset();
            FactoryRecipeThread coreThread = threads.get(tag.func_74779_i("coreThreadName"));
            if (coreThread == null) {
                return thread;
            }
            return coreThread.copyDataToAnother(factory, thread);
        }
        return thread;
    }

    @Override
    public CraftingStatus onTick() {
        CraftingStatus status = super.onTick();
        if (status.isCrafting()) {
            this.idleTime = 0;
        }
        return status;
    }

    @Override
    public void fireStartedEvent() {
        this.factory.onThreadRecipeStart(this);
    }

    @Override
    public void fireFinishedEvent() {
        this.factory.onThreadRecipeFinished(this);
    }

    @Override
    public void tryRestartRecipe() {
        this.activeRecipe.reset();
        this.activeRecipe.setMaxParallelism(this.factory.getAvailableParallelism());
        RecipeCraftingContext context = this.getContext().reset();
        this.flushContextModifier();
        RecipeCraftingContext.CraftingCheckResult result = this.factory.onRestartCheck(context);
        if (result.isSuccess()) {
            this.factory.onThreadRecipeStart(this);
        } else {
            this.activeRecipe = null;
            this.setContext(null);
            this.status = CraftingStatus.failure(result.getFirstErrorMessage(""));
            if (this.isCoreThread) {
                this.createRecipeSearchTask();
            }
        }
    }

    @Override
    protected void createRecipeSearchTask() {
        TileFactoryController factory = this.factory;
        Iterable<MachineRecipe> recipeSet = this.recipeSet.isEmpty() ? RecipeRegistry.getRecipesFor(factory.getFoundMachine()) : this.recipeSet;
        this.searchTask = new FactoryRecipeSearchTask(factory, factory.getFoundMachine(), factory.getAvailableParallelism(), recipeSet, this, factory.getActiveRecipeList());
        factory.getWaitToExecute().add(this.searchTask);
    }

    public NBTTagCompound serialize() {
        NBTTagList tagList;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("status", (NBTBase)this.status.serialize());
        if (this.activeRecipe != null && this.activeRecipe.getRecipe() != null) {
            tag.func_74782_a("activeRecipe", (NBTBase)this.activeRecipe.serialize());
        }
        if (this.isCoreThread) {
            tag.func_74778_a("coreThreadName", this.threadName);
        }
        if (!this.permanentModifiers.isEmpty()) {
            tagList = new NBTTagList();
            this.permanentModifiers.forEach((key, modifier) -> {
                if (key != null && modifier != null) {
                    NBTTagCompound modifierTag = new NBTTagCompound();
                    modifierTag.func_74778_a("key", key);
                    modifierTag.func_74782_a("modifier", (NBTBase)modifier.serialize());
                    tagList.func_74742_a((NBTBase)modifierTag);
                }
            });
            tag.func_74782_a("permanentModifiers", (NBTBase)tagList);
        }
        if (!this.semiPermanentModifiers.isEmpty()) {
            tagList = new NBTTagList();
            this.semiPermanentModifiers.forEach((key, modifier) -> {
                if (key != null && modifier != null) {
                    NBTTagCompound modifierTag = new NBTTagCompound();
                    modifierTag.func_74778_a("key", key);
                    modifierTag.func_74782_a("modifier", (NBTBase)modifier.serialize());
                    tagList.func_74742_a((NBTBase)modifierTag);
                }
            });
            tag.func_74782_a("semiPermanentModifiers", (NBTBase)tagList);
        }
        return tag;
    }

    public TileFactoryController getFactory() {
        return this.factory;
    }

    @ZenGetter(value="isWorking")
    public boolean isWorking() {
        return this.status.getStatus() == TileMultiblockMachineController.Type.CRAFTING;
    }

    @ZenGetter(value="isIdle")
    public boolean isIdle() {
        return this.activeRecipe == null && this.getContext() == null;
    }

    @ZenGetter(value="isCoreThread")
    public boolean isCoreThread() {
        return this.isCoreThread;
    }

    @ZenGetter(value="threadName")
    public String getThreadName() {
        return this.threadName;
    }

    @ZenMethod
    public FactoryRecipeThread addRecipe(String recipeName) {
        if (this.factory != null) {
            MachineRecipe recipe = RecipeRegistry.getRecipe(new ResourceLocation("modularmachinery", recipeName));
            if (recipe != null) {
                this.addRecipe(recipe);
            } else {
                CraftTweakerAPI.logError((String)("[ModularMachinery] Cloud not found recipe by name " + recipeName + "!"));
            }
        } else {
            WAIT_FOR_ADD.add(() -> {
                MachineRecipe recipe = RecipeRegistry.getRecipe(new ResourceLocation("modularmachinery", recipeName));
                if (recipe != null) {
                    this.addRecipe(recipe);
                } else {
                    CraftTweakerAPI.logError((String)("[ModularMachinery] Cloud not found recipe by name " + recipeName + "!"));
                }
            });
        }
        return this;
    }

    public FactoryRecipeThread addRecipe(MachineRecipe recipe) {
        this.recipeSet.add(recipe);
        return this;
    }

    public TreeSet<MachineRecipe> getRecipeSet() {
        return this.recipeSet;
    }

    public FactoryRecipeThread copyCoreThread(TileFactoryController factory) {
        return new FactoryRecipeThread(factory, true, this.threadName, this.recipeSet, this.permanentModifiers);
    }

    public FactoryRecipeThread copyDataToAnother(TileFactoryController factory, FactoryRecipeThread another) {
        another.factory = factory;
        another.isCoreThread = this.isCoreThread;
        another.threadName = this.threadName;
        another.recipeSet.addAll(this.recipeSet);
        another.permanentModifiers.putAll(this.permanentModifiers);
        return another;
    }
}

