/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.machine;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.concurrent.RecipeCraftingContextPool;
import github.kasuminova.mmce.common.event.machine.MachineEvent;
import github.kasuminova.mmce.common.util.BlockPos2ValueMap;
import github.kasuminova.mmce.common.util.DynamicPattern;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentSelectorTag;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.AbstractMachine;
import hellfirepvp.modularmachinery.common.machine.DynamicMachinePreDeserializer;
import hellfirepvp.modularmachinery.common.machine.MachineLoader;
import hellfirepvp.modularmachinery.common.machine.TaggedPositionBlockArray;
import hellfirepvp.modularmachinery.common.machine.factory.FactoryRecipeThread;
import hellfirepvp.modularmachinery.common.modifier.MultiBlockModifierReplacement;
import hellfirepvp.modularmachinery.common.modifier.SingleBlockModifierReplacement;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.IBlockStateDescriptor;
import hellfirepvp.modularmachinery.common.util.SmartInterfaceType;
import hellfirepvp.modularmachinery.common.util.nbt.NBTJsonDeserializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class DynamicMachine
extends AbstractMachine {
    private final Map<BlockPos, List<SingleBlockModifierReplacement>> modifiers = new BlockPos2ValueMap<List<SingleBlockModifierReplacement>>();
    private final List<MultiBlockModifierReplacement> multiBlockModifiers = new ArrayList<MultiBlockModifierReplacement>();
    private final Map<Class<?>, List<IEventHandler<MachineEvent>>> machineEventHandlers = new HashMap();
    private final TaggedPositionBlockArray pattern = new TaggedPositionBlockArray();
    private final Map<String, DynamicPattern> dynamicPatterns = new HashMap<String, DynamicPattern>();
    private final Map<String, SmartInterfaceType> smartInterfaces = new HashMap<String, SmartInterfaceType>();
    private final Map<String, FactoryRecipeThread> coreThreadPreset = new LinkedHashMap<String, FactoryRecipeThread>();
    private boolean hideComponentsWhenFormed = false;
    private AxisAlignedBB controllerBoundingBox = Block.field_185505_j;

    public DynamicMachine(String registryName) {
        super(registryName);
    }

    public Map<String, DynamicPattern> getDynamicPatterns() {
        return this.dynamicPatterns;
    }

    public DynamicPattern getDynamicPatternByName(String name) {
        return this.dynamicPatterns.get(name);
    }

    public void addDynamicPattern(String name, DynamicPattern pattern) {
        this.dynamicPatterns.put(name, pattern);
    }

    public void addCoreThread(FactoryRecipeThread thread) {
        this.coreThreadPreset.put(thread.getThreadName(), thread);
    }

    public Map<String, FactoryRecipeThread> getCoreThreadPreset() {
        return this.coreThreadPreset;
    }

    public boolean hasSmartInterfaceType(String type) {
        return this.smartInterfaces.containsKey(type);
    }

    public Map<String, SmartInterfaceType> getSmartInterfaceTypes() {
        return this.smartInterfaces;
    }

    public SmartInterfaceType getSmartInterfaceType(String type) {
        return this.smartInterfaces.get(type);
    }

    public void addSmartInterfaceType(SmartInterfaceType type) {
        this.smartInterfaces.put(type.getType(), type);
    }

    public Optional<SmartInterfaceType> getFirstSmartInterfaceType() {
        return this.smartInterfaces.values().stream().sorted().findFirst();
    }

    public boolean smartInterfaceTypesIsEmpty() {
        return this.smartInterfaces.isEmpty();
    }

    public Map<String, SmartInterfaceType> getFilteredType(Collection<String> ignoredTypes) {
        HashMap<String, SmartInterfaceType> filtered = new HashMap<String, SmartInterfaceType>();
        this.smartInterfaces.forEach((type, data) -> {
            if (!ignoredTypes.contains(type)) {
                filtered.put((String)type, (SmartInterfaceType)data);
            }
        });
        return filtered;
    }

    public <H extends MachineEvent> void addMachineEventHandler(Class<H> hClass, IEventHandler<H> handler) {
        this.machineEventHandlers.putIfAbsent(hClass, new ArrayList());
        this.machineEventHandlers.get(hClass).add(handler);
    }

    @Nullable
    public List<IEventHandler<MachineEvent>> getMachineEventHandlers(Class<?> handlerClass) {
        return this.machineEventHandlers.get(handlerClass);
    }

    public Map<Class<?>, List<IEventHandler<MachineEvent>>> getMachineEventHandlers() {
        return this.machineEventHandlers;
    }

    public TaggedPositionBlockArray getPattern() {
        return this.pattern;
    }

    public Map<BlockPos, List<SingleBlockModifierReplacement>> getModifiers() {
        return this.modifiers;
    }

    public List<MultiBlockModifierReplacement> getMultiBlockModifiers() {
        return this.multiBlockModifiers;
    }

    public boolean isHideComponentsWhenFormed() {
        return this.hideComponentsWhenFormed;
    }

    public void setHideComponentsWhenFormed(boolean hideComponentsWhenFormed) {
        this.hideComponentsWhenFormed = hideComponentsWhenFormed;
    }

    @Nonnull
    public ModifierReplacementMap getModifiersAsMatchingReplacements() {
        ModifierReplacementMap infoMap = new ModifierReplacementMap();
        for (BlockPos pos : this.modifiers.keySet()) {
            List infoList = infoMap.computeIfAbsent(pos, v -> new ArrayList());
            List<SingleBlockModifierReplacement> replacements = this.modifiers.get(pos);
            for (SingleBlockModifierReplacement replacement : replacements) {
                infoList.add(replacement.getBlockInformation());
            }
        }
        return infoMap;
    }

    @Nonnull
    public Iterable<MachineRecipe> getAvailableRecipes() {
        return RecipeRegistry.getRecipesFor(this);
    }

    public RecipeCraftingContext createContext(ActiveMachineRecipe recipe, TileMultiblockMachineController ctrl) {
        if (!recipe.getRecipe().getOwningMachineIdentifier().equals((Object)this.registryName)) {
            throw new IllegalArgumentException("Tried to create context for a recipe that doesn't belong to the referenced machine!");
        }
        return RecipeCraftingContextPool.borrowCtx(recipe, ctrl);
    }

    public AxisAlignedBB getControllerBoundingBox() {
        return this.controllerBoundingBox;
    }

    public void setControllerBoundingBox(AxisAlignedBB controllerBoundingBox) {
        this.controllerBoundingBox = controllerBoundingBox;
    }

    public void mergeFrom(DynamicMachine another) {
        this.smartInterfaces.clear();
        this.smartInterfaces.putAll(another.smartInterfaces);
        this.modifiers.clear();
        this.modifiers.putAll(another.modifiers);
        this.pattern.overwrite(another.pattern);
        this.machineEventHandlers.clear();
        this.machineEventHandlers.putAll(another.machineEventHandlers);
        this.dynamicPatterns.clear();
        this.dynamicPatterns.putAll(another.dynamicPatterns);
        this.hideComponentsWhenFormed = another.hideComponentsWhenFormed;
        this.controllerBoundingBox = another.controllerBoundingBox;
    }

    public static class ModifierReplacementMap
    extends HashMap<BlockPos, List<BlockArray.BlockInformation>> {
        public ModifierReplacementMap rotateYCCW() {
            ModifierReplacementMap map = new ModifierReplacementMap();
            for (BlockPos pos : this.keySet()) {
                List infoList = (List)this.get(pos);
                ArrayList<BlockArray.BlockInformation> copyRotated = new ArrayList<BlockArray.BlockInformation>(infoList.size());
                for (BlockArray.BlockInformation info : infoList) {
                    copyRotated.add(info.copyRotateYCCW());
                }
                map.put(new BlockPos(pos.func_177952_p(), pos.func_177956_o(), -pos.func_177958_n()), copyRotated);
            }
            return map;
        }
    }

    public static class MachineDeserializer
    implements JsonDeserializer<DynamicMachine> {
        private static List<BlockPos> buildPermutations(List<Integer> avX, List<Integer> avY, List<Integer> avZ) {
            ArrayList<BlockPos> out = new ArrayList<BlockPos>(avX.size() * avY.size() * avZ.size());
            for (int x : avX) {
                for (int y : avY) {
                    for (int z : avZ) {
                        out.add(new BlockPos(x, y, z));
                    }
                }
            }
            return out;
        }

        private static void addModifierWithPattern(DynamicMachine machine, SingleBlockModifierReplacement mod, JsonObject part) throws JsonParseException {
            ArrayList<Integer> avX = new ArrayList<Integer>();
            ArrayList<Integer> avY = new ArrayList<Integer>();
            ArrayList<Integer> avZ = new ArrayList<Integer>();
            MachineDeserializer.addCoordinates("x", part, avX);
            MachineDeserializer.addCoordinates("y", part, avY);
            MachineDeserializer.addCoordinates("z", part, avZ);
            for (BlockPos permutation : MachineDeserializer.buildPermutations(avX, avY, avZ)) {
                if (permutation.func_177958_n() == 0 && permutation.func_177956_o() == 0 && permutation.func_177952_p() == 0) continue;
                machine.modifiers.putIfAbsent(permutation, Lists.newArrayList());
                ((List)machine.modifiers.get(permutation)).add(mod.setPos(permutation));
            }
        }

        private static void addDescriptorWithPattern(TaggedPositionBlockArray pattern, BlockArray.BlockInformation information, JsonObject part) throws JsonParseException {
            ArrayList<Integer> avX = new ArrayList<Integer>();
            ArrayList<Integer> avY = new ArrayList<Integer>();
            ArrayList<Integer> avZ = new ArrayList<Integer>();
            MachineDeserializer.addCoordinates("x", part, avX);
            MachineDeserializer.addCoordinates("y", part, avY);
            MachineDeserializer.addCoordinates("z", part, avZ);
            String tag = null;
            if (part.has("selector-tag")) {
                JsonElement strTag = part.get("selector-tag");
                if (!strTag.isJsonPrimitive()) {
                    throw new JsonParseException("The 'selector-tag' in an element must be a string!");
                }
                tag = strTag.getAsString();
            }
            ComponentSelectorTag selector = tag != null && !tag.isEmpty() ? new ComponentSelectorTag(tag) : null;
            for (BlockPos permutation : MachineDeserializer.buildPermutations(avX, avY, avZ)) {
                pattern.addBlock(permutation, information);
                if (tag == null || tag.isEmpty()) continue;
                pattern.setTag(permutation, selector);
            }
        }

        private static void addCoordinates(String key, JsonObject part, List<Integer> out) throws JsonParseException {
            if (!part.has(key)) {
                out.add(0);
                return;
            }
            JsonElement coordinateElement = part.get(key);
            if (coordinateElement.isJsonPrimitive() && coordinateElement.getAsJsonPrimitive().isNumber()) {
                out.add(coordinateElement.getAsInt());
            } else if (coordinateElement.isJsonArray() && coordinateElement.getAsJsonArray().size() > 0) {
                for (JsonElement element : coordinateElement.getAsJsonArray()) {
                    if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
                        out.add(element.getAsInt());
                        continue;
                    }
                    throw new JsonParseException("Expected only numbers in JsonArray " + coordinateElement + " but found " + element);
                }
            }
        }

        private static void addDynamicPatterns(JsonObject root, DynamicMachine machine) {
            JsonArray patterns = JsonUtils.func_151213_a((JsonObject)root, (String)"dynamic-patterns", (JsonArray)new JsonArray());
            if (patterns.size() == 0) {
                throw new JsonParseException("Empty 'dynamic-patterns'!");
            }
            HashMap<String, DynamicPattern> dynamicPatterns = new HashMap<String, DynamicPattern>();
            for (int i = 0; i < patterns.size(); ++i) {
                JsonElement element = patterns.get(i);
                if (!element.isJsonObject()) {
                    throw new JsonParseException("A pattern of 'dynamic-patterns' is not a compound object!");
                }
                JsonObject jsonPattern = element.getAsJsonObject();
                DynamicPattern pattern = new DynamicPattern(MachineDeserializer.getName(jsonPattern));
                MachineDeserializer.setFaces(jsonPattern, pattern);
                MachineDeserializer.setMaxSize(jsonPattern, pattern, element);
                MachineDeserializer.addDynamicPatternParts(jsonPattern, "parts", pattern.getPattern());
                if (jsonPattern.has("parts-end")) {
                    pattern.setPatternEnd(new TaggedPositionBlockArray());
                    MachineDeserializer.addDynamicPatternParts(jsonPattern, "parts-end", pattern.getPatternEnd());
                }
                if (jsonPattern.has("minSize")) {
                    MachineDeserializer.setMinSize(jsonPattern, pattern, element);
                }
                if (jsonPattern.has("structure-size-offset-start")) {
                    pattern.setStructureSizeOffsetStart(MachineDeserializer.getStructureSizeOffset(jsonPattern, "structure-size-offset-start"));
                }
                if (jsonPattern.has("structure-size-offset")) {
                    pattern.setStructureSizeOffset(MachineDeserializer.getStructureSizeOffset(jsonPattern, "structure-size-offset"));
                }
                dynamicPatterns.put(pattern.getName(), pattern);
            }
            machine.getDynamicPatterns().putAll(dynamicPatterns);
        }

        private static String getName(JsonObject jsonPattern) {
            if (!jsonPattern.has("name")) {
                throw new JsonParseException("Pattern must have a 'name'!");
            }
            JsonElement element = jsonPattern.get("name");
            if (!element.isJsonPrimitive()) {
                throw new JsonParseException("Expected only string in JsonPrimitive, but found " + element);
            }
            return element.getAsString();
        }

        public static boolean getHideComponentsWhenFormed(JsonObject root) throws JsonParseException {
            JsonElement elementBlueprint = root.get("hide-components-when-formed");
            if (!elementBlueprint.isJsonPrimitive() || !elementBlueprint.getAsJsonPrimitive().isBoolean()) {
                throw new JsonParseException("'hide-components-when-formed' has to be either 'true' or 'false'!");
            }
            return elementBlueprint.getAsJsonPrimitive().getAsBoolean();
        }

        private static void addDynamicPatternParts(JsonObject jsonPattern, String name, TaggedPositionBlockArray pattern) {
            if (!jsonPattern.has(name)) {
                throw new JsonParseException("Empty/Missing '" + name + "'!");
            }
            JsonArray parts = JsonUtils.func_151213_a((JsonObject)jsonPattern, (String)name, (JsonArray)new JsonArray());
            if (parts.size() == 0) {
                throw new JsonParseException("Empty/Missing 'parts'!");
            }
            MachineDeserializer.addParts(parts, pattern);
        }

        private static void setFaces(JsonObject jsonPattern, DynamicPattern pattern) {
            if (!jsonPattern.has("faces")) {
                throw new JsonParseException("Pattern is missing string array 'faces'!");
            }
            JsonElement element = jsonPattern.get("faces");
            if (!element.isJsonArray()) {
                throw new JsonParseException("'faces' must to be string array!");
            }
            JsonArray jsonArray = element.getAsJsonArray();
            EnumSet<EnumFacing> faces = EnumSet.noneOf(EnumFacing.class);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonElement faceElement = jsonArray.get(i);
                if (!faceElement.isJsonPrimitive()) {
                    throw new JsonParseException("Expected only string in JsonPrimitive, but found " + element);
                }
                String face = faceElement.getAsString();
                try {
                    faces.add(EnumFacing.valueOf((String)face.toUpperCase()));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new JsonParseException("Invalid facing '" + face + "'! Expect: 'up', 'down', 'north', 'south', 'west', 'east' !");
                }
            }
            if (faces.isEmpty()) {
                throw new JsonParseException("faces is empty!");
            }
            pattern.addFaces(faces);
        }

        private static BlockPos getStructureSizeOffset(JsonObject pattern, String name) {
            JsonElement element = pattern.get(name);
            if (!element.isJsonObject()) {
                throw new JsonParseException("Elements of '" + name + "' have to be objects!");
            }
            JsonObject structureSizeOffsetStart = element.getAsJsonObject();
            LinkedList<Integer> x = new LinkedList<Integer>();
            LinkedList<Integer> y = new LinkedList<Integer>();
            LinkedList<Integer> z = new LinkedList<Integer>();
            MachineDeserializer.addCoordinates("x", structureSizeOffsetStart, x);
            MachineDeserializer.addCoordinates("y", structureSizeOffsetStart, y);
            MachineDeserializer.addCoordinates("z", structureSizeOffsetStart, z);
            return new BlockPos(x.getFirst().intValue(), y.getFirst().intValue(), z.getFirst().intValue());
        }

        private static void setMinSize(JsonObject jsonPattern, DynamicPattern pattern, JsonElement element) {
            JsonElement e = jsonPattern.get("minSize");
            if (!e.isJsonPrimitive() || !e.getAsJsonPrimitive().isNumber()) {
                throw new JsonParseException("Expected only numbers in JsonPrimitive 'minSize' but found " + element);
            }
            pattern.setMinSize(e.getAsInt());
        }

        private static void setMaxSize(JsonObject jsonPattern, DynamicPattern pattern, JsonElement element) {
            int maxSize;
            if (!jsonPattern.has("maxSize")) {
                throw new JsonParseException("Pattern must be has 'maxSize'!");
            }
            JsonElement e = jsonPattern.get("maxSize");
            if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isNumber()) {
                maxSize = e.getAsInt();
                if (pattern.getMinSize() > maxSize) {
                    throw new JsonParseException("The 'minSize' of the pattern is bigger than the 'maxSize'!");
                }
            } else {
                throw new JsonParseException("Expected only numbers in JsonPrimitive 'maxSize' but found " + element);
            }
            pattern.setMaxSize(maxSize);
        }

        private static void addModifiers(JsonDeserializationContext context, JsonObject root, DynamicMachine machine) {
            JsonElement partModifiers = root.get("modifiers");
            if (!partModifiers.isJsonArray()) {
                throw new JsonParseException("'modifiers' has to be an array of modifiers!");
            }
            JsonArray modifiersArray = partModifiers.getAsJsonArray();
            for (int j = 0; j < modifiersArray.size(); ++j) {
                JsonElement modifier = modifiersArray.get(j);
                if (!modifier.isJsonObject()) {
                    throw new JsonParseException("Elements of 'modifiers' have to be objects!");
                }
                MachineDeserializer.addModifierWithPattern(machine, (SingleBlockModifierReplacement)context.deserialize((JsonElement)modifier.getAsJsonObject(), SingleBlockModifierReplacement.class), modifier.getAsJsonObject());
            }
        }

        private static void addParts(JsonArray parts, TaggedPositionBlockArray pattern) {
            for (int i = 0; i < parts.size(); ++i) {
                String jsonStr;
                JsonElement je;
                JsonElement element = parts.get(i);
                if (!element.isJsonObject()) {
                    throw new JsonParseException("A part of 'parts' is not a compound object!");
                }
                JsonObject part = element.getAsJsonObject();
                NBTTagCompound matchNBT = null;
                NBTTagCompound previewNBT = null;
                if (part.has("nbt")) {
                    je = part.get("nbt");
                    if (!je.isJsonObject()) {
                        throw new JsonParseException("The ComponentType 'nbt' expects a json compound that defines the NBT tag to match the tileentity's nbt against!");
                    }
                    jsonStr = je.toString();
                    try {
                        matchNBT = NBTJsonDeserializer.deserialize(jsonStr);
                    }
                    catch (NBTException exc) {
                        throw new JsonParseException("Error trying to parse NBTTag! Rethrowing exception...", (Throwable)exc);
                    }
                }
                if (part.has("preview-nbt")) {
                    je = part.get("preview-nbt");
                    if (!je.isJsonObject()) {
                        throw new JsonParseException("The ComponentType 'preview-nbt' expects a json compound that defines the NBT tag to preview the tileentity's nbt against!");
                    }
                    jsonStr = je.toString();
                    try {
                        previewNBT = NBTJsonDeserializer.deserialize(jsonStr);
                    }
                    catch (NBTException exc) {
                        throw new JsonParseException("Error trying to parse NBTTag! Rethrowing exception...", (Throwable)exc);
                    }
                }
                if (!part.has("elements")) {
                    throw new JsonParseException("Part contained empty element!");
                }
                JsonElement partElement = part.get("elements");
                if (partElement.isJsonPrimitive() && partElement.getAsJsonPrimitive().isString()) {
                    String strDesc = partElement.getAsString();
                    BlockArray.BlockInformation descr = MachineLoader.VARIABLE_CONTEXT.get(strDesc);
                    descr = descr == null ? new BlockArray.BlockInformation(Lists.newArrayList((Object[])new IBlockStateDescriptor[]{BlockArray.BlockInformation.getDescriptor(partElement.getAsString())})) : descr.copy();
                    if (matchNBT != null) {
                        descr.setMatchingTag(matchNBT);
                    }
                    if (previewNBT != null) {
                        descr.setPreviewTag(previewNBT);
                    }
                    MachineDeserializer.addDescriptorWithPattern(pattern, descr, part);
                    continue;
                }
                if (partElement.isJsonArray()) {
                    JsonArray elementArray = partElement.getAsJsonArray();
                    ArrayList descriptors = Lists.newArrayList();
                    for (int xx = 0; xx < elementArray.size(); ++xx) {
                        JsonElement p = elementArray.get(xx);
                        if (!p.isJsonPrimitive() || !p.getAsJsonPrimitive().isString()) {
                            throw new JsonParseException("Part elements of 'elements' have to be blockstate descriptions!");
                        }
                        String prim = p.getAsString();
                        BlockArray.BlockInformation descr = MachineLoader.VARIABLE_CONTEXT.get(prim);
                        if (descr != null) {
                            descriptors.addAll(descr.copy().getMatchingStates());
                            continue;
                        }
                        descriptors.add(BlockArray.BlockInformation.getDescriptor(prim));
                    }
                    if (descriptors.isEmpty()) {
                        throw new JsonParseException("'elements' array didn't contain any blockstate descriptors!");
                    }
                    BlockArray.BlockInformation bi = new BlockArray.BlockInformation(descriptors);
                    if (matchNBT != null) {
                        bi.setMatchingTag(matchNBT);
                    }
                    if (previewNBT != null) {
                        bi.setPreviewTag(previewNBT);
                    }
                    MachineDeserializer.addDescriptorWithPattern(pattern, bi, part);
                    continue;
                }
                throw new JsonParseException("'elements' has to either be a blockstate description, variable or array of blockstate descriptions!");
            }
        }

        private static void setControllerBoundingBox(JsonObject jsonPattern, DynamicMachine machine) {
            JsonArray boundingBox = JsonUtils.func_151214_t((JsonObject)jsonPattern, (String)"controller-bounding-box");
            if (boundingBox.size() != 6) {
                throw new JsonParseException("Invalid 'controllerBoundingBox'!");
            }
            machine.setControllerBoundingBox(new AxisAlignedBB(boundingBox.get(0).getAsDouble(), boundingBox.get(1).getAsDouble(), boundingBox.get(2).getAsDouble(), boundingBox.get(3).getAsDouble(), boundingBox.get(4).getAsDouble(), boundingBox.get(5).getAsDouble()));
        }

        public DynamicMachine deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject root = json.getAsJsonObject();
            String registryName = JsonUtils.func_151219_a((JsonObject)root, (String)"registryname", (String)"");
            if (registryName.isEmpty() && (registryName = JsonUtils.func_151219_a((JsonObject)root, (String)"registryName", (String)"")).isEmpty()) {
                throw new JsonParseException("Invalid/Missing 'registryname' !");
            }
            String localized = JsonUtils.func_151219_a((JsonObject)root, (String)"localizedname", (String)"");
            if (localized.isEmpty()) {
                throw new JsonParseException("Invalid/Missing 'localizedname' !");
            }
            JsonArray parts = JsonUtils.func_151213_a((JsonObject)root, (String)"parts", (JsonArray)new JsonArray());
            if (parts.size() == 0) {
                throw new JsonParseException("Empty/Missing 'parts'!");
            }
            DynamicMachine machine = new DynamicMachine(registryName);
            machine.setLocalizedName(localized);
            if (root.has("failure-action")) {
                machine.setFailureAction(DynamicMachinePreDeserializer.getFailureActions(root));
            }
            if (root.has("requires-blueprint")) {
                machine.setRequiresBlueprint(DynamicMachinePreDeserializer.getRequireBlueprint(root));
            }
            if (root.has("color")) {
                machine.setDefinedColor(DynamicMachinePreDeserializer.getColor(root));
            }
            if (root.has("has-factory")) {
                machine.setHasFactory(DynamicMachinePreDeserializer.getHasFactory(root));
            }
            if (root.has("factory-only")) {
                machine.setFactoryOnly(DynamicMachinePreDeserializer.getFactoryOnly(root));
            }
            if (root.has("hide-components-when-formed")) {
                machine.setHideComponentsWhenFormed(MachineDeserializer.getHideComponentsWhenFormed(root));
            }
            if (root.has("controller-bounding-box")) {
                MachineDeserializer.setControllerBoundingBox(root, machine);
            }
            MachineDeserializer.addParts(parts, machine.pattern);
            machine.pattern.getPattern().remove(new BlockPos(0, 0, 0));
            if (root.has("modifiers")) {
                MachineDeserializer.addModifiers(context, root, machine);
            }
            if (root.has("dynamic-patterns")) {
                MachineDeserializer.addDynamicPatterns(root, machine);
            }
            return machine;
        }
    }
}

