/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.machine;

import hellfirepvp.modularmachinery.common.data.Config;
import hellfirepvp.modularmachinery.common.machine.RecipeFailureActions;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractMachine {
    @Nonnull
    protected final ResourceLocation registryName;
    protected String localizedName = "";
    protected String prefix = "";
    protected int definedColor = Config.machineColor;
    protected int maxParallelism = Config.maxMachineParallelism;
    protected int internalParallelism = 0;
    protected int maxThreads = Config.defaultFactoryMaxThread;
    protected boolean requiresBlueprint = false;
    protected boolean parallelizable = Config.machineParallelizeEnabledByDefault;
    protected boolean hasFactory = Config.enableFactoryControllerByDefault;
    protected boolean factoryOnly = false;
    protected RecipeFailureActions failureAction = RecipeFailureActions.getDefaultAction();

    public AbstractMachine(String registryName) {
        this.registryName = new ResourceLocation("modularmachinery", registryName);
    }

    public RecipeFailureActions getFailureAction() {
        return this.failureAction;
    }

    public void setFailureAction(RecipeFailureActions failureAction) {
        this.failureAction = failureAction;
    }

    public boolean isRequiresBlueprint() {
        return this.requiresBlueprint;
    }

    public void setRequiresBlueprint(boolean requiresBlueprint) {
        this.requiresBlueprint = requiresBlueprint;
    }

    @SideOnly(value=Side.CLIENT)
    public String getPrefix() {
        String localizationKey = this.registryName.func_110624_b() + "." + this.registryName.func_110623_a() + ".prefix";
        return I18n.func_188566_a((String)localizationKey) ? I18n.func_135052_a((String)localizationKey, (Object[])new Object[0]) : (this.prefix != null ? this.prefix : localizationKey);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        String localizationKey = this.registryName.func_110624_b() + "." + this.registryName.func_110623_a();
        return I18n.func_188566_a((String)localizationKey) ? I18n.func_135052_a((String)localizationKey, (Object[])new Object[0]) : (this.localizedName != null ? this.localizedName : localizationKey);
    }

    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    public String getOriginalLocalizedName() {
        return this.localizedName;
    }

    public int getMachineColor() {
        return this.definedColor;
    }

    public void setDefinedColor(int definedColor) {
        this.definedColor = definedColor;
    }

    @Nonnull
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public boolean isParallelizable() {
        return this.parallelizable;
    }

    public void setParallelizable(boolean parallelizable) {
        this.parallelizable = parallelizable;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public void setMaxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
    }

    public int getInternalParallelism() {
        return this.internalParallelism;
    }

    public void setInternalParallelism(int internalParallelism) {
        if (this.maxParallelism < internalParallelism) {
            this.maxParallelism = internalParallelism;
        }
        this.internalParallelism = internalParallelism;
    }

    public boolean isHasFactory() {
        return this.hasFactory;
    }

    public void setHasFactory(boolean hasFactory) {
        this.hasFactory = hasFactory;
    }

    public boolean isFactoryOnly() {
        return this.factoryOnly;
    }

    public void setFactoryOnly(boolean factoryOnly) {
        this.factoryOnly = factoryOnly;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractMachine)) {
            return false;
        }
        AbstractMachine machine = (AbstractMachine)obj;
        return machine.registryName.toString().equals(this.registryName.toString());
    }

    public int hashCode() {
        return Objects.hash(this.registryName);
    }
}

