/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.recipe;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.client.ClientScheduler;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.tooltip.RequirementTip;
import hellfirepvp.modularmachinery.common.integration.ModIntegrationJEI;
import hellfirepvp.modularmachinery.common.integration.recipe.CategoryDynamicRecipe;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutHelper;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutPart;
import hellfirepvp.modularmachinery.common.lib.RegistriesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.animation.Animation;

public class DynamicRecipeWrapper
implements IRecipeWrapper {
    public Map<IOType, Map<Class<?>, List<ComponentRequirement<?, ?>>>> finalOrderedComponents = new EnumMap(IOType.class);
    private MachineRecipe recipe;

    public DynamicRecipeWrapper(MachineRecipe recipe) {
        this.reloadWrapper(recipe);
    }

    public void reloadWrapper(MachineRecipe recipe) {
        this.recipe = recipe;
        for (IOType type : IOType.values()) {
            this.finalOrderedComponents.put(type, new HashMap());
        }
        for (ComponentRequirement componentRequirement : recipe.getCraftingRequirements()) {
            ComponentRequirement.JEIComponent comp = componentRequirement.provideJEIComponent();
            if (comp == null) continue;
            this.finalOrderedComponents.get((Object)componentRequirement.getActionType()).computeIfAbsent(comp.getJEIRequirementClass(), clazz -> new LinkedList()).add(componentRequirement);
        }
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList tooltips = Lists.newArrayList();
        CategoryDynamicRecipe recipeCategory = ModIntegrationJEI.getCategory(this.recipe.getOwningMachine());
        if (recipeCategory != null && recipeCategory.rectangleProcessArrow.contains(mouseX, mouseY)) {
            tooltips.add(I18n.func_135052_a((String)"tooltip.machinery.duration.seconds", (Object[])new Object[]{Float.valueOf((float)this.recipe.getRecipeTotalTickTime() / 20.0f)}) + I18n.func_135052_a((String)"tooltip.machinery.duration.tick", (Object[])new Object[]{this.recipe.getRecipeTotalTickTime()}));
        }
        return tooltips;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        CategoryDynamicRecipe recipeCategory = ModIntegrationJEI.getCategory(this.recipe.getOwningMachine());
        if (recipeCategory == null) {
            return;
        }
        int totalDur = this.recipe.getRecipeTotalTickTime();
        int tick = (int)(ClientScheduler.getClientTick() % (long)totalDur);
        int pxPart = MathHelper.func_76123_f((float)(((float)tick + Animation.getPartialTickTime()) / (float)totalDur * (float)RecipeLayoutHelper.PART_PROCESS_ARROW_ACTIVE.xSize));
        ModIntegrationJEI.jeiHelpers.getGuiHelper().createDrawable(RecipeLayoutHelper.LOCATION_JEI_ICONS, 72, 15, pxPart, RecipeLayoutHelper.PART_PROCESS_ARROW_ACTIVE.zSize).draw(minecraft, recipeCategory.rectangleProcessArrow.x, recipeCategory.rectangleProcessArrow.y);
        int offsetY = recipeCategory.realHeight;
        int lineHeight = 9;
        int splitHeight = 2;
        ArrayList<List<String>> tooltips = new ArrayList<List<String>>();
        for (RequirementTip tip : RegistriesMM.REQUIREMENT_TIPS_REGISTRY) {
            Collection<ComponentRequirement<?, ?>> requirements = tip.filterRequirements(this.recipe, this.recipe.getCraftingRequirements());
            if (requirements.isEmpty()) continue;
            tooltips.add(tip.buildTooltip(this.recipe, requirements));
        }
        tooltips.add(this.recipe.getFormattedTooltip());
        for (Object tTip : tooltips) {
            offsetY -= lineHeight * tTip.size();
            offsetY -= splitHeight;
        }
        offsetY += splitHeight;
        FontRenderer fr = minecraft.field_71466_p;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (List tTip : tooltips) {
            for (String tip : tTip) {
                fr.func_175063_a(tip, 4.0f, (float)offsetY, 0xFFFFFF);
                offsetY += lineHeight;
            }
            offsetY += splitHeight;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        long totalEnergyIn = 0L;
        for (ComponentRequirement req : this.recipe.getCraftingRequirements().stream().filter(RequirementEnergy.class::isInstance).filter(r -> r.getActionType() == IOType.INPUT).collect(Collectors.toList())) {
            totalEnergyIn += ((RequirementEnergy)req).getRequiredEnergyPerTick();
        }
        long totalEnergyOut = 0L;
        for (ComponentRequirement req : this.recipe.getCraftingRequirements().stream().filter(RequirementEnergy.class::isInstance).filter(r -> r.getActionType() == IOType.OUTPUT).collect(Collectors.toList())) {
            totalEnergyOut += ((RequirementEnergy)req).getRequiredEnergyPerTick();
        }
        long finalTotalEnergyIn = totalEnergyIn;
        recipeCategory.inputComponents.stream().filter(RecipeLayoutPart.Energy.class::isInstance).forEach(part -> ((RecipeLayoutPart.Energy)part).drawEnergy(minecraft, finalTotalEnergyIn));
        long finalTotalEnergyOut = totalEnergyOut;
        recipeCategory.outputComponents.stream().filter(RecipeLayoutPart.Energy.class::isInstance).forEach(part -> ((RecipeLayoutPart.Energy)part).drawEnergy(minecraft, finalTotalEnergyOut));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        HashMap<IIngredientType, Map> componentMap = new HashMap<IIngredientType, Map>();
        for (ComponentRequirement<?, ?> req : this.recipe.getCraftingRequirements()) {
            ComponentRequirement.JEIComponent<?> comp;
            if (req instanceof RequirementEnergy || (comp = req.provideJEIComponent()) == null) continue;
            IIngredientType type2 = ModIntegrationJEI.ingredientRegistry.getIngredientType(comp.getJEIRequirementClass());
            componentMap.computeIfAbsent(type2, t -> new EnumMap(IOType.class)).computeIfAbsent(req.getActionType(), tt -> new LinkedList()).add(req);
        }
        componentMap.forEach((type, ioGroup) -> ioGroup.forEach((ioType, components) -> {
            ArrayList componentObjects = new ArrayList();
            for (ComponentRequirement req : components) {
                ComponentRequirement.JEIComponent jeiComp = req.provideJEIComponent();
                if (jeiComp == null) continue;
                componentObjects.add(jeiComp.getJEIIORequirements());
            }
            switch (ioType) {
                case INPUT: {
                    ingredients.setInputLists(type, componentObjects);
                    break;
                }
                case OUTPUT: {
                    ingredients.setOutputLists(type, componentObjects);
                }
            }
        }));
    }
}

