/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.recipe;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.tooltip.RequirementTip;
import hellfirepvp.modularmachinery.common.integration.ModIntegrationJEI;
import hellfirepvp.modularmachinery.common.integration.recipe.DynamicRecipeWrapper;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutHelper;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutPart;
import hellfirepvp.modularmachinery.common.lib.RegistriesMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.IOType;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;

public class CategoryDynamicRecipe
implements IRecipeCategory<DynamicRecipeWrapper> {
    final LinkedList<RecipeLayoutPart<?>> inputComponents = Lists.newLinkedList();
    final LinkedList<RecipeLayoutPart<?>> outputComponents = Lists.newLinkedList();
    private final DynamicMachine machine;
    private final String category;
    private final String title;
    int realHeight;
    Rectangle rectangleProcessArrow;
    private IDrawable sizeEmptyDrawable;
    private Point offsetProcessArrow;

    public CategoryDynamicRecipe(DynamicMachine machine) {
        this.machine = machine;
        this.category = ModIntegrationJEI.getCategoryStringFor(machine);
        this.title = machine.getLocalizedName();
        Point maxPoint = this.buildRecipeComponents();
        this.realHeight = maxPoint.y;
        this.sizeEmptyDrawable = ModIntegrationJEI.jeiHelpers.getGuiHelper().createBlankDrawable(maxPoint.x, this.realHeight);
    }

    public void reloadCategory() {
        this.inputComponents.clear();
        this.outputComponents.clear();
        Point maxPoint = this.buildRecipeComponents();
        this.realHeight = maxPoint.y;
        this.sizeEmptyDrawable = ModIntegrationJEI.jeiHelpers.getGuiHelper().createBlankDrawable(maxPoint.x, this.realHeight);
    }

    private Point buildRecipeComponents() {
        Iterable<MachineRecipe> recipes = RecipeRegistry.getRecipesFor(this.machine);
        EnumMap<IOType, Map> componentCounts = new EnumMap<IOType, Map>(IOType.class);
        HashMap componentsFound = new HashMap();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int offsetX = 4;
        int offsetY = 0;
        int highestY = 0;
        int longestTooltip = 0;
        int widestTooltip = 0;
        for (MachineRecipe machineRecipe : recipes) {
            if (!machineRecipe.getLoadJEI()) continue;
            EnumMap<IOType, Object2IntOpenHashMap> tempComp = new EnumMap<IOType, Object2IntOpenHashMap>(IOType.class);
            for (ComponentRequirement<?, ?> componentRequirement : machineRecipe.getCraftingRequirements()) {
                componentRequirement.initializeJEIRequirements();
                ObjectIterator jeiComp = componentRequirement.provideJEIComponent();
                if (jeiComp == null) continue;
                Class<?> requirementClass = jeiComp.getJEIRequirementClass();
                tempComp.computeIfAbsent(componentRequirement.getActionType(), ioType -> new Object2IntOpenHashMap()).addTo(requirementClass, 1);
                if (componentsFound.containsKey(requirementClass)) continue;
                componentsFound.put(requirementClass, jeiComp);
            }
            for (Map.Entry entry : tempComp.entrySet()) {
                for (Map.Entry cntEntry : ((Object2IntOpenHashMap)entry.getValue()).entrySet()) {
                    int current = componentCounts.computeIfAbsent((IOType)((Object)entry.getKey()), ioType -> new HashMap()).computeIfAbsent((Class)cntEntry.getKey(), clazz -> 0);
                    if ((Integer)cntEntry.getValue() <= current) continue;
                    ((Map)componentCounts.get(entry.getKey())).put((Class)cntEntry.getKey(), (Integer)cntEntry.getValue());
                }
            }
            int tipLength = 0;
            for (RequirementTip tip : RegistriesMM.REQUIREMENT_TIPS_REGISTRY) {
                List<String> tooltip;
                Collection<ComponentRequirement<?, ?>> requirements = tip.filterRequirements(machineRecipe, machineRecipe.getCraftingRequirements());
                if (requirements.isEmpty() || (tooltip = tip.buildTooltip(machineRecipe, requirements)).isEmpty()) continue;
                for (String tipString : tooltip) {
                    int length = fr.func_78256_a(tipString);
                    if (length <= widestTooltip) continue;
                    widestTooltip = length;
                }
                tipLength += 9 * tooltip.size();
                tipLength += 2;
            }
            for (String tipString : machineRecipe.getFormattedTooltip()) {
                String str = I18n.func_188566_a((String)tipString) ? I18n.func_135052_a((String)tipString, (Object[])new Object[0]) : tipString;
                int length = fr.func_78256_a(str);
                if (length > widestTooltip) {
                    widestTooltip = length;
                }
                tipLength += 9;
            }
            if (tipLength <= longestTooltip) continue;
            longestTooltip = tipLength;
        }
        LinkedList classes = new LinkedList(componentsFound.keySet());
        classes.sort((o1, o2) -> {
            RecipeLayoutPart part1 = ((ComponentRequirement.JEIComponent)componentsFound.get(o1)).getTemplateLayout();
            RecipeLayoutPart part2 = ((ComponentRequirement.JEIComponent)componentsFound.get(o2)).getTemplateLayout();
            return part2.getComponentHorizontalSortingOrder() - part1.getComponentHorizontalSortingOrder();
        });
        for (Object clazz2 : classes) {
            Map compMap = (Map)componentCounts.get((Object)IOType.INPUT);
            if (compMap == null || !compMap.containsKey(clazz2)) continue;
            ComponentRequirement.JEIComponent jEIComponent = (ComponentRequirement.JEIComponent)componentsFound.get(clazz2);
            RecipeLayoutPart layoutHelper = jEIComponent.getTemplateLayout();
            int amt = (Integer)compMap.get(clazz2);
            int partOffsetX = offsetX;
            int originalOffsetX = offsetX;
            int partOffsetY = offsetY;
            for (int i = 0; i < amt; ++i) {
                if (i > 0 && i % layoutHelper.getMaxHorizontalCount(amt) == 0) {
                    partOffsetY += layoutHelper.getComponentHeight() + layoutHelper.getComponentVerticalGap();
                    partOffsetX = originalOffsetX;
                }
                this.inputComponents.add(jEIComponent.getLayoutPart(new Point(partOffsetX, partOffsetY)));
                if ((partOffsetX += layoutHelper.getComponentWidth() + layoutHelper.getComponentHorizontalGap()) > offsetX) {
                    offsetX = partOffsetX;
                }
                if (partOffsetY + layoutHelper.getComponentHeight() <= highestY) continue;
                highestY = partOffsetY + layoutHelper.getComponentHeight();
            }
        }
        int n = offsetX += 4;
        offsetX += RecipeLayoutHelper.PART_PROCESS_ARROW.xSize;
        offsetX += 4;
        classes = new LinkedList(componentsFound.keySet());
        classes.sort((o1, o2) -> {
            RecipeLayoutPart part1 = ((ComponentRequirement.JEIComponent)componentsFound.get(o1)).getTemplateLayout();
            RecipeLayoutPart part2 = ((ComponentRequirement.JEIComponent)componentsFound.get(o2)).getTemplateLayout();
            return part1.getComponentHorizontalSortingOrder() - part2.getComponentHorizontalSortingOrder();
        });
        for (Class clazz3 : classes) {
            Map map = (Map)componentCounts.get((Object)IOType.OUTPUT);
            if (map == null || !map.containsKey(clazz3)) continue;
            ComponentRequirement.JEIComponent component = (ComponentRequirement.JEIComponent)componentsFound.get(clazz3);
            RecipeLayoutPart layoutHelper = component.getTemplateLayout();
            int amt = (Integer)map.get(clazz3);
            int partOffsetX = offsetX;
            int originalOffsetX = offsetX;
            int partOffsetY = offsetY;
            for (int i = 0; i < amt; ++i) {
                if (i > 0 && i % layoutHelper.getMaxHorizontalCount(amt) == 0) {
                    partOffsetY += layoutHelper.getComponentHeight() + layoutHelper.getComponentVerticalGap();
                    partOffsetX = originalOffsetX;
                }
                this.outputComponents.add(component.getLayoutPart(new Point(partOffsetX, partOffsetY)));
                if ((partOffsetX += layoutHelper.getComponentWidth() + layoutHelper.getComponentHorizontalGap()) > offsetX) {
                    offsetX = partOffsetX;
                }
                if (partOffsetY + layoutHelper.getComponentHeight() <= highestY) continue;
                highestY = partOffsetY + layoutHelper.getComponentHeight();
            }
        }
        int halfY = highestY / 2;
        this.offsetProcessArrow = new Point(n, halfY / 2);
        this.rectangleProcessArrow = new Rectangle(this.offsetProcessArrow.x, this.offsetProcessArrow.y, RecipeLayoutHelper.PART_PROCESS_ARROW.xSize, RecipeLayoutHelper.PART_PROCESS_ARROW.zSize);
        highestY += longestTooltip;
        if ((widestTooltip += 4) > offsetX) {
            offsetX = widestTooltip;
        }
        return new Point(offsetX, highestY);
    }

    @Nonnull
    public String getUid() {
        return this.category;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public String getModName() {
        return "Modular Machinery: Community Edition";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.sizeEmptyDrawable;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        RecipeLayoutHelper.PART_PROCESS_ARROW.drawable.draw(minecraft, this.offsetProcessArrow.x, this.offsetProcessArrow.y);
        this.inputComponents.forEach(slot -> slot.drawBackground(minecraft));
        this.outputComponents.forEach(slot -> slot.drawBackground(minecraft));
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull DynamicRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        LinkedList foundClasses = new LinkedList();
        for (IOType type : IOType.values()) {
            for (Class<?> clazz2 : recipeWrapper.finalOrderedComponents.get((Object)type).keySet()) {
                if (clazz2.equals(Long.class) || foundClasses.contains(clazz2)) continue;
                foundClasses.add(clazz2);
            }
        }
        foundClasses.forEach(clazz -> {
            int amtCompInputs = 0;
            IGuiIngredientGroup clazzGroup = recipeLayout.getIngredientsGroup(clazz);
            int[] compSlotIndex = new int[]{0};
            List inputReqList = recipeWrapper.finalOrderedComponents.get((Object)IOType.INPUT).getOrDefault(clazz, Collections.emptyList());
            for (RecipeLayoutPart recipeLayoutPart : this.inputComponents) {
                int n;
                if (!clazz.isAssignableFrom(recipeLayoutPart.getLayoutTypeClass())) continue;
                clazzGroup.init(n, true, (n = compSlotIndex[0]) < inputReqList.size() ? recipeLayoutPart.provideIngredientRenderer((ComponentRequirement)inputReqList.get(n)) : recipeLayoutPart.provideIngredientRenderer(), recipeLayoutPart.getOffset().x, recipeLayoutPart.getOffset().y, recipeLayoutPart.getComponentWidth(), recipeLayoutPart.getComponentHeight(), recipeLayoutPart.getRendererPaddingX(), recipeLayoutPart.getRendererPaddingY());
                compSlotIndex[0] = compSlotIndex[0] + 1;
                ++amtCompInputs;
            }
            List outputReqList = recipeWrapper.finalOrderedComponents.get((Object)IOType.OUTPUT).getOrDefault(clazz, Collections.emptyList());
            for (RecipeLayoutPart recipeLayoutPart : this.outputComponents) {
                if (!clazz.isAssignableFrom(recipeLayoutPart.getLayoutTypeClass())) continue;
                int index = compSlotIndex[0] - amtCompInputs;
                clazzGroup.init(compSlotIndex[0], false, index < outputReqList.size() ? recipeLayoutPart.provideIngredientRenderer((ComponentRequirement)outputReqList.get(index)) : recipeLayoutPart.provideIngredientRenderer(), recipeLayoutPart.getOffset().x, recipeLayoutPart.getOffset().y, recipeLayoutPart.getComponentWidth(), recipeLayoutPart.getComponentHeight(), recipeLayoutPart.getRendererPaddingX(), recipeLayoutPart.getRendererPaddingY());
                compSlotIndex[0] = compSlotIndex[0] + 1;
            }
            clazzGroup.set(ingredients);
            int n = amtCompInputs;
            clazzGroup.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                Map<Class<?>, List<ComponentRequirement<?, ?>>> components = recipeWrapper.finalOrderedComponents.get((Object)(input ? IOType.INPUT : IOType.OUTPUT));
                if (components != null) {
                    int index;
                    List<ComponentRequirement<?, ?>> compList = components.get(clazz);
                    int n = index = input ? slotIndex : slotIndex - finalAmtInputs;
                    if (index < 0 || index >= compList.size()) {
                        return;
                    }
                    ComponentRequirement.JEIComponent<?> jeiComp = compList.get(index).provideJEIComponent();
                    if (jeiComp == null) {
                        return;
                    }
                    jeiComp.onJEIHoverTooltip(index, input, ingredient, tooltip);
                }
            });
        });
    }
}

