/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.preview;

import github.kasuminova.mmce.client.gui.integration.GuiBlueprintScreenJEI;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.widget.base.WidgetController;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.impl.preview.WorldSceneRendererWidget;
import github.kasuminova.mmce.client.preivew.PreviewPanels;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.block.BlockFactoryController;
import hellfirepvp.modularmachinery.common.item.ItemBlueprint;
import hellfirepvp.modularmachinery.common.lib.ItemsMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.modifier.AbstractModifierReplacement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.gui.recipes.RecipesGui;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class StructurePreviewWrapper
implements IRecipeWrapper {
    private static final Field recipeLayouts;
    private static final Field recipeWrapper;
    private final DynamicMachine machine;
    private GuiBlueprintScreenJEI gui = null;

    public StructurePreviewWrapper(DynamicMachine machine) {
        this.machine = machine;
    }

    public static IRecipeWrapper getWrapper(RecipeLayout layout) {
        try {
            return (IRecipeWrapper)recipeWrapper.get(layout);
        }
        catch (IllegalAccessException e) {
            ModularMachinery.log.error((Object)e);
            return null;
        }
    }

    public static List<RecipeLayout> getRecipeLayouts(RecipesGui recipesGui) {
        try {
            return (List)recipeLayouts.get(recipesGui);
        }
        catch (IllegalAccessException e) {
            ModularMachinery.log.error((Object)e);
            return null;
        }
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        GuiScreen current = Minecraft.func_71410_x().field_71462_r;
        WorldClient clWorld = minecraft.field_71441_e;
        if (clWorld == null || !(current instanceof RecipesGui)) {
            return;
        }
        RecipesGui recipesGUI = (RecipesGui)current;
        RenderPos translateOffset = WidgetController.TRANSLATE_STATE.get();
        int guiLeft = translateOffset.posX();
        int guiTop = translateOffset.posY();
        if (this.gui == null) {
            this.gui = new GuiBlueprintScreenJEI();
            this.gui.func_146280_a(minecraft, recipesGUI.field_146294_l, recipesGUI.field_146295_m);
            this.gui.setWidgetController(new WidgetController(WidgetGui.of(this.gui, recipeWidth, recipeHeight, guiLeft, guiTop)));
        }
        this.gui.field_146294_l = recipesGUI.field_146294_l;
        this.gui.field_146295_m = recipesGUI.field_146295_m;
        this.gui.setGuiLeft(guiLeft);
        this.gui.setGuiTop(guiTop);
        this.gui.getWidgetController().getGui().setGuiLeft(guiLeft).setGuiTop(guiTop);
        WidgetController controller = this.gui.getWidgetController();
        controller.getWidgets().clear();
        controller.addWidget(PreviewPanels.getPanel(this.machine, controller.getGui()));
        this.gui.func_73876_c();
        this.gui.func_73863_a(mouseX + guiLeft, mouseY + guiTop, minecraft.func_184121_ak());
    }

    public GuiBlueprintScreenJEI getGuiBlueprintScreenJEI() {
        return this.gui;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        List<List<ItemStack>> ingredientList;
        BlockFactoryController factory;
        BlockController mocCtrl;
        ItemStack bOut = new ItemStack((Item)ItemsMM.blueprint);
        ItemBlueprint.setAssociatedMachine(bOut, this.machine);
        BlockController ctrl = BlockController.getControllerWithMachine(this.machine);
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        if (ctrl != null) {
            ItemStack ctrlStack = new ItemStack((Block)ctrl);
            stackList.add(ctrlStack);
        }
        if ((mocCtrl = BlockController.getMocControllerWithMachine(this.machine)) != null) {
            ItemStack ctrlStack = new ItemStack((Block)mocCtrl);
            stackList.add(ctrlStack);
        }
        if ((factory = BlockFactoryController.getControllerWithMachine(this.machine)) != null) {
            ItemStack factoryStack = new ItemStack((Block)factory);
            stackList.add(factoryStack);
        }
        stackList.add(bOut);
        if (this.gui != null && Mods.AE2.isPresent()) {
            WidgetController controller = this.gui.getWidgetController();
            WorldSceneRendererWidget panel = PreviewPanels.getPanel(this.machine, controller.getGui()).getRenderer();
            List<ItemStack> list = panel.getPattern().getDescriptiveStackList(panel.getTickSnap(), panel.getWorldRenderer().getWorld(), panel.getRenderOffset());
            list.remove(0);
            ArrayList<List<ItemStack>> finalList = new ArrayList<List<ItemStack>>();
            list.forEach(itemStack -> finalList.add(Collections.singletonList(itemStack)));
            ingredientList = finalList;
        } else {
            ingredientList = this.machine.getPattern().getIngredientList();
        }
        this.machine.getModifiers().values().stream().flatMap(Collection::stream).map(AbstractModifierReplacement::getDescriptiveStack).forEach(stack -> ingredientList.add(Collections.singletonList(stack)));
        this.machine.getMultiBlockModifiers().stream().map(AbstractModifierReplacement::getDescriptiveStack).forEach(stack -> ingredientList.add(Collections.singletonList(stack)));
        ingredients.setInputLists(VanillaTypes.ITEM, ingredientList);
        ingredients.setOutputs(VanillaTypes.ITEM, stackList);
    }

    static {
        Field field;
        try {
            field = RecipesGui.class.getDeclaredField("recipeLayouts");
            field.setAccessible(true);
        }
        catch (Exception exc) {
            field = null;
        }
        recipeLayouts = field;
        try {
            field = RecipeLayout.class.getDeclaredField("recipeWrapper");
            field.setAccessible(true);
        }
        catch (Exception exc) {
            field = null;
        }
        recipeWrapper = field;
    }
}

