/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.fluxnetworks;

import hellfirepvp.modularmachinery.common.tiles.base.TileEnergyHatch;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import sonar.fluxnetworks.api.energy.ITileEnergyHandler;

public class MMEnergyHandler
implements ITileEnergyHandler {
    public static final MMEnergyHandler INSTANCE = new MMEnergyHandler();

    private MMEnergyHandler() {
    }

    public boolean hasCapability(@Nonnull TileEntity tile, EnumFacing side) {
        return !tile.func_145837_r() && tile instanceof TileEnergyHatch;
    }

    public boolean canAddEnergy(@Nonnull TileEntity tile, EnumFacing side) {
        if (tile instanceof TileEnergyHatch) {
            TileEnergyHatch energyHatch = (TileEnergyHatch)tile;
            return energyHatch.canReceive();
        }
        return false;
    }

    public boolean canRemoveEnergy(@Nonnull TileEntity tile, EnumFacing side) {
        if (tile instanceof TileEnergyHatch) {
            TileEnergyHatch energyHatch = (TileEnergyHatch)tile;
            return energyHatch.canExtract();
        }
        return false;
    }

    public long addEnergy(long amount, @Nonnull TileEntity tile, EnumFacing side, boolean simulate) {
        if (!(tile instanceof TileEnergyHatch)) {
            return 0L;
        }
        TileEnergyHatch energyHatch = (TileEnergyHatch)tile;
        long remainingCapacity = energyHatch.getRemainingCapacity();
        long transferLimit = Math.min(energyHatch.getTier().transferLimit, remainingCapacity);
        if (simulate) {
            return Math.min(transferLimit, amount);
        }
        if (transferLimit < amount) {
            return energyHatch.receiveEnergy(transferLimit) ? transferLimit : 0L;
        }
        return energyHatch.receiveEnergy(amount) ? amount : 0L;
    }

    public long removeEnergy(long amount, @Nonnull TileEntity tile, EnumFacing side) {
        if (!(tile instanceof TileEnergyHatch)) {
            return 0L;
        }
        TileEnergyHatch energyHatch = (TileEnergyHatch)tile;
        long currentEnergy = energyHatch.getCurrentEnergy();
        long transferLimit = Math.min(energyHatch.getTier().transferLimit, currentEnergy);
        if (transferLimit < amount) {
            return energyHatch.extractEnergy(transferLimit) ? transferLimit : 0L;
        }
        return energyHatch.extractEnergy(amount) ? amount : 0L;
    }
}

