/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.crafttweaker.upgrade;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import github.kasuminova.mmce.common.capability.CapabilityUpgrade;
import github.kasuminova.mmce.common.upgrade.MachineUpgrade;
import github.kasuminova.mmce.common.upgrade.SimpleDynamicMachineUpgrade;
import github.kasuminova.mmce.common.upgrade.SimpleMachineUpgrade;
import github.kasuminova.mmce.common.upgrade.registry.RegistryUpgrade;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.MachineUpgradeHelper")
public class MachineUpgradeHelper {
    @ZenMethod
    public static void registerSupportedItem(IItemStack itemStack) {
        ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)itemStack);
        if (!stack.func_190926_b()) {
            RegistryUpgrade.addSupportedItem(stack);
        }
    }

    @ZenMethod
    public static void addFixedUpgrade(IItemStack itemStack, String upgradeName) {
        ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)itemStack);
        if (stack.func_190926_b()) {
            return;
        }
        MachineUpgrade upgrade = RegistryUpgrade.getUpgrade(upgradeName);
        if (upgrade == null) {
            CraftTweakerAPI.logError((String)("[ModularMachinery] Cloud not find MachineUpgrade " + upgradeName + '!'));
            return;
        }
        RegistryUpgrade.addFixedUpgrade(stack, upgrade);
    }

    @ZenMethod
    public static IItemStack addUpgradeToIItemStack(IItemStack stackCT, String upgradeName) {
        ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)stackCT);
        if (!RegistryUpgrade.supportsUpgrade(stack)) {
            CraftTweakerAPI.logWarning((String)("[ModularMachinery] " + stackCT.getDefinition().getId() + " does not support upgrade!"));
            return stackCT;
        }
        CapabilityUpgrade capability = (CapabilityUpgrade)stack.getCapability(CapabilityUpgrade.MACHINE_UPGRADE_CAPABILITY, null);
        if (capability == null) {
            return stackCT;
        }
        MachineUpgrade upgrade = RegistryUpgrade.getUpgrade(upgradeName);
        if (upgrade == null) {
            CraftTweakerAPI.logWarning((String)("[ModularMachinery] Cloud not found MachineUpgrade " + upgradeName + '!'));
            return stackCT;
        }
        capability.getUpgrades().add(upgrade);
        return CraftTweakerMC.getIItemStack((ItemStack)stack);
    }

    @Nullable
    @ZenMethod
    public static MachineUpgrade getUpgrade(String upgradeName) {
        return RegistryUpgrade.getUpgrade(upgradeName);
    }

    @ZenMethod
    public static SimpleDynamicMachineUpgrade castToSimpleDynamicMachineUpgrade(MachineUpgrade upgrade) {
        return upgrade instanceof SimpleDynamicMachineUpgrade ? (SimpleDynamicMachineUpgrade)upgrade : null;
    }

    @ZenMethod
    public static SimpleMachineUpgrade castToSimpleMachineUpgrade(MachineUpgrade upgrade) {
        return upgrade instanceof SimpleMachineUpgrade ? (SimpleMachineUpgrade)upgrade : null;
    }
}

