/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.crafttweaker.modifier;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import hellfirepvp.modularmachinery.common.modifier.MultiBlockModifierReplacement;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.MultiblockModifierBuilder")
public class MultiBlockModifierBuilder {
    private final List<RecipeModifier> modifiers = new LinkedList<RecipeModifier>();
    private final List<String> descriptions = new ArrayList<String>();
    private final String modifierName;
    private BlockArray blockArray = null;
    private ItemStack descriptiveStack = ItemStack.field_190927_a;

    private MultiBlockModifierBuilder() {
        this.modifierName = null;
    }

    private MultiBlockModifierBuilder(String modifierName) {
        this.modifierName = modifierName;
    }

    @ZenMethod
    public static MultiBlockModifierBuilder newBuilder() {
        return new MultiBlockModifierBuilder();
    }

    @ZenMethod
    public static MultiBlockModifierBuilder newBuilder(String modifierName) {
        return new MultiBlockModifierBuilder(modifierName);
    }

    @ZenMethod
    public MultiBlockModifierBuilder setBlockArray(BlockArray blockArray) {
        this.blockArray = blockArray;
        return this;
    }

    @ZenMethod
    public MultiBlockModifierBuilder addModifier(RecipeModifier ... modifiers) {
        this.modifiers.addAll(Arrays.asList(modifiers));
        return this;
    }

    @ZenMethod
    public MultiBlockModifierBuilder setDescriptiveStack(IItemStack descriptiveStack) {
        this.descriptiveStack = CraftTweakerMC.getItemStack((IItemStack)descriptiveStack);
        return this;
    }

    @ZenMethod
    public MultiBlockModifierReplacement build() {
        if (this.blockArray == null) {
            CraftTweakerAPI.logError((String)"BlockArray cannot be null!");
            return null;
        }
        return new MultiBlockModifierReplacement(this.modifierName, this.blockArray, this.modifiers, this.descriptions, this.descriptiveStack);
    }
}

