/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFailureEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFinishEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeStartEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeTickEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeFailureEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeFinishEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeStartEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeTickEvent;
import github.kasuminova.mmce.common.itemtype.ChancedIngredientStack;
import github.kasuminova.mmce.common.util.concurrent.Action;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.crafting.PreparedRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentSelectorTag;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementCatalyst;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementFluid;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementFluidPerTick;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementGas;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementGasPerTick;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementIngredientArray;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementInterfaceNumInput;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.data.Config;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.IngredientArrayPrimer;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.helper.AdvancedItemCheckerCT;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.helper.AdvancedItemModifierCT;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.SmartInterfaceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.RecipePrimer")
public class RecipePrimer
implements PreparedRecipe {
    protected final ResourceLocation name;
    protected final ResourceLocation machineName;
    private final int tickTime;
    private final int priority;
    private final boolean doesVoidPerTick;
    private final List<ComponentRequirement<?, ?>> components = new LinkedList();
    private final List<Action> needAfterInitActions = new LinkedList<Action>();
    private final List<String> toolTipList = new ArrayList<String>();
    private final Map<Class<?>, List<IEventHandler<RecipeEvent>>> recipeEventHandlers = new HashMap();
    private boolean parallelized = Config.recipeParallelizeEnabledByDefault;
    private boolean loadJEI = true;
    private int maxThreads = -1;
    private String threadName = "";
    private ComponentRequirement<?, ?> lastComponent = null;

    public RecipePrimer(ResourceLocation registryName, ResourceLocation owningMachine, int tickTime, int configuredPriority, boolean doesVoidPerTick) {
        this.name = registryName;
        this.machineName = owningMachine;
        this.tickTime = tickTime;
        this.priority = configuredPriority;
        this.doesVoidPerTick = doesVoidPerTick;
    }

    @ZenMethod
    public RecipePrimer setParallelizeUnaffected(boolean unaffected) {
        ComponentRequirement<?, ?> componentRequirement = this.lastComponent;
        if (componentRequirement instanceof ComponentRequirement.Parallelizable) {
            ComponentRequirement.Parallelizable parallelizable = (ComponentRequirement.Parallelizable)((Object)componentRequirement);
            parallelizable.setParallelizeUnaffected(unaffected);
        } else {
            CraftTweakerAPI.logWarning((String)("[ModularMachinery] Target " + this.lastComponent.getClass() + " cannot be parallelized!"));
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer setChance(float chance) {
        if (this.lastComponent != null) {
            ComponentRequirement<?, ?> componentRequirement = this.lastComponent;
            if (componentRequirement instanceof ComponentRequirement.ChancedRequirement) {
                ComponentRequirement.ChancedRequirement chancedReq = (ComponentRequirement.ChancedRequirement)((Object)componentRequirement);
                chancedReq.setChance(chance);
            } else {
                CraftTweakerAPI.logWarning((String)("[ModularMachinery] Cannot set chance for not-chance-based Component: " + this.lastComponent.getClass()));
            }
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer setTag(String selectorTag) {
        if (this.lastComponent != null) {
            this.lastComponent.setTag(new ComponentSelectorTag(selectorTag));
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer setPreViewNBT(IData nbt) {
        if (this.lastComponent != null) {
            ComponentRequirement<?, ?> componentRequirement = this.lastComponent;
            if (componentRequirement instanceof RequirementItem) {
                RequirementItem reqItem = (RequirementItem)componentRequirement;
                reqItem.previewDisplayTag = CraftTweakerMC.getNBTCompound((IData)nbt);
            } else {
                CraftTweakerAPI.logWarning((String)"[ModularMachinery] setPreViewNBT(IData nbt) only can be applied to `Item`!");
            }
        } else {
            CraftTweakerAPI.logWarning((String)"[ModularMachinery] setPreViewNBT(IData nbt) only can be applied to `Item`!");
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer setNBTChecker(AdvancedItemCheckerCT checker) {
        if (this.lastComponent != null) {
            ComponentRequirement<?, ?> componentRequirement = this.lastComponent;
            if (componentRequirement instanceof RequirementItem) {
                RequirementItem reqItem = (RequirementItem)componentRequirement;
                reqItem.setItemChecker((controller, stack) -> checker.isMatch(controller, CraftTweakerMC.getIItemStack((ItemStack)stack)));
            } else {
                CraftTweakerAPI.logWarning((String)"[ModularMachinery] setNBTChecker(AdvancedItemNBTChecker checker) only can be applied to `Item`!");
            }
        } else {
            CraftTweakerAPI.logWarning((String)"[ModularMachinery] setNBTChecker(AdvancedItemNBTChecker checker) only can be applied to `Item`!");
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer addItemModifier(AdvancedItemModifierCT modifier) {
        if (this.lastComponent != null) {
            ComponentRequirement<?, ?> componentRequirement = this.lastComponent;
            if (componentRequirement instanceof RequirementItem) {
                RequirementItem reqItem = (RequirementItem)componentRequirement;
                reqItem.addItemModifier((TileMultiblockMachineController controller, ItemStack stack) -> CraftTweakerMC.getItemStack((IItemStack)modifier.apply(controller, CraftTweakerMC.getIItemStackMutable((ItemStack)stack))));
            } else {
                CraftTweakerAPI.logWarning((String)"[ModularMachinery] addItemModifier(AdvancedItemModifier checker) only can be applied to `Item`!");
            }
        } else {
            CraftTweakerAPI.logWarning((String)"[ModularMachinery] addItemModifier(AdvancedItemModifier checker) only can be applied to `Item`!");
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer setMinMaxAmount(int min, int max) {
        if (this.lastComponent != null) {
            ComponentRequirement<?, ?> componentRequirement = this.lastComponent;
            if (componentRequirement instanceof RequirementItem) {
                RequirementItem reqItem = (RequirementItem)componentRequirement;
                if (min < max) {
                    reqItem.minAmount = min;
                    reqItem.maxAmount = max;
                } else {
                    CraftTweakerAPI.logWarning((String)"[ModularMachinery] `min` cannot larger than `max`!");
                }
            } else {
                CraftTweakerAPI.logWarning((String)"[ModularMachinery] setMinMaxOutputAmount(int min, int max) only can be applied to `Item`!");
            }
        } else {
            CraftTweakerAPI.logWarning((String)"[ModularMachinery] setMinMaxOutputAmount(int min, int max) only can be applied to `Item`!");
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer setTriggerTime(int tickTime) {
        if (this.lastComponent != null) {
            this.lastComponent.setTriggerTime(tickTime);
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer setTriggerRepeatable(boolean repeatable) {
        if (this.lastComponent != null) {
            this.lastComponent.setTriggerRepeatable(repeatable);
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer setIgnoreOutputCheck(boolean ignoreOutputCheck) {
        if (this.lastComponent != null) {
            this.lastComponent.setIgnoreOutputCheck(ignoreOutputCheck);
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer addRecipeTooltip(String ... tooltips) {
        this.toolTipList.addAll(Arrays.asList(tooltips));
        return this;
    }

    @ZenMethod
    public RecipePrimer addSmartInterfaceDataInput(String typeStr, float minValue, float maxValue) {
        this.needAfterInitActions.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(this.machineName);
            if (machine == null) {
                CraftTweakerAPI.logError((String)("Could not find machine `" + this.machineName.toString() + "`!"));
                return;
            }
            SmartInterfaceType type = machine.getSmartInterfaceType(typeStr);
            if (type == null) {
                CraftTweakerAPI.logError((String)("SmartInterfaceType " + typeStr + " Not Found!"));
                return;
            }
            this.appendComponent(new RequirementInterfaceNumInput(type, minValue, maxValue));
        });
        return this;
    }

    @ZenMethod
    public RecipePrimer addSmartInterfaceDataInput(String typeStr, float value) {
        return this.addSmartInterfaceDataInput(typeStr, value, value);
    }

    @ZenMethod
    public RecipePrimer addPreCheckHandler(IEventHandler<RecipeCheckEvent> handler) {
        this.addRecipeEventHandler(RecipeCheckEvent.class, event -> {
            if (event.phase != Phase.START) {
                return;
            }
            handler.handle((Object)event);
        });
        return this;
    }

    @ZenMethod
    public RecipePrimer addPostCheckHandler(IEventHandler<RecipeCheckEvent> handler) {
        this.addRecipeEventHandler(RecipeCheckEvent.class, event -> {
            if (event.phase != Phase.END) {
                return;
            }
            handler.handle((Object)event);
        });
        return this;
    }

    @ZenMethod
    @Deprecated
    public RecipePrimer addCheckHandler(IEventHandler<RecipeCheckEvent> handler) {
        CraftTweakerAPI.logWarning((String)"[ModularMachinery] Deprecated method addCheckHandler()! Consider using addPostCheckHandler()");
        this.addRecipeEventHandler(RecipeCheckEvent.class, handler);
        return this;
    }

    @ZenMethod
    public RecipePrimer addStartHandler(IEventHandler<RecipeStartEvent> handler) {
        this.addRecipeEventHandler(RecipeStartEvent.class, handler);
        return this;
    }

    @ZenMethod
    public RecipePrimer addPreTickHandler(IEventHandler<RecipeTickEvent> handler) {
        this.addRecipeEventHandler(RecipeTickEvent.class, event -> {
            if (event.phase != Phase.START) {
                return;
            }
            handler.handle((Object)event);
        });
        return this;
    }

    @ZenMethod
    public RecipePrimer addPostTickHandler(IEventHandler<RecipeTickEvent> handler) {
        this.addRecipeEventHandler(RecipeTickEvent.class, event -> {
            if (event.phase != Phase.END) {
                return;
            }
            handler.handle((Object)event);
        });
        return this;
    }

    @ZenMethod
    public RecipePrimer addFailureHandler(IEventHandler<RecipeFailureEvent> handler) {
        this.addRecipeEventHandler(RecipeFailureEvent.class, handler);
        return this;
    }

    @ZenMethod
    public RecipePrimer addFinishHandler(IEventHandler<RecipeFinishEvent> handler) {
        this.addRecipeEventHandler(RecipeFinishEvent.class, handler);
        return this;
    }

    @ZenMethod
    public RecipePrimer addFactoryStartHandler(IEventHandler<FactoryRecipeStartEvent> handler) {
        this.addRecipeEventHandler(FactoryRecipeStartEvent.class, handler);
        return this;
    }

    @ZenMethod
    public RecipePrimer addFactoryPreTickHandler(IEventHandler<FactoryRecipeTickEvent> handler) {
        this.addRecipeEventHandler(FactoryRecipeTickEvent.class, event -> {
            if (event.phase != Phase.START) {
                return;
            }
            handler.handle((Object)event);
        });
        return this;
    }

    @ZenMethod
    public RecipePrimer addFactoryPostTickHandler(IEventHandler<FactoryRecipeTickEvent> handler) {
        this.addRecipeEventHandler(FactoryRecipeTickEvent.class, event -> {
            if (event.phase != Phase.END) {
                return;
            }
            handler.handle((Object)event);
        });
        return this;
    }

    @ZenMethod
    public RecipePrimer addFactoryFailureHandler(IEventHandler<FactoryRecipeFailureEvent> handler) {
        this.addRecipeEventHandler(FactoryRecipeFailureEvent.class, handler);
        return this;
    }

    @ZenMethod
    public RecipePrimer addFactoryFinishHandler(IEventHandler<FactoryRecipeFinishEvent> handler) {
        this.addRecipeEventHandler(FactoryRecipeFinishEvent.class, handler);
        return this;
    }

    private <H extends RecipeEvent> void addRecipeEventHandler(Class<H> hClass, IEventHandler<H> handler) {
        this.recipeEventHandlers.putIfAbsent(hClass, new ArrayList());
        this.recipeEventHandlers.get(hClass).add(handler);
    }

    @ZenMethod
    public RecipePrimer addInput(IIngredient input) {
        if (input instanceof IItemStack || input instanceof IOreDictEntry || input instanceof IngredientStack && input.getInternal() instanceof IOreDictEntry) {
            this.addItemInput(input);
        } else if (input instanceof ILiquidStack) {
            ILiquidStack liquidStack = (ILiquidStack)input;
            this.addFluidInput(liquidStack);
        } else if (!Mods.MEKANISM.isPresent() || !this.checkIGasStackAndAdd(IOType.INPUT, input)) {
            CraftTweakerAPI.logError((String)String.format("[ModularMachinery] Invalid input type %s(%s)! Ignored.", input, input.getClass()));
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer addInputs(IIngredient ... inputs) {
        for (IIngredient input : inputs) {
            this.addInput(input);
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer addOutput(IIngredient output) {
        if (output instanceof IItemStack || output instanceof IOreDictEntry || output instanceof IngredientStack && output.getInternal() instanceof IOreDictEntry) {
            this.addItemOutput(output);
        } else if (output instanceof ILiquidStack) {
            this.addFluidOutput((ILiquidStack)output);
        } else if (!Mods.MEKANISM.isPresent() || !this.checkIGasStackAndAdd(IOType.OUTPUT, output)) {
            CraftTweakerAPI.logError((String)String.format("[ModularMachinery] Invalid output type %s(%s)! Ignored.", output, output.getClass()));
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer addOutputs(IIngredient ... outputs) {
        for (IIngredient output : outputs) {
            this.addOutput(output);
        }
        return this;
    }

    @Optional.Method(modid="mekanism")
    private boolean checkIGasStackAndAdd(IOType ioType, IIngredient input) {
        if (!(input instanceof IGasStack)) {
            return false;
        }
        IGasStack gasStack = (IGasStack)input;
        switch (ioType) {
            case INPUT: {
                this.addGasInput(gasStack);
                break;
            }
            case OUTPUT: {
                this.addGasOutput(gasStack);
            }
        }
        return true;
    }

    @ZenMethod
    public RecipePrimer addEnergyPerTickInput(long perTick) {
        this.requireEnergy(IOType.INPUT, perTick);
        return this;
    }

    @ZenMethod
    public RecipePrimer addEnergyPerTickOutput(long perTick) {
        this.requireEnergy(IOType.OUTPUT, perTick);
        return this;
    }

    @ZenMethod
    public RecipePrimer addFluidInput(ILiquidStack fluid) {
        this.requireFluid(IOType.INPUT, fluid, false);
        return this;
    }

    @ZenMethod
    public RecipePrimer addFluidInputs(ILiquidStack ... fluids) {
        for (ILiquidStack fluid : fluids) {
            this.addFluidInput(fluid);
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer addFluidPerTickInput(ILiquidStack fluid) {
        this.requireFluid(IOType.INPUT, fluid, true);
        return this;
    }

    @ZenMethod
    public RecipePrimer addFluidPerTickInputs(ILiquidStack ... fluids) {
        for (ILiquidStack fluid : fluids) {
            this.addFluidPerTickInput(fluid);
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer addFluidOutput(ILiquidStack fluid) {
        this.requireFluid(IOType.OUTPUT, fluid, false);
        return this;
    }

    @ZenMethod
    public RecipePrimer addFluidOutputs(ILiquidStack ... fluids) {
        for (ILiquidStack fluid : fluids) {
            this.addFluidOutput(fluid);
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer addFluidPerTickOutput(ILiquidStack fluid) {
        this.requireFluid(IOType.OUTPUT, fluid, true);
        return this;
    }

    @ZenMethod
    public RecipePrimer addFluidPerTickOutputs(ILiquidStack ... fluids) {
        for (ILiquidStack fluid : fluids) {
            this.addFluidPerTickOutput(fluid);
        }
        return this;
    }

    @ZenMethod
    @Deprecated
    @Optional.Method(modid="mekanism")
    public RecipePrimer addGasInput(String gasName, int amount) {
        this.requireGas(IOType.INPUT, gasName, amount);
        return this;
    }

    @ZenMethod
    @Deprecated
    @Optional.Method(modid="mekanism")
    public RecipePrimer addGasOutput(String gasName, int amount) {
        this.requireGas(IOType.OUTPUT, gasName, amount);
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="mekanism")
    public RecipePrimer addGasInput(IGasStack gasStack) {
        this.requireGas(IOType.INPUT, gasStack, false);
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="mekanism")
    public RecipePrimer addGasOutput(IGasStack gasStack) {
        this.requireGas(IOType.OUTPUT, gasStack, false);
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="mekanism")
    public RecipePrimer addGasInputs(IGasStack ... gasStacks) {
        for (IGasStack gasStack : gasStacks) {
            this.requireGas(IOType.INPUT, gasStack, false);
        }
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="mekanism")
    public RecipePrimer addGasOutputs(IGasStack ... gasStacks) {
        for (IGasStack gasStack : gasStacks) {
            this.requireGas(IOType.OUTPUT, gasStack, false);
        }
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="mekanism")
    public RecipePrimer addGasPerTickInput(IGasStack gasStack) {
        this.requireGas(IOType.INPUT, gasStack, true);
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="mekanism")
    public RecipePrimer addGasPerTickOutput(IGasStack gasStack) {
        this.requireGas(IOType.OUTPUT, gasStack, true);
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="mekanism")
    public RecipePrimer addGasPerTickInputs(IGasStack ... gasStacks) {
        for (IGasStack gasStack : gasStacks) {
            this.requireGas(IOType.INPUT, gasStack, true);
        }
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="mekanism")
    public RecipePrimer addGasPerTickOutputs(IGasStack ... gasStacks) {
        for (IGasStack gasStack : gasStacks) {
            this.requireGas(IOType.OUTPUT, gasStack, true);
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer addItemInput(IIngredient input) {
        if (input instanceof IItemStack) {
            this.requireItem(IOType.INPUT, (IItemStack)input);
        } else if (input instanceof IOreDictEntry) {
            this.requireItem(IOType.INPUT, ((IOreDictEntry)input).getName(), 1);
        } else if (input instanceof IngredientStack && input.getInternal() instanceof IOreDictEntry) {
            this.requireItem(IOType.INPUT, ((IOreDictEntry)input.getInternal()).getName(), input.getAmount());
        } else {
            CraftTweakerAPI.logError((String)String.format("[ModularMachinery] Invalid input type %s(%s)! Ignored.", input, input.getClass()));
        }
        return this;
    }

    @Deprecated
    @ZenMethod
    public RecipePrimer addItemInput(IOreDictEntry oreDict, int amount) {
        this.requireItem(IOType.INPUT, oreDict.getName(), amount);
        CraftTweakerAPI.logWarning((String)String.format("[ModularMachinery] Deprecated method `addItemInput(<ore:%s>, %s)`! Consider using `addItemInput(<ore:%s> * %s)`", oreDict.getName(), amount, oreDict.getName(), amount));
        return this;
    }

    @ZenMethod
    public RecipePrimer addItemInputs(IIngredient ... inputs) {
        for (IIngredient input : inputs) {
            this.addItemInput(input);
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer addFuelItemInput(int requiredTotalBurnTime) {
        this.requireFuel(requiredTotalBurnTime);
        return this;
    }

    @ZenMethod
    public RecipePrimer addIngredientArrayInput(IngredientArrayPrimer ingredientArrayPrimer) {
        this.appendComponent(new RequirementIngredientArray(ingredientArrayPrimer.getIngredientStackList()));
        return this;
    }

    @ZenMethod
    public RecipePrimer addRandomItemOutput(IngredientArrayPrimer ingredientArrayPrimer) {
        this.appendComponent(new RequirementIngredientArray((List<ChancedIngredientStack>)ingredientArrayPrimer.getIngredientStackList(), IOType.OUTPUT));
        return this;
    }

    @ZenMethod
    public RecipePrimer addItemOutput(IIngredient output) {
        if (output instanceof IItemStack) {
            this.requireItem(IOType.OUTPUT, (IItemStack)output);
        } else if (output instanceof IOreDictEntry) {
            this.requireItem(IOType.OUTPUT, ((IOreDictEntry)output).getName(), 1);
        } else if (output instanceof IngredientStack && output.getInternal() instanceof IOreDictEntry) {
            this.requireItem(IOType.OUTPUT, ((IOreDictEntry)output.getInternal()).getName(), output.getAmount());
        } else {
            CraftTweakerAPI.logError((String)String.format("[ModularMachinery] Invalid output type %s(%s)! Ignored.", output, output.getClass()));
        }
        return this;
    }

    @Deprecated
    @ZenMethod
    public RecipePrimer addItemOutput(IOreDictEntry oreDict, int amount) {
        this.requireItem(IOType.OUTPUT, oreDict.getName(), amount);
        CraftTweakerAPI.logWarning((String)String.format("[ModularMachinery] Deprecated method `addItemOutput(<ore:%s>, %s)`! Consider using `addItemOutput(<ore:%s> * %s)`", oreDict.getName(), amount, oreDict.getName(), amount));
        return this;
    }

    @ZenMethod
    public RecipePrimer addItemOutputs(IIngredient ... inputs) {
        for (IIngredient input : inputs) {
            this.addItemOutput(input);
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer addCatalystInput(IIngredient input, String[] tooltips, RecipeModifier[] modifiers) {
        if (input instanceof IItemStack) {
            this.requireCatalyst((IItemStack)input, tooltips, modifiers);
        } else if (input instanceof IOreDictEntry) {
            this.requireCatalyst(((IOreDictEntry)input).getName(), 1, tooltips, modifiers);
        } else if (input instanceof IngredientStack && input.getInternal() instanceof IOreDictEntry) {
            this.requireCatalyst(((IOreDictEntry)input.getInternal()).getName(), input.getAmount(), tooltips, modifiers);
        } else {
            CraftTweakerAPI.logError((String)String.format("[ModularMachinery] Invalid input type %s(%s)! Ignored.", input, input.getClass()));
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer addCatalystInput(IngredientArrayPrimer input, String[] tooltips, RecipeModifier[] modifiers) {
        this.requireCatalyst(input, tooltips, modifiers);
        return this;
    }

    private void requireEnergy(IOType ioType, long perTick) {
        this.appendComponent(new RequirementEnergy(ioType, perTick));
    }

    private void requireFluid(IOType ioType, ILiquidStack stack, boolean isPerTick) {
        FluidStack mcFluid = CraftTweakerMC.getLiquidStack((ILiquidStack)stack);
        if (mcFluid == null) {
            CraftTweakerAPI.logError((String)("[ModularMachinery] FluidStack not found/unknown fluid: " + stack.toString()));
            return;
        }
        if (stack.getTag() != null) {
            mcFluid.tag = CraftTweakerMC.getNBTCompound((IData)stack.getTag());
        }
        if (isPerTick) {
            this.appendComponent(new RequirementFluidPerTick(ioType, mcFluid));
        } else {
            this.appendComponent(new RequirementFluid(ioType, mcFluid));
        }
    }

    @Deprecated
    @Optional.Method(modid="mekanism")
    private void requireGas(IOType ioType, String gasName, int amount) {
        Gas gas = GasRegistry.getGas((String)gasName);
        if (gas == null) {
            CraftTweakerAPI.logError((String)("[ModularMachinery] GasStack not found/unknown gas: " + gasName));
            return;
        }
        int max = Math.max(0, amount);
        GasStack gasStack = new GasStack(gas, max);
        switch (ioType) {
            case INPUT: {
                CraftTweakerAPI.logWarning((String)String.format("[ModularMachinery] `addGasInput(%s, %d)` is deprecated, consider using `<gas:%s> * %d`!", gasName, amount, gasName, amount));
                break;
            }
            case OUTPUT: {
                CraftTweakerAPI.logWarning((String)String.format("[ModularMachinery] `addGasOutput(%s, %d)` is deprecated, consider using `<gas:%s> * %d`!", gasName, amount, gasName, amount));
            }
        }
        RequirementGas req = new RequirementGas(ioType, gasStack);
        this.appendComponent(req);
    }

    @Optional.Method(modid="mekanism")
    private void requireGas(IOType ioType, IGasStack gasStack, boolean perTick) {
        if (perTick) {
            RequirementGasPerTick req = new RequirementGasPerTick(ioType, (GasStack)gasStack.getInternal());
            this.appendComponent(req);
            return;
        }
        RequirementGas req = new RequirementGas(ioType, (GasStack)gasStack.getInternal());
        this.appendComponent(req);
    }

    private void requireFuel(int requiredTotalBurnTime) {
        this.appendComponent(new RequirementItem(IOType.INPUT, requiredTotalBurnTime));
    }

    private void requireItem(IOType ioType, IItemStack stack) {
        ItemStack mcStack = CraftTweakerMC.getItemStack((IItemStack)stack);
        if (mcStack.func_190926_b()) {
            CraftTweakerAPI.logError((String)("[ModularMachinery] ItemStack not found/unknown item: " + stack.toString()));
            return;
        }
        RequirementItem ri = new RequirementItem(ioType, mcStack);
        if (stack.getTag().length() > 0) {
            ri.tag = CraftTweakerMC.getNBTCompound((IData)stack.getTag());
            ri.previewDisplayTag = CraftTweakerMC.getNBTCompound((IData)stack.getTag());
        }
        this.appendComponent(ri);
    }

    private void requireItem(IOType ioType, String oreDictName, int amount) {
        this.appendComponent(new RequirementItem(ioType, oreDictName, amount));
    }

    private void requireCatalyst(String oreDictName, int amount, String[] tooltips, RecipeModifier[] modifiers) {
        RequirementCatalyst catalyst = new RequirementCatalyst(oreDictName, amount);
        for (String tooltip : tooltips) {
            catalyst.addTooltip(tooltip);
        }
        for (RecipeModifier modifier : modifiers) {
            if (modifier == null) continue;
            catalyst.addModifier(modifier);
        }
        this.appendComponent(catalyst);
    }

    private void requireCatalyst(IItemStack stack, String[] tooltips, RecipeModifier[] modifiers) {
        ItemStack mcStack = CraftTweakerMC.getItemStack((IItemStack)stack);
        if (mcStack.func_190926_b()) {
            CraftTweakerAPI.logError((String)("[ModularMachinery] ItemStack not found/unknown item: " + stack.toString()));
            return;
        }
        RequirementCatalyst catalyst = new RequirementCatalyst(mcStack);
        for (String tooltip : tooltips) {
            catalyst.addTooltip(tooltip);
        }
        for (RecipeModifier modifier : modifiers) {
            if (modifier == null) continue;
            catalyst.addModifier(modifier);
        }
        this.appendComponent(catalyst);
    }

    private void requireCatalyst(IngredientArrayPrimer ingredientArrayPrimer, String[] tooltips, RecipeModifier[] modifiers) {
        RequirementCatalyst catalyst = new RequirementCatalyst(ingredientArrayPrimer.getIngredientStackList());
        for (String tooltip : tooltips) {
            catalyst.addTooltip(tooltip);
        }
        for (RecipeModifier modifier : modifiers) {
            if (modifier == null) continue;
            catalyst.addModifier(modifier);
        }
        this.appendComponent(catalyst);
    }

    public void appendComponent(ComponentRequirement<?, ?> component) {
        this.components.add(component);
        this.lastComponent = component;
    }

    @ZenMethod
    public void build() {
        RecipeRegistry.getRegistry().registerRecipeEarly(this);
    }

    @Override
    public String getFilePath() {
        return "";
    }

    @Override
    public ResourceLocation getRecipeRegistryName() {
        return this.name;
    }

    @Override
    public ResourceLocation getAssociatedMachineName() {
        return this.machineName;
    }

    @Override
    public ResourceLocation getParentMachineName() {
        return this.machineName;
    }

    @Override
    public int getTotalProcessingTickTime() {
        return this.tickTime;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean voidPerTickFailure() {
        return this.doesVoidPerTick;
    }

    @Override
    public List<ComponentRequirement<?, ?>> getComponents() {
        return this.components;
    }

    @Override
    public Map<Class<?>, List<IEventHandler<RecipeEvent>>> getRecipeEventHandlers() {
        return this.recipeEventHandlers;
    }

    @Override
    public List<String> getTooltipList() {
        return this.toolTipList;
    }

    @Override
    public boolean isParallelized() {
        return this.parallelized;
    }

    @ZenMethod
    public RecipePrimer setParallelized(boolean isParallelized) {
        this.parallelized = isParallelized;
        return this;
    }

    @Override
    public int getMaxThreads() {
        return this.maxThreads;
    }

    @ZenMethod
    public RecipePrimer setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @ZenMethod
    public RecipePrimer setThreadName(String name) {
        this.threadName = name == null ? "" : name;
        return this;
    }

    @Override
    public void loadNeedAfterInitActions() {
        for (Action needAfterInitAction : this.needAfterInitActions) {
            needAfterInitAction.doAction();
        }
    }

    @Override
    public boolean getLoadJEI() {
        return this.loadJEI;
    }

    @ZenMethod
    public RecipePrimer setLoadJEI(boolean load) {
        this.loadJEI = load;
        return this;
    }
}

