/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.RecipePrimer;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.RecipeAdapterBuilder")
public class RecipeAdapterBuilder
extends RecipePrimer {
    protected final List<RecipeModifier> modifiers = new LinkedList<RecipeModifier>();
    protected final ResourceLocation parentMachineName;

    private RecipeAdapterBuilder(ResourceLocation machineName, ResourceLocation parentMachineName) {
        super(null, machineName, 0, 0, false);
        this.parentMachineName = parentMachineName;
    }

    @ZenMethod
    public static RecipeAdapterBuilder create(String machineName, String parentMachineName) {
        ResourceLocation machineLoc = new ResourceLocation(machineName);
        if (machineLoc.func_110624_b().equals("minecraft")) {
            machineLoc = new ResourceLocation("modularmachinery", machineLoc.func_110623_a());
        }
        return new RecipeAdapterBuilder(machineLoc, new ResourceLocation(parentMachineName));
    }

    @ZenMethod
    public RecipeAdapterBuilder addModifier(RecipeModifier modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    public List<RecipeModifier> getModifiers() {
        return this.modifiers;
    }

    public ResourceLocation getAdapterParentMachineName() {
        return this.parentMachineName;
    }

    @Override
    public void build() {
        RecipeRegistry.getRegistry().registerRecipeAdapterEarly(this);
    }

    @Override
    public RecipePrimer setParallelized(boolean isParallelized) {
        CraftTweakerAPI.logWarning((String)"[ModularMachinery] RecipeAdapterBuilder cannot set parallelized, it depends on the parent machine recipe!");
        return this;
    }
}

