/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.client.model.DynamicMachineModelRegistry;
import github.kasuminova.mmce.client.model.MachineControllerModel;
import github.kasuminova.mmce.common.util.concurrent.Action;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.machine.factory.FactoryRecipeThread;
import hellfirepvp.modularmachinery.common.util.SmartInterfaceType;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.MachineModifier")
public class MachineModifier {
    public static final List<Action> WAIT_FOR_MODIFY = new LinkedList<Action>();

    @ZenMethod
    public static void addSmartInterfaceType(String machineName, SmartInterfaceType type) {
        WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineName));
            if (machine == null) {
                CraftTweakerAPI.logError((String)("Could not find machine `" + machineName + "`!"));
                return;
            }
            if (!machine.hasSmartInterfaceType(type.getType())) {
                machine.addSmartInterfaceType(type);
            } else {
                CraftTweakerAPI.logWarning((String)("[ModularMachinery] DynamicMachine `" + machine.getRegistryName() + "` is already has SmartInterfaceType `" + type.getType() + "`!"));
            }
        });
    }

    @ZenMethod
    public static void setMaxParallelism(String machineName, int maxParallelism) {
        if (maxParallelism < 1) {
            CraftTweakerAPI.logError((String)"Max Parallelism must larger than 1!");
        }
        WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineName));
            if (machine == null) {
                CraftTweakerAPI.logError((String)("Could not find machine `" + machineName + "`!"));
                return;
            }
            machine.setMaxParallelism(maxParallelism);
        });
    }

    @ZenMethod
    public static void setInternalParallelism(String machineName, int parallelism) {
        if (parallelism < 0) {
            CraftTweakerAPI.logError((String)"Max Parallelism must larger than 0!");
        }
        WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineName));
            if (machine == null) {
                CraftTweakerAPI.logError((String)("Could not find machine `" + machineName + "`!"));
                return;
            }
            machine.setInternalParallelism(parallelism);
        });
    }

    @ZenMethod
    public static void setMaxThreads(String machineName, int maxThreads) {
        if (maxThreads < 0) {
            CraftTweakerAPI.logError((String)"Max Threads must larger than or equal 0!");
        }
        WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineName));
            if (machine == null) {
                CraftTweakerAPI.logError((String)("Could not find machine `" + machineName + "`!"));
                return;
            }
            machine.setMaxThreads(maxThreads);
        });
    }

    @ZenMethod
    public static void addCoreThread(String machineName, FactoryRecipeThread thread) {
        WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineName));
            if (machine == null) {
                CraftTweakerAPI.logError((String)("Could not find machine `" + machineName + "`!"));
                return;
            }
            machine.addCoreThread(thread);
        });
    }

    @ZenMethod
    public static void setMachineGeoModel(String machineName, String modelName) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            return;
        }
        WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineName));
            if (machine == null) {
                CraftTweakerAPI.logError((String)("Could not find machine `" + machineName + "`!"));
                return;
            }
            MachineControllerModel model = DynamicMachineModelRegistry.INSTANCE.getMachineModel(modelName);
            if (model == null) {
                CraftTweakerAPI.logError((String)("Could not find geo model `" + modelName + "`!"));
                return;
            }
            DynamicMachineModelRegistry.INSTANCE.registerMachineDefaultModel(machine, model);
        });
    }

    @ZenMethod
    public static void setMachinePrefix(String machineName, String prefixName) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            return;
        }
        WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineName));
            if (machine == null) {
                CraftTweakerAPI.logError((String)("Could not find machine `" + machineName + "`!"));
                return;
            }
            machine.setPrefix(prefixName);
        });
    }

    public static void loadAll() {
        for (Action waitForRegister : WAIT_FOR_MODIFY) {
            waitForRegister.doAction();
        }
        WAIT_FOR_MODIFY.clear();
    }
}

