/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import github.kasuminova.mmce.common.itemtype.ChancedIngredientStack;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.helper.AdvancedItemCheckerCT;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.helper.AdvancedItemModifierCT;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.IngredientArrayPrimer")
public class IngredientArrayPrimer {
    private final ArrayList<ChancedIngredientStack> ingredientStackList = new ArrayList();
    private ChancedIngredientStack lastIngredientStack = null;

    @ZenMethod
    public IngredientArrayPrimer addIngredient(IIngredient input) {
        if (input instanceof IItemStack) {
            IItemStack stackCT = (IItemStack)input;
            ItemStack stackMC = CraftTweakerMC.getItemStack((IIngredient)input);
            if (stackMC.func_190926_b()) {
                CraftTweakerAPI.logError((String)("[ModularMachinery] ItemStack not found/unknown item: " + stackMC));
                return this;
            }
            ChancedIngredientStack ingredientStack = new ChancedIngredientStack(stackMC);
            if (stackCT.getTag().length() > 0) {
                ingredientStack.tag = CraftTweakerMC.getNBTCompound((IData)stackCT.getTag());
            }
            this.addIngredient(ingredientStack);
        } else if (input instanceof IOreDictEntry) {
            this.addIngredient(new ChancedIngredientStack(((IOreDictEntry)input).getName(), 1));
        } else if (input instanceof IngredientStack && input.getInternal() instanceof IOreDictEntry) {
            this.addIngredient(new ChancedIngredientStack(((IOreDictEntry)input.getInternal()).getName(), input.getAmount()));
        }
        return this;
    }

    @ZenMethod
    public IngredientArrayPrimer addIngredients(IIngredient ... inputs) {
        for (IIngredient input : inputs) {
            this.addIngredient(input);
        }
        return this;
    }

    @ZenMethod
    public IngredientArrayPrimer addChancedIngredient(IIngredient input, float chance) {
        this.addIngredient(input);
        this.setChance(chance);
        return this;
    }

    @ZenMethod
    public IngredientArrayPrimer setMinMaxAmount(int min, int max) {
        if (this.lastIngredientStack != null) {
            if (min < max) {
                this.lastIngredientStack.minCount = min;
                this.lastIngredientStack.maxCount = max;
            } else {
                CraftTweakerAPI.logWarning((String)"[ModularMachinery] `min` cannot larger than `max`!");
            }
        }
        return this;
    }

    @ZenMethod
    public IngredientArrayPrimer setChance(float chance) {
        if (this.lastIngredientStack != null) {
            this.lastIngredientStack.chance = chance;
        }
        return this;
    }

    @ZenMethod
    public IngredientArrayPrimer setChecker(AdvancedItemCheckerCT checker) {
        if (this.lastIngredientStack != null) {
            this.lastIngredientStack.itemChecker = (controller, stack) -> checker.isMatch(controller, CraftTweakerMC.getIItemStack((ItemStack)stack));
        }
        return this;
    }

    @ZenMethod
    public IngredientArrayPrimer addItemModifier(AdvancedItemModifierCT modifier) {
        if (this.lastIngredientStack != null) {
            this.lastIngredientStack.itemModifierList.add((controller, stack) -> CraftTweakerMC.getItemStack((IItemStack)modifier.apply(controller, CraftTweakerMC.getIItemStackMutable((ItemStack)stack))));
        }
        return this;
    }

    @ZenMethod
    @Deprecated
    public IngredientArrayPrimer build() {
        CraftTweakerAPI.logWarning((String)"[ModularMachinery] IngredientArrayPrimer#build is deprecated, it will be removed in future version.");
        return this;
    }

    public ArrayList<ChancedIngredientStack> getIngredientStackList() {
        return this.ingredientStackList;
    }

    private void addIngredient(ChancedIngredientStack input) {
        this.ingredientStackList.add(input);
        this.lastIngredientStack = input;
    }
}

