/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.crafttweaker;

import com.google.gson.JsonParseException;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentSelectorTag;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.helper.AdvancedBlockCheckerCT;
import hellfirepvp.modularmachinery.common.machine.TaggedPositionBlockArray;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.IBlockStateDescriptor;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.BlockArrayBuilder")
public class BlockArrayBuilder {
    private final TaggedPositionBlockArray blockArray;
    private BlockArray.BlockInformation lastInformation = null;
    private BlockPos lastPos = null;

    private BlockArrayBuilder() {
        this.blockArray = new TaggedPositionBlockArray();
    }

    private BlockArrayBuilder(TaggedPositionBlockArray blockArray) {
        this.blockArray = blockArray;
    }

    @ZenMethod
    public static BlockArrayBuilder newBuilder() {
        return new BlockArrayBuilder();
    }

    @ZenMethod
    public static BlockArrayBuilder newBuilder(TaggedPositionBlockArray blockArray) {
        return new BlockArrayBuilder(blockArray);
    }

    @ZenMethod
    public BlockArrayBuilder addBlock(int x, int y, int z, crafttweaker.api.block.IBlockState ... ctBlockStates) {
        ArrayList<IBlockState> stateList = new ArrayList<IBlockState>();
        for (crafttweaker.api.block.IBlockState ctBlockState : ctBlockStates) {
            stateList.add(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)ctBlockState));
        }
        ArrayList<IBlockStateDescriptor> stateDescriptorList = new ArrayList<IBlockStateDescriptor>();
        for (IBlockState blockState : stateList) {
            stateDescriptorList.add(IBlockStateDescriptor.of(blockState));
        }
        this.addBlock(new BlockPos(x, y, z), new BlockArray.BlockInformation(stateDescriptorList));
        return this;
    }

    @ZenMethod
    public BlockArrayBuilder addBlock(int[] xList, int[] yList, int[] zList, @Nullable IData nbt, @Nullable IData previewNBT, @Nullable AdvancedBlockCheckerCT checker, crafttweaker.api.block.IBlockState ... ctBlockStates) {
        for (int x : xList) {
            for (int y : yList) {
                for (int z : zList) {
                    this.addBlock(x, y, z, ctBlockStates);
                    if (nbt != null) {
                        this.setNBT(nbt);
                    }
                    if (previewNBT != null) {
                        this.setPreviewNBT(previewNBT);
                    }
                    if (checker == null) continue;
                    this.setBlockChecker(checker);
                }
            }
        }
        return this;
    }

    @ZenMethod
    public BlockArrayBuilder addBlock(int[] xList, int[] yList, int[] zList, IData nbt, IData previewNBT, crafttweaker.api.block.IBlockState ... ctBlockStates) {
        this.addBlock(xList, yList, zList, nbt, previewNBT, (AdvancedBlockCheckerCT)null, ctBlockStates);
        return this;
    }

    @ZenMethod
    public BlockArrayBuilder addBlock(int[] xList, int[] yList, int[] zList, AdvancedBlockCheckerCT checker, crafttweaker.api.block.IBlockState ... ctBlockStates) {
        this.addBlock(xList, yList, zList, null, null, checker, ctBlockStates);
        return this;
    }

    @ZenMethod
    public BlockArrayBuilder addBlock(int[] xList, int[] yList, int[] zList, crafttweaker.api.block.IBlockState ... ctBlockStates) {
        return this.addBlock(xList, yList, zList, (IData)null, (IData)null, (AdvancedBlockCheckerCT)null, ctBlockStates);
    }

    @ZenMethod
    public BlockArrayBuilder addBlock(int x, int y, int z, IItemStack ... ctItemStacks) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (IItemStack ctItemStack : ctItemStacks) {
            stackList.add(CraftTweakerMC.getItemStack((IItemStack)ctItemStack));
        }
        ArrayList<IBlockStateDescriptor> stateDescriptorList = new ArrayList<IBlockStateDescriptor>();
        for (ItemStack stack : stackList) {
            Item item = stack.func_77973_b();
            int meta = stack.func_77960_j();
            Block block = Block.func_149634_a((Item)item);
            if (block != Blocks.field_150350_a) {
                try {
                    IBlockState state = block.func_176203_a(meta);
                    stateDescriptorList.add(IBlockStateDescriptor.of(state));
                }
                catch (Exception e) {
                    CraftTweakerAPI.logError((String)String.format("[ModularMachinery] Failed to get BlockState from <%s>!", stack.func_77973_b().getRegistryName() + ":" + meta));
                }
                continue;
            }
            CraftTweakerAPI.logError((String)("[ModularMachinery] " + stack.func_82833_r() + " cannot convert to Block!"));
        }
        if (!stateDescriptorList.isEmpty()) {
            this.addBlock(new BlockPos(x, y, z), new BlockArray.BlockInformation(stateDescriptorList));
        }
        return this;
    }

    @ZenMethod
    public BlockArrayBuilder addBlock(int[] xList, int[] yList, int[] zList, @Nullable IData nbt, @Nullable IData previewNBT, @Nullable AdvancedBlockCheckerCT checker, IItemStack ... ctItemStacks) {
        for (int x : xList) {
            for (int y : yList) {
                for (int z : zList) {
                    this.addBlock(x, y, z, ctItemStacks);
                    if (nbt != null) {
                        this.setNBT(nbt);
                    }
                    if (previewNBT != null) {
                        this.setPreviewNBT(previewNBT);
                    }
                    if (checker == null) continue;
                    this.setBlockChecker(checker);
                }
            }
        }
        return this;
    }

    @ZenMethod
    public BlockArrayBuilder addBlock(int[] xList, int[] yList, int[] zList, IData nbt, IData previewNBT, IItemStack ... ctItemStacks) {
        this.addBlock(xList, yList, zList, nbt, previewNBT, (AdvancedBlockCheckerCT)null, ctItemStacks);
        return this;
    }

    @ZenMethod
    public BlockArrayBuilder addBlock(int[] xList, int[] yList, int[] zList, AdvancedBlockCheckerCT checker, IItemStack ... ctItemStacks) {
        this.addBlock(xList, yList, zList, null, null, checker, ctItemStacks);
        return this;
    }

    @ZenMethod
    public BlockArrayBuilder addBlock(int[] xList, int[] yList, int[] zList, IItemStack ... ctItemStacks) {
        return this.addBlock(xList, yList, zList, (IData)null, (IData)null, (AdvancedBlockCheckerCT)null, ctItemStacks);
    }

    @ZenMethod
    public BlockArrayBuilder addBlock(int x, int y, int z, String ... blockNames) {
        ArrayList<IBlockStateDescriptor> stateDescriptorList = new ArrayList<IBlockStateDescriptor>();
        for (String blockName : blockNames) {
            try {
                stateDescriptorList.add(BlockArray.BlockInformation.getDescriptor(blockName));
            }
            catch (JsonParseException e) {
                CraftTweakerAPI.logError((String)("[ModularMachinery] " + blockName + " is invalid block!"), (Throwable)e);
            }
        }
        if (!stateDescriptorList.isEmpty()) {
            this.addBlock(new BlockPos(x, y, z), new BlockArray.BlockInformation(stateDescriptorList));
        }
        return this;
    }

    @ZenMethod
    public BlockArrayBuilder addBlock(int[] xList, int[] yList, int[] zList, @Nullable IData nbt, @Nullable IData previewNBT, @Nullable AdvancedBlockCheckerCT checker, String ... blockNames) {
        for (int x : xList) {
            for (int y : yList) {
                for (int z : zList) {
                    this.addBlock(x, y, z, blockNames);
                    if (nbt != null) {
                        this.setNBT(nbt);
                    }
                    if (previewNBT != null) {
                        this.setPreviewNBT(previewNBT);
                    }
                    if (checker == null) continue;
                    this.setBlockChecker(checker);
                }
            }
        }
        return this;
    }

    @ZenMethod
    public BlockArrayBuilder addBlock(int[] xList, int[] yList, int[] zList, IData nbt, IData previewNBT, String ... blockNames) {
        this.addBlock(xList, yList, zList, nbt, previewNBT, (AdvancedBlockCheckerCT)null, blockNames);
        return this;
    }

    @ZenMethod
    public BlockArrayBuilder addBlock(int[] xList, int[] yList, int[] zList, AdvancedBlockCheckerCT checker, String ... blockNames) {
        this.addBlock(xList, yList, zList, null, null, checker, blockNames);
        return this;
    }

    @ZenMethod
    public BlockArrayBuilder addBlock(int[] xList, int[] yList, int[] zList, String ... blockNames) {
        return this.addBlock(xList, yList, zList, (IData)null, (IData)null, (AdvancedBlockCheckerCT)null, blockNames);
    }

    @ZenMethod
    public BlockArrayBuilder setNBT(IData data) {
        if (this.lastInformation != null) {
            NBTTagCompound tag = CraftTweakerMC.getNBTCompound((IData)data);
            this.lastInformation.setMatchingTag(tag);
            if (this.lastInformation.getPreviewTag() == null) {
                this.lastInformation.setPreviewTag(tag);
            }
        }
        return this;
    }

    @ZenMethod
    public BlockArrayBuilder setPreviewNBT(IData data) {
        if (this.lastInformation != null) {
            this.lastInformation.setPreviewTag(CraftTweakerMC.getNBTCompound((IData)data));
        }
        return this;
    }

    @ZenMethod
    public BlockArrayBuilder setBlockChecker(AdvancedBlockCheckerCT checker) {
        if (this.lastInformation != null) {
            this.lastInformation.setNBTChecker((world, pos, blockState, nbt) -> checker.isMatch(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockState((IBlockState)blockState), CraftTweakerMC.getIData((NBTBase)nbt)));
        }
        return this;
    }

    @ZenMethod
    public BlockArrayBuilder setTag(String tag) {
        if (this.lastInformation != null && this.lastPos != null) {
            this.blockArray.setTag(this.lastPos, new ComponentSelectorTag(tag));
        }
        return this;
    }

    @ZenMethod
    public TaggedPositionBlockArray getBlockArray() {
        return this.blockArray;
    }

    private void addBlock(BlockPos pos, BlockArray.BlockInformation information) {
        this.blockArray.addBlock(pos, information);
        this.lastInformation = information;
        this.lastPos = pos;
    }
}

