/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.data;

import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.data.Config;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.IOUtils;

public class ModDataHolder {
    private File mainDir;
    private File machineryDir;
    private File recipeDir;
    private boolean requiresDefaultMachinery;

    public void setup(File configDir) {
        this.mainDir = new File(configDir, "modularmachinery");
        if (!this.mainDir.exists()) {
            this.requiresDefaultMachinery = true;
            this.mainDir.mkdirs();
        }
        this.machineryDir = new File(this.mainDir, "machinery");
        if (!this.machineryDir.exists()) {
            this.machineryDir.mkdirs();
        }
        this.recipeDir = new File(this.mainDir, "recipes");
        if (!this.recipeDir.exists()) {
            this.recipeDir.mkdirs();
        }
        Config.loadFrom(new File(this.mainDir, "modularmachinery.cfg"));
    }

    public boolean requiresDefaultMachinery() {
        boolean old = this.requiresDefaultMachinery;
        this.requiresDefaultMachinery = false;
        return old;
    }

    public File getMachineryDirectory() {
        return this.machineryDir;
    }

    public File getRecipeDirectory() {
        return this.recipeDir;
    }

    public void copyDefaultMachinery() {
        this.copy("default_machinery", this.machineryDir);
        this.copy("default_recipes", this.recipeDir);
        File defaultVariableDir = new File(this.machineryDir, "variables");
        if (!defaultVariableDir.exists()) {
            defaultVariableDir.mkdirs();
        }
        this.copy("default_variables", defaultVariableDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copy(String assetDirFrom, File directoryTo) {
        Iterator itr;
        Path root;
        FileSystem fs;
        block22: {
            ModContainer active;
            ModContainer thisMod = (ModContainer)Loader.instance().getIndexedModList().get("modularmachinery");
            if (thisMod == null && (active = Loader.instance().activeModContainer()) != null && active.getModId().equalsIgnoreCase("modularmachinery")) {
                thisMod = active;
            }
            if (thisMod == null) {
                return;
            }
            fs = null;
            File modSource = thisMod.getSource();
            root = null;
            if (modSource.isFile()) {
                try {
                    fs = FileSystems.newFileSystem(modSource.toPath(), null);
                    root = fs.getPath("/assets/modularmachinery/" + assetDirFrom, new String[0]);
                }
                catch (IOException e) {
                    ModularMachinery.log.error("Error loading FileSystem from jar: ", (Throwable)e);
                    IOUtils.closeQuietly((Closeable)fs);
                    return;
                }
            } else if (modSource.isDirectory()) {
                root = modSource.toPath().resolve("assets/modularmachinery/" + assetDirFrom);
            }
            if (root != null && Files.exists(root, new LinkOption[0])) break block22;
            IOUtils.closeQuietly((Closeable)fs);
            return;
        }
        try {
            itr = Files.walk(root, new FileVisitOption[0]).iterator();
        }
        catch (IOException e) {
            ModularMachinery.log.error("Error iterating through " + assetDirFrom + " Skipping copying default setup!", (Throwable)e);
            IOUtils.closeQuietly((Closeable)fs);
            return;
        }
        try {
            while (itr.hasNext()) {
                Path filePath = (Path)itr.next();
                if (!filePath.getFileName().toString().endsWith(".json")) continue;
                File target = new File(directoryTo, filePath.getFileName().toString());
                try (FileOutputStream fos = new FileOutputStream(target);){
                    Files.copy(filePath, fos);
                }
                catch (Exception exc) {
                    ModularMachinery.log.error("Couldn't copy file from " + filePath);
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fs);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fs);
    }
}

