/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.tooltip;

import hellfirepvp.modularmachinery.client.util.EnergyDisplayUtil;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.tooltip.RequirementTip;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;

public class TooltipEnergyOutput
extends RequirementTip {
    @Override
    @Nonnull
    public Collection<ComponentRequirement<?, ?>> filterRequirements(MachineRecipe recipe, Collection<ComponentRequirement<?, ?>> requirements) {
        return requirements.stream().filter(RequirementEnergy.class::isInstance).filter(r -> r.getActionType() == IOType.OUTPUT).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public List<String> buildTooltip(MachineRecipe recipe, Collection<ComponentRequirement<?, ?>> filteredComponents) {
        long totalEnergyOut = 0L;
        for (ComponentRequirement<?, ?> energy : filteredComponents) {
            totalEnergyOut += ((RequirementEnergy)energy).getRequiredEnergyPerTick();
        }
        ArrayList<String> tooltip = new ArrayList<String>(3);
        if (totalEnergyOut > 0L) {
            String energyType = I18n.func_135052_a((String)EnergyDisplayUtil.type.getUnlocalizedFormat(), (Object[])new Object[0]);
            long energyOut = EnergyDisplayUtil.type.formatEnergyForDisplay(totalEnergyOut);
            tooltip.add(I18n.func_135052_a((String)"tooltip.machinery.energy.out", (Object[])new Object[0]) + I18n.func_135052_a((String)"tooltip.machinery.energy.tick", (Object[])new Object[]{MiscUtils.formatNumber(energyOut), energyType}));
            tooltip.add(I18n.func_135052_a((String)"tooltip.machinery.energy.total", (Object[])new Object[]{MiscUtils.formatNumber(energyOut * (long)recipe.getRecipeTotalTickTime()), energyType}));
        }
        return tooltip;
    }
}

