/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirement.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import github.kasuminova.mmce.common.itemtype.ChancedIngredientStack;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementIngredientArray;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.util.nbt.NBTJsonDeserializer;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class RequirementTypeIngredientArray
extends RequirementType<ItemStack, RequirementIngredientArray> {
    public RequirementIngredientArray createRequirement(IOType type, JsonObject jsonObject) {
        if (!jsonObject.has("items") && !jsonObject.get("items").isJsonArray()) {
            throw new JsonParseException("'items' must be a item array or must be exists!");
        }
        JsonArray items = jsonObject.getAsJsonArray("items");
        ArrayList<ChancedIngredientStack> itemArray = new ArrayList<ChancedIngredientStack>(items.size());
        for (JsonElement itemJsonElement : items) {
            ChancedIngredientStack ingredientStack;
            if (!itemJsonElement.isJsonObject()) {
                throw new JsonParseException("The ComponentType 'item' expects an 'item'-entry that defines the item!");
            }
            JsonObject subItem = itemJsonElement.getAsJsonObject();
            String itemDefinition = subItem.getAsJsonPrimitive("item").getAsString();
            ResourceLocation res = new ResourceLocation(itemDefinition);
            int meta = 0;
            int indexMeta = itemDefinition.indexOf(64);
            if (indexMeta != -1 && indexMeta != itemDefinition.length() - 1) {
                try {
                    meta = Integer.parseInt(itemDefinition.substring(indexMeta + 1));
                }
                catch (NumberFormatException exc) {
                    throw new JsonParseException("Expected a metadata number, got " + itemDefinition.substring(indexMeta + 1), (Throwable)exc);
                }
            }
            int amount = 1;
            if (jsonObject.has("amount")) {
                if (!jsonObject.get("amount").isJsonPrimitive() || !jsonObject.getAsJsonPrimitive("amount").isNumber()) {
                    throw new JsonParseException("'amount', if defined, needs to be a amount-number!");
                }
                amount = MathHelper.func_76125_a((int)jsonObject.getAsJsonPrimitive("amount").getAsInt(), (int)1, (int)64);
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(res);
            if (res.func_110624_b().equalsIgnoreCase("ore")) {
                ingredientStack = new ChancedIngredientStack(itemDefinition.substring(4), amount);
            } else {
                if (item == null || item == Items.field_190931_a) {
                    throw new JsonParseException("Couldn't find item with registryName '" + res + "' !");
                }
                ItemStack stack = meta > 0 ? new ItemStack(item, amount, meta) : new ItemStack(item, amount);
                ingredientStack = new ChancedIngredientStack(stack);
            }
            if (jsonObject.has("chance")) {
                if (!jsonObject.get("chance").isJsonPrimitive() || !jsonObject.getAsJsonPrimitive("chance").isNumber()) {
                    throw new JsonParseException("'chance', if defined, needs to be a chance-number between 0 and 1!");
                }
                float chance = jsonObject.getAsJsonPrimitive("chance").getAsFloat();
                if (chance >= 0.0f && chance <= 1.0f) {
                    ingredientStack.chance = chance;
                }
            }
            if (jsonObject.has("nbt")) {
                if (!jsonObject.has("nbt") || !jsonObject.get("nbt").isJsonObject()) {
                    throw new JsonParseException("The ComponentType 'nbt' expects a json compound that defines the NBT tag!");
                }
                String nbtString = jsonObject.getAsJsonObject("nbt").toString();
                try {
                    ingredientStack.tag = NBTJsonDeserializer.deserialize(nbtString);
                }
                catch (NBTException exc) {
                    throw new JsonParseException("Error trying to parse NBTTag! Rethrowing exception...", (Throwable)exc);
                }
            }
            itemArray.add(ingredientStack);
        }
        RequirementIngredientArray req = new RequirementIngredientArray(itemArray);
        if (jsonObject.has("chance")) {
            if (!jsonObject.get("chance").isJsonPrimitive() || !jsonObject.getAsJsonPrimitive("chance").isNumber()) {
                throw new JsonParseException("'chance', if defined, needs to be a chance-number between 0 and 1!");
            }
            float chance = jsonObject.getAsJsonPrimitive("chance").getAsFloat();
            if (chance >= 0.0f && chance <= 1.0f) {
                req.setChance(chance);
            }
        }
        return req;
    }
}

