/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirement.jei;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.integration.ingredient.IngredientItemStack;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutPart;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.awt.Point;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class JEIComponentItem
extends ComponentRequirement.JEIComponent<ItemStack> {
    private final RequirementItem requirement;

    public JEIComponentItem(RequirementItem requirement) {
        this.requirement = requirement;
    }

    public static void addFuelTooltip(ItemStack ingredient, List<String> tooltip) {
        int burn = TileEntityFurnace.func_145952_a((ItemStack)ingredient);
        if (burn > 0) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.machinery.fuel.item", (Object[])new Object[]{burn}));
        }
        tooltip.add(I18n.func_135052_a((String)"tooltip.machinery.fuel", (Object[])new Object[0]));
    }

    public static void addChanceTooltip(boolean input, List<String> tooltip, float chance) {
        if (chance < 1.0f && chance >= 0.0f) {
            String keyChance;
            String keyNever = input ? "tooltip.machinery.chance.in.never" : "tooltip.machinery.chance.out.never";
            String string = keyChance = input ? "tooltip.machinery.chance.in" : "tooltip.machinery.chance.out";
            if (chance == 0.0f) {
                tooltip.add(I18n.func_135052_a((String)keyNever, (Object[])new Object[0]));
            } else {
                String chanceStr = chance < 1.0E-4f ? "< 0.01%" : MiscUtils.formatFloat(chance * 100.0f, 2) + "%";
                tooltip.add(I18n.func_135052_a((String)keyChance, (Object[])new Object[]{chanceStr}));
            }
        }
    }

    @Override
    public Class<ItemStack> getJEIRequirementClass() {
        return ItemStack.class;
    }

    @Override
    public List<ItemStack> getJEIIORequirements() {
        return Lists.transform(this.requirement.cachedJEIIORequirementList, ingredient -> ingredient == null ? null : ingredient.stack());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RecipeLayoutPart<ItemStack> getLayoutPart(Point offset) {
        return new RecipeLayoutPart.Item(offset);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onJEIHoverTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        if (this.requirement.requirementType == RequirementItem.ItemRequirementType.FUEL) {
            JEIComponentItem.addFuelTooltip(ingredient, tooltip);
        }
        JEIComponentItem.addChanceTooltip(input, tooltip, this.requirement.chance);
        this.addMinMaxTooltip(input, tooltip);
    }

    public void addMinMaxTooltip(boolean input, List<String> tooltip) {
        if (this.requirement.minAmount != this.requirement.maxAmount) {
            String key = input ? "tooltip.machinery.min_max_amount.input" : "tooltip.machinery.min_max_amount.output";
            tooltip.add(I18n.func_135052_a((String)key, (Object[])new Object[]{this.requirement.minAmount, this.requirement.maxAmount}));
        }
    }

    public static class IngredientItemStackTransformer
    implements Function<ItemStack, IngredientItemStack> {
        public static final IngredientItemStackTransformer INSTANCE = new IngredientItemStackTransformer();

        private IngredientItemStackTransformer() {
        }

        @Nullable
        public IngredientItemStack apply(@Nullable ItemStack input) {
            return input == null ? null : new IngredientItemStack(input, input.func_190916_E(), input.func_190916_E(), 1.0f);
        }
    }
}

