/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirement.jei;

import com.google.common.collect.Lists;
import github.kasuminova.mmce.common.itemtype.ChancedIngredientStack;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementIngredientArray;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutPart;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.awt.Point;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class JEIComponentIngredientArray
extends ComponentRequirement.JEIComponent<ItemStack> {
    public final RequirementIngredientArray requirement;

    public JEIComponentIngredientArray(RequirementIngredientArray requirement) {
        this.requirement = requirement;
    }

    @Override
    public Class<ItemStack> getJEIRequirementClass() {
        return ItemStack.class;
    }

    @Override
    public List<ItemStack> getJEIIORequirements() {
        return Lists.transform(this.requirement.cachedJEIIORequirementList, ingredientItemStack -> ingredientItemStack == null ? null : ingredientItemStack.stack());
    }

    @Override
    public RecipeLayoutPart<ItemStack> getLayoutPart(Point offset) {
        return new RecipeLayoutPart.Item(offset);
    }

    @Override
    public void onJEIHoverTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        float f;
        tooltip.add("");
        IOType actionType = this.requirement.getActionType();
        switch (actionType) {
            case INPUT: {
                tooltip.add(I18n.func_135052_a((String)"tooltip.machinery.ingredient_array_input", (Object[])new Object[0]));
                break;
            }
            case OUTPUT: {
                tooltip.add(I18n.func_135052_a((String)"tooltip.machinery.ingredient_array_output", (Object[])new Object[0]));
            }
        }
        float totalChance = 1.0f;
        if (actionType == IOType.OUTPUT) {
            totalChance = 0.0f;
            for (ChancedIngredientStack chancedIngredientStack : this.requirement.getIngredients()) {
                totalChance += chancedIngredientStack.chance;
            }
        }
        StringBuilder tooltipBuilder = new StringBuilder();
        for (ChancedIngredientStack stack : this.requirement.getIngredients()) {
            float chance2;
            switch (stack.ingredientType) {
                case ITEMSTACK: {
                    tooltipBuilder.append(stack.itemStack.func_82833_r());
                    break;
                }
                case ORE_DICT: {
                    tooltipBuilder.append(stack.oreDictName);
                }
            }
            if (stack.minCount != stack.maxCount) {
                tooltipBuilder.append(" * ").append(String.format("%d ~ %d", stack.minCount, stack.maxCount));
            } else {
                tooltipBuilder.append(" * ").append(stack.count);
            }
            if (input) {
                tooltip.add(tooltipBuilder.toString());
                tooltipBuilder.setLength(0);
                continue;
            }
            float f2 = chance2 = totalChance == 0.0f ? 0.0f : stack.chance / totalChance;
            if (chance2 < 1.0f && chance2 >= 0.0f) {
                tooltipBuilder.append(" (");
                String keyNever = "tooltip.machinery.chance.out.never";
                String keyChance = "tooltip.machinery.ingredient_array_output.weight";
                if (chance2 == 0.0f) {
                    tooltipBuilder.append(I18n.func_135052_a((String)keyNever, (Object[])new Object[0]));
                } else {
                    String chanceStr = chance2 < 1.0E-4f ? "< 0.01%" : MiscUtils.formatFloat(chance2 * 100.0f, 2) + "%";
                    tooltipBuilder.append(I18n.func_135052_a((String)keyChance, (Object[])new Object[]{chanceStr}));
                }
                tooltipBuilder.append(")");
            }
            tooltip.add(tooltipBuilder.toString());
            tooltipBuilder.setLength(0);
        }
        if (input && (f = this.requirement.chance) < 1.0f && f >= 0.0f) {
            if (f <= 0.0f) {
                tooltip.add(I18n.func_135052_a((String)"tooltip.machinery.chance.in.never", (Object[])new Object[0]));
            } else {
                String chanceStr = f < 1.0E-4f ? "< 0.01%" : MiscUtils.formatFloat(f * 100.0f, 2) + "%";
                tooltip.add(I18n.func_135052_a((String)"tooltip.machinery.chance.in", (Object[])new Object[]{chanceStr}));
            }
        }
    }
}

