/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirement;

import github.kasuminova.mmce.common.concurrent.Sync;
import github.kasuminova.mmce.common.helper.AdvancedItemChecker;
import github.kasuminova.mmce.common.helper.AdvancedItemModifier;
import github.kasuminova.mmce.common.itemtype.ChancedIngredientStack;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.crafting.requirement.jei.JEIComponentIngredientArray;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementTypeIngredientArray;
import hellfirepvp.modularmachinery.common.integration.ingredient.IngredientItemStack;
import hellfirepvp.modularmachinery.common.lib.ComponentTypesMM;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class RequirementIngredientArray
extends ComponentRequirement.MultiCompParallelizable<ItemStack, RequirementTypeIngredientArray>
implements ComponentRequirement.ChancedRequirement {
    protected final List<ChancedIngredientStack> ingredients;
    public List<IngredientItemStack> cachedJEIIORequirementList = null;
    public float chance = 1.0f;

    public RequirementIngredientArray(List<ChancedIngredientStack> ingredients) {
        super(RequirementTypesMM.REQUIREMENT_INGREDIENT_ARRAY, IOType.INPUT);
        this.ingredients = ingredients;
    }

    public RequirementIngredientArray(List<ChancedIngredientStack> ingredients, IOType ioType) {
        super(RequirementTypesMM.REQUIREMENT_INGREDIENT_ARRAY, ioType);
        this.ingredients = ingredients;
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.component();
        ComponentType cmpType = cmp.getComponentType();
        return (cmpType.equals((Object)ComponentTypesMM.COMPONENT_ITEM) || cmpType.equals((Object)ComponentTypesMM.COMPONENT_ITEM_FLUID_GAS)) && cmp.ioType == this.actionType;
    }

    public RequirementIngredientArray deepCopy() {
        return this.deepCopyModified(Collections.emptyList());
    }

    public RequirementIngredientArray deepCopyModified(List<RecipeModifier> modifiers) {
        ArrayList<ChancedIngredientStack> copiedIngredients = new ArrayList<ChancedIngredientStack>();
        this.ingredients.forEach(item -> {
            ChancedIngredientStack copied = item.copy();
            switch (copied.ingredientType) {
                case ITEMSTACK: {
                    ItemStack itemStack = copied.itemStack;
                    int amt = Math.round(RecipeModifier.applyModifiers((Collection<RecipeModifier>)modifiers, RequirementTypesMM.REQUIREMENT_ITEM, this.actionType, (float)itemStack.func_190916_E(), false));
                    itemStack.func_190920_e(amt);
                    break;
                }
                case ORE_DICT: {
                    copied.count = Math.round(RecipeModifier.applyModifiers((Collection<RecipeModifier>)modifiers, RequirementTypesMM.REQUIREMENT_ITEM, this.actionType, (float)item.count, false));
                }
            }
            copied.chance = RecipeModifier.applyModifiers((Collection<RecipeModifier>)modifiers, RequirementTypesMM.REQUIREMENT_ITEM, this.actionType, item.chance, true);
            copiedIngredients.add(copied);
        });
        RequirementIngredientArray requirement = new RequirementIngredientArray((List<ChancedIngredientStack>)copiedIngredients, this.getActionType());
        requirement.chance = RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ITEM, this.actionType, this.chance, true);
        return requirement;
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        ResourceLocation compKey = RequirementTypesMM.KEY_REQUIREMENT_ITEM;
        return String.format("component.missing.%s.%s.%s", compKey.func_110624_b(), compKey.func_110623_a(), ioType.name().toLowerCase());
    }

    @Override
    public ComponentRequirement.JEIComponent<ItemStack> provideJEIComponent() {
        return new JEIComponentIngredientArray(this);
    }

    @Override
    public void initializeJEIRequirements() {
        this.cachedJEIIORequirementList = this.asJEIIORequirementList();
    }

    public List<IngredientItemStack> asJEIIORequirementList() {
        ArrayList<IngredientItemStack> copiedIngredients = new ArrayList<IngredientItemStack>();
        for (ChancedIngredientStack ingredient : this.getIngredients()) {
            switch (ingredient.ingredientType) {
                case ITEMSTACK: {
                    ItemStack itemStack = ingredient.itemStack;
                    ItemStack copiedStack = ItemUtils.copyStackWithSize(itemStack, itemStack.func_190916_E());
                    if (ingredient.minCount != ingredient.maxCount) {
                        copiedStack.func_190920_e(ingredient.maxCount);
                    }
                    copiedIngredients.add(ingredient.asIngredientItemStack(copiedStack));
                    break;
                }
                case ORE_DICT: {
                    NonNullList stacks = OreDictionary.getOres((String)ingredient.oreDictName);
                    NonNullList out = NonNullList.func_191196_a();
                    for (ItemStack oreDictIn : stacks) {
                        if (oreDictIn.func_77952_i() == Short.MAX_VALUE && !oreDictIn.func_77984_f() && oreDictIn.func_77973_b().func_77640_w() != null) {
                            oreDictIn.func_77973_b().func_150895_a(oreDictIn.func_77973_b().func_77640_w(), out);
                            continue;
                        }
                        out.add((Object)oreDictIn);
                    }
                    for (ItemStack itemStack : out) {
                        ItemStack copied = itemStack.func_77946_l();
                        if (ingredient.minCount != ingredient.maxCount) {
                            copied.func_190920_e(ingredient.maxCount);
                        } else {
                            copied.func_190920_e(ingredient.count);
                        }
                        copiedIngredients.add(ingredient.asIngredientItemStack(copied));
                    }
                    break;
                }
            }
        }
        return copiedIngredients;
    }

    @Override
    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    public void startCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (this.actionType == IOType.INPUT && chance.canWork(RecipeModifier.applyModifiers(context, RequirementTypesMM.REQUIREMENT_ITEM, this.actionType, this.chance, true))) {
            this.doItemIO(components, context, chance);
        }
    }

    @Override
    public void finishCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (this.actionType == IOType.OUTPUT && chance.canWork(RecipeModifier.applyModifiers(context, RequirementTypesMM.REQUIREMENT_ITEM, this.actionType, this.chance, true))) {
            this.doItemIO(components, context, chance);
        }
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        return this.doItemIO(components, context, ResultChance.GUARANTEED);
    }

    @Override
    public int getMaxParallelism(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxParallelism) {
        if (this.ignoreOutputCheck && this.actionType == IOType.OUTPUT) {
            return maxParallelism;
        }
        if (this.parallelizeUnaffected) {
            if (this.doItemIOInternal(components, context, 1, ResultChance.GUARANTEED) >= 1) {
                return maxParallelism;
            }
            return 0;
        }
        return this.doItemIOInternal(components, context, maxParallelism, ResultChance.GUARANTEED);
    }

    @Override
    @Nonnull
    public List<ProcessingComponent<?>> copyComponents(List<ProcessingComponent<?>> components) {
        return ItemUtils.copyItemHandlerComponents(components);
    }

    private CraftCheck doItemIO(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        int mul = this.doItemIOInternal(components, context, this.parallelism, chance);
        if (mul < this.parallelism) {
            return CraftCheck.failure("craftcheck.failure.item.input");
        }
        return CraftCheck.success();
    }

    private int doItemIOInternal(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxMultiplier, ResultChance chance) {
        int n;
        ArrayList<IItemHandlerModifiable> handlers = new ArrayList<IItemHandlerModifiable>();
        for (ProcessingComponent<?> component : components) {
            IItemHandlerModifiable providedComponent = (IItemHandlerModifiable)component.getProvidedComponent();
            handlers.add(providedComponent);
        }
        switch (this.actionType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case INPUT: {
                n = this.consumeAllItems(handlers, context, maxMultiplier, chance);
                break;
            }
            case OUTPUT: {
                if (this.ignoreOutputCheck) {
                    this.insertAllItems(handlers, context, maxMultiplier, chance);
                    n = maxMultiplier;
                    break;
                }
                n = this.insertAllItems(handlers, context, maxMultiplier, chance);
            }
        }
        return n;
    }

    public int consumeAllItems(List<IItemHandlerModifiable> handlers, RecipeCraftingContext context, int maxMultiplier, ResultChance chance) {
        int ingredientConsumed = 0;
        for (ChancedIngredientStack ingredient : this.ingredients) {
            int toConsume = this.applyModifierAmount(context, ingredient.count, ingredient.minCount, ingredient.maxCount, chance != ResultChance.GUARANTEED);
            int maxConsume = toConsume * (maxMultiplier - ingredientConsumed);
            AtomicInteger consumed = new AtomicInteger();
            block0 : switch (ingredient.ingredientType) {
                case ITEMSTACK: {
                    AdvancedItemChecker checker = ingredient.itemChecker;
                    ItemStack stack = ItemUtils.copyStackWithSize(ingredient.itemStack, toConsume);
                    for (IItemHandlerModifiable handler : handlers) {
                        Sync.executeSyncIfPresent(handler, () -> {
                            stack.func_190920_e(maxConsume - consumed.get());
                            if (checker != null) {
                                consumed.addAndGet(ItemUtils.consumeAll(handler, stack, checker, context.getMachineController()) / toConsume);
                            } else {
                                consumed.addAndGet(ItemUtils.consumeAll(handler, stack, ingredient.tag));
                            }
                        });
                        if (consumed.get() < maxConsume) continue;
                        break block0;
                    }
                    break;
                }
                case ORE_DICT: {
                    AdvancedItemChecker checker = ingredient.itemChecker;
                    for (IItemHandlerModifiable handler : handlers) {
                        Sync.executeSyncIfPresent(handler, () -> {
                            if (checker != null) {
                                consumed.addAndGet(ItemUtils.consumeAll(handler, ingredient.oreDictName, maxConsume - consumed.get(), checker, context.getMachineController()));
                            } else {
                                consumed.addAndGet(ItemUtils.consumeAll(handler, ingredient.oreDictName, maxConsume - consumed.get(), ingredient.tag));
                            }
                        });
                        if (consumed.get() < maxConsume) continue;
                        break block0;
                    }
                    break;
                }
            }
            ingredientConsumed += consumed.get() / toConsume;
        }
        return ingredientConsumed;
    }

    public int insertAllItems(List<IItemHandlerModifiable> handlers, RecipeCraftingContext context, int maxMultiplier, ResultChance chance) {
        ItemStack stack;
        ChancedIngredientStack selected;
        ChancedIngredientStack chancedIngredientStack = selected = chance == ResultChance.GUARANTEED ? this.selectMaxCountStack() : this.selectRandomStack();
        if (selected == null) {
            return 0;
        }
        AtomicInteger inserted = new AtomicInteger();
        int toInsert = this.applyModifierAmount(context, selected.count, selected.minCount, selected.maxCount, chance != ResultChance.GUARANTEED);
        if (toInsert <= 0) {
            return maxMultiplier;
        }
        NBTTagCompound tag = selected.tag;
        switch (selected.ingredientType) {
            case ITEMSTACK: {
                stack = ItemUtils.copyStackWithSize(selected.itemStack, 1);
                break;
            }
            case ORE_DICT: {
                stack = ItemUtils.getOredictItem(context, selected.oreDictName, tag);
                break;
            }
            default: {
                return 0;
            }
        }
        if (tag != null) {
            stack.func_77982_d(tag);
        }
        if (!selected.itemModifierList.isEmpty()) {
            for (AdvancedItemModifier modifier : selected.itemModifierList) {
                stack = modifier.apply(context.getMachineController(), stack);
            }
            if ((toInsert *= stack.func_190916_E()) <= 0) {
                return maxMultiplier;
            }
            stack.func_190920_e(1);
        }
        ItemStack finalStack = stack;
        int maxInsert = toInsert * maxMultiplier;
        for (IItemHandlerModifiable handler : handlers) {
            Sync.executeSyncIfPresent(handler, () -> inserted.addAndGet(ItemUtils.insertAll(finalStack, handler, maxInsert - inserted.get())));
            if (inserted.get() < maxInsert) continue;
            break;
        }
        return inserted.get() / toInsert;
    }

    protected int applyModifierAmount(RecipeCraftingContext context, int defaultCount, int minAmount, int maxAmount, boolean randomAmount) {
        if (randomAmount) {
            int amount = minAmount + RequirementItem.RD.nextInt(maxAmount - minAmount + 1);
            return Math.round(RecipeModifier.applyModifiers(context, RequirementTypesMM.REQUIREMENT_ITEM, this.actionType, (float)amount, false));
        }
        return Math.round(RecipeModifier.applyModifiers(context, RequirementTypesMM.REQUIREMENT_ITEM, this.actionType, (float)maxAmount, false));
    }

    protected ChancedIngredientStack selectRandomStack() {
        float totalChance = 0.0f;
        for (ChancedIngredientStack ingredient : this.ingredients) {
            totalChance += ingredient.chance;
        }
        float randomChance = RequirementItem.RD.nextFloat() * totalChance;
        float chanceCount = 0.0f;
        ChancedIngredientStack selected = null;
        for (ChancedIngredientStack ingredient : this.ingredients) {
            if (!((chanceCount += ingredient.chance) >= randomChance)) continue;
            selected = ingredient;
            break;
        }
        if (selected == null) {
            ModularMachinery.log.warn("[MM-RequirementIngredientArray] Invalid selected stack! totalChance: " + totalChance + ", randomChance: " + randomChance);
        }
        return selected;
    }

    protected ChancedIngredientStack selectMaxCountStack() {
        ChancedIngredientStack selected = null;
        for (ChancedIngredientStack ingredient : this.ingredients) {
            if (selected == null) {
                selected = ingredient;
                continue;
            }
            if (ingredient.maxCount <= selected.maxCount) continue;
            selected = ingredient;
        }
        return selected;
    }

    public List<ChancedIngredientStack> getIngredients() {
        return Collections.unmodifiableList(this.ingredients);
    }
}

